var createError = require('http-errors');
var express = require('express');
const multer = require('multer');
var path = require('path');
var cookieParser = require('cookie-parser');
var logger = require('morgan');
const cors = require('cors');
var bodyParser = require('body-parser');
require('dotenv').config();
const verifyToken = require('./middleware/verifyToken'); 
var indexRouter = require('./routes/index');
var usersRouter = require('./routes/users');
var authRouter = require('./routes/authProcess');
var searchRouter = require('./routes/search');
var uploadRouter = require('./routes/upload');
var getDataRouter = require('./routes/getData');
var createProcessRouter = require('./routes/createProcess');
var deleteRouter = require('./routes/deleteProcess');
var couponRouter = require('./routes/couponProcess');
var checkoutRouter = require('./routes/checkoutProcess');

const upload = multer({
    storage: multer.memoryStorage(),
    limits: { fileSize: 10 * 1024 * 1024 }, // 10 MB limit
});

var app = express();


// view engine setup
app.set('views', path.join(__dirname, 'views'));
app.set('view engine', 'jade');

app.use(cors({
  origin: 'http://localhost:3000', // or your frontend URL
  credentials: true,
}));
app.use(logger('dev'));
app.use(express.json());
// app.use(express.urlencoded({ extended: false }));
app.use(cookieParser());
app.use(express.static(path.join(__dirname, 'public')));
app.use(bodyParser.urlencoded({ extended: false }));
app.use(express.urlencoded({ extended: true }));


app.use('/', indexRouter);
app.use('/users', verifyToken, usersRouter);
app.use('/auth', authRouter);

// Apply token middleware to protected routes
app.use('/delprocess', verifyToken, (req, res) => { 
  deleteRouter(req, res);
});
app.use('/search', (req, res) => {
  searchRouter(req, res);
});
app.use('/getdata', verifyToken, (req, res) => {
  getDataRouter(req, res);
});
app.use('/createprocess', verifyToken, (req, res) => {
  createProcessRouter(req, res);
});
app.use('/coupons', verifyToken, (req, res) => {
  couponRouter(req, res);
});
app.use('/checkout', verifyToken, (req, res) => {
  checkoutRouter(req, res);
});
app.use('/upload', verifyToken, upload.single('file'), (req, res) => {
  uploadRouter(req, res);
});
// catch 404 and forward to error handler
app.use(function(req, res, next) {
  next(createError(404));
});

// error handler
app.use(function(err, req, res, next) {
  // set locals, only providing error in development
  res.locals.message = err.message;
  res.locals.error = req.app.get('env') === 'development' ? err : {};

  // render the error page
  res.status(err.status || 500);
  res.render('error');
});

module.exports = app;
