var express = require('express');
var router = express.Router();
const { MongoClient, ObjectId } = require('mongodb');
const crypto = require('crypto');
const jwt = require('jsonwebtoken');
var dburl = process.env.MONGODB_URL;
// console.log('MONGODB_URL:', dburl);


/* GET home page. */
router.post('/signup', async function(req, res, next) {
  const client = new MongoClient(dburl);
  try {
    await client.connect();
    const db = client.db(); // defaults to 'authorguard' from the URL
    const collection = db.collection('users');

    const { name, email, password, userType } = req.body;

    // Basic validation
    if (!name || !email || !password || !userType) {
      return res.status(400).json({ error: "All fields are required." });
    }

    // Check if user already exists
    const existingUser = await collection.findOne({ email });
    if (existingUser) {
      return res.status(409).json({ error: "Email already registered." });
    }

    // Hash password with MD5
    const md5Password = crypto.createHash('md5').update(password).digest('hex');

    // Store user
    const result = await collection.insertOne({
      name,
      email,
      password: md5Password,
      userType,
      createdAt: new Date()
    });

    res.json({ message: "Signup successful!", userId: result.insertedId });
  } catch (err) {
    res.status(500).json({ error: "Internal server error." });
  } finally {
    await client.close();
  }
}
);

// Secondary process creation endpoint
router.post('/signin', async function(req, res, next) {
  const client = new MongoClient(dburl);
  try {
    await client.connect();
    const db = client.db();
    const collection = db.collection('users');
    const collection_activity = db.collection('activity_log');

    const { email, password, ip } = req.body;

    // Basic validation
    if (!email || !password) {
      return res.status(400).json({ error: "Email and password are required." });
    }

    // Hash the incoming password with MD5
    const md5Password = crypto.createHash('md5').update(password).digest('hex');

    // Find user by email and hashed password
    const user = await collection.findOne({ email, password: md5Password });

    if (!user) {
      return res.status(401).json({ error: "Invalid email or password." });
    }

    // Generate JWT token
    const token = jwt.sign(
      { userId: user._id, name: user.name, userType: user.userType },
      process.env.JWT_SECRET || 'your_jwt_secret', // Use env or fallback
      { expiresIn: '7d' }
    );
    // const ip =
    // req.headers["x-forwarded-for"]?.split(",")[0] ||
    // req.socket?.remoteAddress ||
    // null;
    // console.log("IP Address:", ip);
    
    // Log the activity
    await collection_activity.insertOne({
      userId: user._id,
      action: 'login',
      timestamp: new Date(),
      details: `User ${user.name} logged in successfully.`,
      type: `Login`,
      ip: ip // Capture the IP address
    });
    res.json({
      message: "Login successful!",
      userId: user._id,
      name: user.name,
      userType: user.userType,
      token // Return the token
    });
  } catch (err) {
    res.status(500).json({ error: "Internal server error." });
  } finally {
    await client.close();
  }
});




module.exports = router;
