var _WebAssembly$2 = typeof WebAssembly !== 'undefined'
    ? WebAssembly
    : typeof WXWebAssembly !== 'undefined'
        ? WXWebAssembly
        : undefined;
var ENVIRONMENT_IS_NODE = null !== null;
function getPostMessage(options) {
    return typeof (options === null || options === void 0 ? void 0 : options.postMessage) === 'function'
        ? options.postMessage
        : typeof postMessage === 'function'
            ? postMessage
            : undefined;
}
function serizeErrorToBuffer(sab, code, error) {
    var i32array = new Int32Array(sab);
    Atomics.store(i32array, 0, code);
    if (code > 1 && error) {
        var name_1 = error.name;
        var message = error.message;
        var stack = error.stack;
        var nameBuffer = new TextEncoder().encode(name_1);
        var messageBuffer = new TextEncoder().encode(message);
        var stackBuffer = new TextEncoder().encode(stack);
        Atomics.store(i32array, 1, nameBuffer.length);
        Atomics.store(i32array, 2, messageBuffer.length);
        Atomics.store(i32array, 3, stackBuffer.length);
        var buffer = new Uint8Array(sab);
        buffer.set(nameBuffer, 16);
        buffer.set(messageBuffer, 16 + nameBuffer.length);
        buffer.set(stackBuffer, 16 + nameBuffer.length + messageBuffer.length);
    }
}
function deserizeErrorFromBuffer(sab) {
    var _a, _b;
    var i32array = new Int32Array(sab);
    var status = Atomics.load(i32array, 0);
    if (status <= 1) {
        return null;
    }
    var nameLength = Atomics.load(i32array, 1);
    var messageLength = Atomics.load(i32array, 2);
    var stackLength = Atomics.load(i32array, 3);
    var buffer = new Uint8Array(sab);
    var nameBuffer = buffer.slice(16, 16 + nameLength);
    var messageBuffer = buffer.slice(16 + nameLength, 16 + nameLength + messageLength);
    var stackBuffer = buffer.slice(16 + nameLength + messageLength, 16 + nameLength + messageLength + stackLength);
    var name = new TextDecoder().decode(nameBuffer);
    var message = new TextDecoder().decode(messageBuffer);
    var stack = new TextDecoder().decode(stackBuffer);
    var ErrorConstructor = (_a = globalThis[name]) !== null && _a !== void 0 ? _a : (name === 'RuntimeError' ? ((_b = _WebAssembly$2.RuntimeError) !== null && _b !== void 0 ? _b : Error) : Error);
    var error = new ErrorConstructor(message);
    Object.defineProperty(error, 'stack', {
        value: stack,
        writable: true,
        enumerable: false,
        configurable: true
    });
    return error;
}
/** @public */
function isSharedArrayBuffer(value) {
    return ((typeof SharedArrayBuffer === 'function' && value instanceof SharedArrayBuffer) ||
        (Object.prototype.toString.call(value.constructor) === '[object SharedArrayBuffer]'));
}
/** @public */
function isTrapError(e) {
    try {
        return e instanceof _WebAssembly$2.RuntimeError;
    }
    catch (_) {
        return false;
    }
}

function createMessage(type, payload) {
    return {
        __emnapi__: {
            type: type,
            payload: payload
        }
    };
}

var WASI_THREADS_MAX_TID = 0x1FFFFFFF;
function checkSharedWasmMemory(wasmMemory) {
    if (wasmMemory) {
        if (!isSharedArrayBuffer(wasmMemory.buffer)) {
            throw new Error('Multithread features require shared wasm memory. ' +
                'Try to compile with `-matomics -mbulk-memory` and use `--import-memory --shared-memory` during linking, ' +
                'then create WebAssembly.Memory with `shared: true` option');
        }
    }
    else {
        if (typeof SharedArrayBuffer === 'undefined') {
            throw new Error('Current environment does not support SharedArrayBuffer, threads are not available!');
        }
    }
}
function getReuseWorker(value) {
    var _a;
    if (typeof value === 'boolean') {
        return value ? { size: 0, strict: false } : false;
    }
    if (typeof value === 'number') {
        if (!(value >= 0)) {
            throw new RangeError('reuseWorker: size must be a non-negative integer');
        }
        return { size: value, strict: false };
    }
    if (!value) {
        return false;
    }
    var size = (_a = Number(value.size)) !== null && _a !== void 0 ? _a : 0;
    var strict = Boolean(value.strict);
    if (!(size > 0) && strict) {
        throw new RangeError('reuseWorker: size must be set to positive integer if strict is set to true');
    }
    return { size: size, strict: strict };
}
var nextWorkerID = 0;
/** @public */
var ThreadManager = /*#__PURE__*/ (function () {
    function ThreadManager(options) {
        var _a;
        this.unusedWorkers = [];
        this.runningWorkers = [];
        this.pthreads = Object.create(null);
        this.wasmModule = null;
        this.wasmMemory = null;
        this.messageEvents = new WeakMap();
        if (!options) {
            throw new TypeError('ThreadManager(): options is not provided');
        }
        if ('childThread' in options) {
            this._childThread = Boolean(options.childThread);
        }
        else {
            this._childThread = false;
        }
        if (this._childThread) {
            this._onCreateWorker = undefined;
            this._reuseWorker = false;
            this._beforeLoad = undefined;
        }
        else {
            this._onCreateWorker = options.onCreateWorker;
            this._reuseWorker = getReuseWorker(options.reuseWorker);
            this._beforeLoad = options.beforeLoad;
        }
        this.printErr = (_a = options.printErr) !== null && _a !== void 0 ? _a : console.error.bind(console);
    }
    Object.defineProperty(ThreadManager.prototype, "nextWorkerID", {
        get: function () { return nextWorkerID; },
        enumerable: false,
        configurable: true
    });
    ThreadManager.prototype.init = function () {
        if (!this._childThread) {
            this.initMainThread();
        }
    };
    ThreadManager.prototype.initMainThread = function () {
        this.preparePool();
    };
    ThreadManager.prototype.preparePool = function () {
        if (this._reuseWorker) {
            if (this._reuseWorker.size) {
                var pthreadPoolSize = this._reuseWorker.size;
                while (pthreadPoolSize--) {
                    this.allocateUnusedWorker();
                }
            }
        }
    };
    ThreadManager.prototype.shouldPreloadWorkers = function () {
        return !this._childThread && this._reuseWorker && this._reuseWorker.size > 0;
    };
    ThreadManager.prototype.loadWasmModuleToAllWorkers = function () {
        var _this_1 = this;
        var promises = Array(this.unusedWorkers.length);
        var _loop_1 = function (i) {
            var worker = this_1.unusedWorkers[i];
            promises[i] = this_1.loadWasmModuleToWorker(worker).then(function (w) {
                return w;
            }, function (e) {
                throw e;
            });
        };
        var this_1 = this;
        for (var i = 0; i < this.unusedWorkers.length; ++i) {
            _loop_1(i);
        }
        return Promise.all(promises).catch(function (err) {
            _this_1.terminateAllThreads();
            throw err;
        });
    };
    ThreadManager.prototype.preloadWorkers = function () {
        if (this.shouldPreloadWorkers()) {
            return this.loadWasmModuleToAllWorkers();
        }
        return Promise.resolve([]);
    };
    ThreadManager.prototype.setup = function (wasmModule, wasmMemory) {
        this.wasmModule = wasmModule;
        this.wasmMemory = wasmMemory;
    };
    ThreadManager.prototype.markId = function (worker) {
        if (worker.__emnapi_tid)
            return worker.__emnapi_tid;
        var tid = nextWorkerID + 43;
        nextWorkerID = (nextWorkerID + 1) % (WASI_THREADS_MAX_TID - 42);
        this.pthreads[tid] = worker;
        worker.__emnapi_tid = tid;
        return tid;
    };
    ThreadManager.prototype.returnWorkerToPool = function (worker) {
        var tid = worker.__emnapi_tid;
        if (tid !== undefined) {
            delete this.pthreads[tid];
        }
        this.unusedWorkers.push(worker);
        this.runningWorkers.splice(this.runningWorkers.indexOf(worker), 1);
        delete worker.__emnapi_tid;
    };
    ThreadManager.prototype.loadWasmModuleToWorker = function (worker, sab) {
        var _this_1 = this;
        if (worker.whenLoaded)
            return worker.whenLoaded;
        var err = this.printErr;
        var beforeLoad = this._beforeLoad;
        // eslint-disable-next-line @typescript-eslint/no-this-alias
        var _this = this;
        worker.whenLoaded = new Promise(function (resolve, reject) {
            var handleError = function (e) {
                var message = 'worker sent an error!';
                if (worker.__emnapi_tid !== undefined) {
                    message = 'worker (tid = ' + worker.__emnapi_tid + ') sent an error!';
                }
                err(message + ' ' + e.message);
                if (e.message.indexOf('RuntimeError') !== -1 || e.message.indexOf('unreachable') !== -1) {
                    try {
                        _this.terminateAllThreads();
                    }
                    catch (_) { }
                }
                reject(e);
                throw e;
            };
            var handleMessage = function (data) {
                if (data.__emnapi__) {
                    var type = data.__emnapi__.type;
                    var payload = data.__emnapi__.payload;
                    if (type === 'loaded') {
                        worker.loaded = true;
                        resolve(worker);
                        // if (payload.err) {
                        //   err('failed to load in child thread: ' + (payload.err.message || payload.err))
                        // }
                    }
                    else if (type === 'cleanup-thread') {
                        if (payload.tid in _this_1.pthreads) {
                            _this_1.cleanThread(worker, payload.tid);
                        }
                    }
                }
            };
            worker.onmessage = function (e) {
                handleMessage(e.data);
                _this_1.fireMessageEvent(worker, e);
            };
            worker.onerror = handleError;
            if (typeof beforeLoad === 'function') {
                beforeLoad(worker);
            }
            try {
                worker.postMessage(createMessage('load', {
                    wasmModule: _this_1.wasmModule,
                    wasmMemory: _this_1.wasmMemory,
                    sab: sab
                }));
            }
            catch (err) {
                checkSharedWasmMemory(_this_1.wasmMemory);
                throw err;
            }
        });
        return worker.whenLoaded;
    };
    ThreadManager.prototype.allocateUnusedWorker = function () {
        var _onCreateWorker = this._onCreateWorker;
        if (typeof _onCreateWorker !== 'function') {
            throw new TypeError('`options.onCreateWorker` is not provided');
        }
        var worker = _onCreateWorker({ type: 'thread', name: 'emnapi-pthread' });
        this.unusedWorkers.push(worker);
        return worker;
    };
    ThreadManager.prototype.getNewWorker = function (sab) {
        if (this._reuseWorker) {
            if (this.unusedWorkers.length === 0) {
                if (this._reuseWorker.strict) {
                    {
                        var err = this.printErr;
                        err('Tried to spawn a new thread, but the thread pool is exhausted.\n' +
                            'This might result in a deadlock unless some threads eventually exit or the code explicitly breaks out to the event loop.');
                        return;
                    }
                }
                var worker_1 = this.allocateUnusedWorker();
                // eslint-disable-next-line @typescript-eslint/no-floating-promises
                this.loadWasmModuleToWorker(worker_1, sab);
            }
            return this.unusedWorkers.pop();
        }
        var worker = this.allocateUnusedWorker();
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.loadWasmModuleToWorker(worker, sab);
        return this.unusedWorkers.pop();
    };
    ThreadManager.prototype.cleanThread = function (worker, tid, force) {
        if (!force && this._reuseWorker) {
            this.returnWorkerToPool(worker);
        }
        else {
            delete this.pthreads[tid];
            var index = this.runningWorkers.indexOf(worker);
            if (index !== -1) {
                this.runningWorkers.splice(index, 1);
            }
            this.terminateWorker(worker);
            delete worker.__emnapi_tid;
        }
    };
    ThreadManager.prototype.terminateWorker = function (worker) {
        var _this_1 = this;
        var _a;
        var tid = worker.__emnapi_tid;
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        worker.terminate();
        (_a = this.messageEvents.get(worker)) === null || _a === void 0 ? void 0 : _a.clear();
        this.messageEvents.delete(worker);
        worker.onmessage = function (e) {
            if (e.data.__emnapi__) {
                var err = _this_1.printErr;
                err('received "' + e.data.__emnapi__.type + '" command from terminated worker: ' + tid);
            }
        };
    };
    ThreadManager.prototype.terminateAllThreads = function () {
        for (var i = 0; i < this.runningWorkers.length; ++i) {
            this.terminateWorker(this.runningWorkers[i]);
        }
        for (var i = 0; i < this.unusedWorkers.length; ++i) {
            this.terminateWorker(this.unusedWorkers[i]);
        }
        this.unusedWorkers = [];
        this.runningWorkers = [];
        this.pthreads = Object.create(null);
        this.preparePool();
    };
    ThreadManager.prototype.addMessageEventListener = function (worker, onMessage) {
        var listeners = this.messageEvents.get(worker);
        if (!listeners) {
            listeners = new Set();
            this.messageEvents.set(worker, listeners);
        }
        listeners.add(onMessage);
        return function () {
            listeners === null || listeners === void 0 ? void 0 : listeners.delete(onMessage);
        };
    };
    ThreadManager.prototype.fireMessageEvent = function (worker, e) {
        var listeners = this.messageEvents.get(worker);
        if (!listeners)
            return;
        var err = this.printErr;
        listeners.forEach(function (listener) {
            try {
                listener(e);
            }
            catch (e) {
                err(e.stack);
            }
        });
    };
    return ThreadManager;
}());

var kIsProxy = Symbol('kIsProxy');
/** @public */
function createInstanceProxy(instance, memory) {
    if (instance[kIsProxy])
        return instance;
    // https://github.com/nodejs/help/issues/4102
    var originalExports = instance.exports;
    var createHandler = function (target) {
        var handlers = [
            'apply',
            'construct',
            'defineProperty',
            'deleteProperty',
            'get',
            'getOwnPropertyDescriptor',
            'getPrototypeOf',
            'has',
            'isExtensible',
            'ownKeys',
            'preventExtensions',
            'set',
            'setPrototypeOf'
        ];
        var handler = {};
        var _loop_1 = function (i) {
            var name_1 = handlers[i];
            handler[name_1] = function () {
                var args = Array.prototype.slice.call(arguments, 1);
                args.unshift(target);
                return Reflect[name_1].apply(Reflect, args);
            };
        };
        for (var i = 0; i < handlers.length; i++) {
            _loop_1(i);
        }
        return handler;
    };
    var handler = createHandler(originalExports);
    var _initialize = function () { };
    var _start = function () { return 0; };
    handler.get = function (_target, p, receiver) {
        var _a;
        if (p === 'memory') {
            return (_a = (typeof memory === 'function' ? memory() : memory)) !== null && _a !== void 0 ? _a : Reflect.get(originalExports, p, receiver);
        }
        if (p === '_initialize') {
            return p in originalExports ? _initialize : undefined;
        }
        if (p === '_start') {
            return p in originalExports ? _start : undefined;
        }
        return Reflect.get(originalExports, p, receiver);
    };
    handler.has = function (_target, p) {
        if (p === 'memory')
            return true;
        return Reflect.has(originalExports, p);
    };
    var exportsProxy = new Proxy(Object.create(null), handler);
    return new Proxy(instance, {
        get: function (target, p, receiver) {
            if (p === 'exports') {
                return exportsProxy;
            }
            if (p === kIsProxy) {
                return true;
            }
            return Reflect.get(target, p, receiver);
        }
    });
}

var patchedWasiInstances = new WeakMap();
/** @public */
var WASIThreads = /*#__PURE__*/ (function () {
    function WASIThreads(options) {
        var _this_1 = this;
        if (!options) {
            throw new TypeError('WASIThreads(): options is not provided');
        }
        if (!options.wasi) {
            throw new TypeError('WASIThreads(): options.wasi is not provided');
        }
        patchedWasiInstances.set(this, new WeakSet());
        var wasi = options.wasi;
        patchWasiInstance(this, wasi);
        this.wasi = wasi;
        if ('childThread' in options) {
            this.childThread = Boolean(options.childThread);
        }
        else {
            this.childThread = false;
        }
        this.PThread = undefined;
        if ('threadManager' in options) {
            if (typeof options.threadManager === 'function') {
                this.PThread = options.threadManager();
            }
            else {
                this.PThread = options.threadManager;
            }
        }
        else {
            if (!this.childThread) {
                this.PThread = new ThreadManager(options);
                this.PThread.init();
            }
        }
        var waitThreadStart = false;
        if ('waitThreadStart' in options) {
            waitThreadStart = typeof options.waitThreadStart === 'number' ? options.waitThreadStart : Boolean(options.waitThreadStart);
        }
        var postMessage = getPostMessage(options);
        if (this.childThread && typeof postMessage !== 'function') {
            throw new TypeError('options.postMessage is not a function');
        }
        this.postMessage = postMessage;
        var wasm64 = Boolean(options.wasm64);
        var onMessage = function (e) {
            if (e.data.__emnapi__) {
                var type = e.data.__emnapi__.type;
                var payload = e.data.__emnapi__.payload;
                if (type === 'spawn-thread') {
                    threadSpawn(payload.startArg, payload.errorOrTid);
                }
                else if (type === 'terminate-all-threads') {
                    _this_1.terminateAllThreads();
                }
            }
        };
        var threadSpawn = function (startArg, errorOrTid) {
            var _a;
            var EAGAIN = 6;
            var isNewABI = errorOrTid !== undefined;
            try {
                checkSharedWasmMemory(_this_1.wasmMemory);
            }
            catch (err) {
                (_a = _this_1.PThread) === null || _a === void 0 ? void 0 : _a.printErr(err.stack);
                if (isNewABI) {
                    var struct_1 = new Int32Array(_this_1.wasmMemory.buffer, errorOrTid, 2);
                    Atomics.store(struct_1, 0, 1);
                    Atomics.store(struct_1, 1, EAGAIN);
                    Atomics.notify(struct_1, 1);
                    return 1;
                }
                else {
                    return -6;
                }
            }
            if (!isNewABI) {
                var malloc = _this_1.wasmInstance.exports.malloc;
                errorOrTid = wasm64 ? Number(malloc(BigInt(8))) : malloc(8);
                if (!errorOrTid) {
                    return -48; /* ENOMEM */
                }
            }
            var _free = _this_1.wasmInstance.exports.free;
            var free = wasm64 ? function (ptr) { _free(BigInt(ptr)); } : _free;
            var struct = new Int32Array(_this_1.wasmMemory.buffer, errorOrTid, 2);
            Atomics.store(struct, 0, 0);
            Atomics.store(struct, 1, 0);
            if (_this_1.childThread) {
                postMessage(createMessage('spawn-thread', {
                    startArg: startArg,
                    errorOrTid: errorOrTid
                }));
                Atomics.wait(struct, 1, 0);
                var isError = Atomics.load(struct, 0);
                var result = Atomics.load(struct, 1);
                if (isNewABI) {
                    return isError;
                }
                free(errorOrTid);
                return isError ? -result : result;
            }
            var shouldWait = waitThreadStart || (waitThreadStart === 0);
            var sab;
            if (shouldWait) {
                sab = new Int32Array(new SharedArrayBuffer(16 + 8192));
                Atomics.store(sab, 0, 0);
            }
            var worker;
            var tid;
            var PThread = _this_1.PThread;
            try {
                worker = PThread.getNewWorker(sab);
                if (!worker) {
                    throw new Error('failed to get new worker');
                }
                PThread.addMessageEventListener(worker, onMessage);
                tid = PThread.markId(worker);
                if (ENVIRONMENT_IS_NODE) ;
                worker.postMessage(createMessage('start', {
                    tid: tid,
                    arg: startArg,
                    sab: sab
                }));
                if (shouldWait) {
                    if (typeof waitThreadStart === 'number') {
                        var waitResult = Atomics.wait(sab, 0, 0, waitThreadStart);
                        if (waitResult === 'timed-out') {
                            try {
                                PThread.cleanThread(worker, tid, true);
                            }
                            catch (_) { }
                            throw new Error('Spawning thread timed out. Please check if the worker is created successfully and if message is handled properly in the worker.');
                        }
                    }
                    else {
                        Atomics.wait(sab, 0, 0);
                    }
                    var r = Atomics.load(sab, 0);
                    if (r > 1) {
                        try {
                            PThread.cleanThread(worker, tid, true);
                        }
                        catch (_) { }
                        throw deserizeErrorFromBuffer(sab.buffer);
                    }
                }
            }
            catch (e) {
                Atomics.store(struct, 0, 1);
                Atomics.store(struct, 1, EAGAIN);
                Atomics.notify(struct, 1);
                PThread === null || PThread === void 0 ? void 0 : PThread.printErr(e.stack);
                if (isNewABI) {
                    return 1;
                }
                free(errorOrTid);
                return -6;
            }
            Atomics.store(struct, 0, 0);
            Atomics.store(struct, 1, tid);
            Atomics.notify(struct, 1);
            PThread.runningWorkers.push(worker);
            if (!shouldWait) {
                worker.whenLoaded.catch(function (err) {
                    delete worker.whenLoaded;
                    PThread.cleanThread(worker, tid, true);
                    throw err;
                });
            }
            if (isNewABI) {
                return 0;
            }
            free(errorOrTid);
            return tid;
        };
        this.threadSpawn = threadSpawn;
    }
    WASIThreads.prototype.getImportObject = function () {
        return {
            wasi: {
                'thread-spawn': this.threadSpawn
            }
        };
    };
    WASIThreads.prototype.setup = function (wasmInstance, wasmModule, wasmMemory) {
        wasmMemory !== null && wasmMemory !== void 0 ? wasmMemory : (wasmMemory = wasmInstance.exports.memory);
        this.wasmInstance = wasmInstance;
        this.wasmMemory = wasmMemory;
        if (this.PThread) {
            this.PThread.setup(wasmModule, wasmMemory);
        }
    };
    WASIThreads.prototype.preloadWorkers = function () {
        if (this.PThread) {
            return this.PThread.preloadWorkers();
        }
        return Promise.resolve([]);
    };
    /**
     * It's ok to call this method to a WASI command module.
     *
     * in child thread, must call this method instead of {@link WASIThreads.start} even if it's a WASI command module
     *
     * @returns A proxied WebAssembly instance if in child thread, other wise the original instance
     */
    WASIThreads.prototype.initialize = function (instance, module, memory) {
        var exports = instance.exports;
        memory !== null && memory !== void 0 ? memory : (memory = exports.memory);
        if (this.childThread) {
            instance = createInstanceProxy(instance, memory);
        }
        this.setup(instance, module, memory);
        var wasi = this.wasi;
        if (('_start' in exports) && (typeof exports._start === 'function')) {
            if (this.childThread) {
                wasi.start(instance);
                try {
                    var kStarted = getWasiSymbol(wasi, 'kStarted');
                    wasi[kStarted] = false;
                }
                catch (_) { }
            }
            else {
                setupInstance$1(wasi, instance);
            }
        }
        else {
            wasi.initialize(instance);
        }
        return instance;
    };
    /**
     * Equivalent to calling {@link WASIThreads.initialize} and then calling {@link WASIInstance.start}
     * ```js
     * this.initialize(instance, module, memory)
     * this.wasi.start(instance)
     * ```
     */
    WASIThreads.prototype.start = function (instance, module, memory) {
        var exports = instance.exports;
        memory !== null && memory !== void 0 ? memory : (memory = exports.memory);
        if (this.childThread) {
            instance = createInstanceProxy(instance, memory);
        }
        this.setup(instance, module, memory);
        var exitCode = this.wasi.start(instance);
        return { exitCode: exitCode, instance: instance };
    };
    WASIThreads.prototype.terminateAllThreads = function () {
        var _a;
        if (!this.childThread) {
            (_a = this.PThread) === null || _a === void 0 ? void 0 : _a.terminateAllThreads();
        }
        else {
            this.postMessage(createMessage('terminate-all-threads', {}));
        }
    };
    return WASIThreads;
}());
function patchWasiInstance(wasiThreads, wasi) {
    var patched = patchedWasiInstances.get(wasiThreads);
    if (patched.has(wasi)) {
        return;
    }
    var _this = wasiThreads;
    var wasiImport = wasi.wasiImport;
    if (wasiImport) {
        var proc_exit_1 = wasiImport.proc_exit;
        wasiImport.proc_exit = function (code) {
            _this.terminateAllThreads();
            return proc_exit_1.call(this, code);
        };
    }
    var start = wasi.start;
    if (typeof start === 'function') {
        wasi.start = function (instance) {
            try {
                return start.call(this, instance);
            }
            catch (err) {
                if (isTrapError(err)) {
                    _this.terminateAllThreads();
                }
                throw err;
            }
        };
    }
    patched.add(wasi);
}
function getWasiSymbol(wasi, description) {
    var symbols = Object.getOwnPropertySymbols(wasi);
    var selectDescription = function (description) { return function (s) {
        if (s.description) {
            return s.description === description;
        }
        return s.toString() === "Symbol(".concat(description, ")");
    }; };
    if (Array.isArray(description)) {
        return description.map(function (d) { return symbols.filter(selectDescription(d))[0]; });
    }
    return symbols.filter(selectDescription(description))[0];
}
function setupInstance$1(wasi, instance) {
    var _a = getWasiSymbol(wasi, ['kInstance', 'kSetMemory']), kInstance = _a[0], kSetMemory = _a[1];
    wasi[kInstance] = instance;
    wasi[kSetMemory](instance.exports.memory);
}

/** @public */
var ThreadMessageHandler = /*#__PURE__*/ (function () {
    function ThreadMessageHandler(options) {
        var postMsg = getPostMessage(options);
        if (typeof postMsg !== 'function') {
            throw new TypeError('options.postMessage is not a function');
        }
        this.postMessage = postMsg;
        this.onLoad = options === null || options === void 0 ? void 0 : options.onLoad;
        this.instance = undefined;
        // this.module = undefined
        this.messagesBeforeLoad = [];
    }
    /** @virtual */
    ThreadMessageHandler.prototype.instantiate = function (data) {
        if (typeof this.onLoad === 'function') {
            return this.onLoad(data);
        }
        throw new Error('ThreadMessageHandler.prototype.instantiate is not implemented');
    };
    /** @virtual */
    ThreadMessageHandler.prototype.handle = function (e) {
        var _this = this;
        var _a;
        if ((_a = e === null || e === void 0 ? void 0 : e.data) === null || _a === void 0 ? void 0 : _a.__emnapi__) {
            var type = e.data.__emnapi__.type;
            var payload_1 = e.data.__emnapi__.payload;
            if (type === 'load') {
                this._load(payload_1);
            }
            else if (type === 'start') {
                this.handleAfterLoad(e, function () {
                    _this._start(payload_1);
                });
            }
        }
    };
    ThreadMessageHandler.prototype._load = function (payload) {
        var _this = this;
        if (this.instance !== undefined)
            return;
        var source;
        try {
            source = this.instantiate(payload);
        }
        catch (err) {
            this._loaded(err, null, payload);
            return;
        }
        var then = source && 'then' in source ? source.then : undefined;
        if (typeof then === 'function') {
            // eslint-disable-next-line @typescript-eslint/no-floating-promises
            then.call(source, function (source) { _this._loaded(null, source, payload); }, function (err) { _this._loaded(err, null, payload); });
        }
        else {
            this._loaded(null, source, payload);
        }
    };
    ThreadMessageHandler.prototype._start = function (payload) {
        if (typeof this.instance.exports.wasi_thread_start !== 'function') {
            var err = new TypeError('wasi_thread_start is not exported');
            notifyPthreadCreateResult(payload.sab, 2, err);
            throw err;
        }
        var postMessage = this.postMessage;
        var tid = payload.tid;
        var startArg = payload.arg;
        notifyPthreadCreateResult(payload.sab, 1);
        try {
            this.instance.exports.wasi_thread_start(tid, startArg);
        }
        catch (err) {
            if (isTrapError(err)) {
                postMessage(createMessage('terminate-all-threads', {}));
            }
            throw err;
        }
        postMessage(createMessage('cleanup-thread', { tid: tid }));
    };
    ThreadMessageHandler.prototype._loaded = function (err, source, payload) {
        if (err) {
            notifyPthreadCreateResult(payload.sab, 2, err);
            throw err;
        }
        if (source == null) {
            var err_1 = new TypeError('onLoad should return an object');
            notifyPthreadCreateResult(payload.sab, 2, err_1);
            throw err_1;
        }
        var instance = source.instance;
        if (!instance) {
            var err_2 = new TypeError('onLoad should return an object which includes "instance"');
            notifyPthreadCreateResult(payload.sab, 2, err_2);
            throw err_2;
        }
        this.instance = instance;
        var postMessage = this.postMessage;
        postMessage(createMessage('loaded', {}));
        var messages = this.messagesBeforeLoad;
        this.messagesBeforeLoad = [];
        for (var i = 0; i < messages.length; i++) {
            var data = messages[i];
            this.handle({ data: data });
        }
    };
    ThreadMessageHandler.prototype.handleAfterLoad = function (e, f) {
        if (this.instance !== undefined) {
            f.call(this, e);
        }
        else {
            this.messagesBeforeLoad.push(e.data);
        }
    };
    return ThreadMessageHandler;
}());
function notifyPthreadCreateResult(sab, result, error) {
    if (sab) {
        serizeErrorToBuffer(sab.buffer, result, error);
        Atomics.notify(sab, 0);
    }
}

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol, Iterator */

var extendStatics = function(d, b) {
  extendStatics = Object.setPrototypeOf ||
      ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
      function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
  return extendStatics(d, b);
};

function __extends(d, b) {
  if (typeof b !== "function" && b !== null)
      throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
  extendStatics(d, b);
  function __() { this.constructor = d; }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
  var e = new Error(message);
  return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

/* eslint-disable no-undef */
var _WebAssembly$1 = typeof WebAssembly !== 'undefined'
    ? WebAssembly
    : typeof WXWebAssembly !== 'undefined'
        ? WXWebAssembly
        : undefined;
function validateImports(imports) {
    if (imports && typeof imports !== 'object') {
        throw new TypeError('imports must be an object or undefined');
    }
    return true;
}
function load(wasmInput, imports) {
    if (!wasmInput)
        throw new TypeError('Invalid wasm source');
    validateImports(imports);
    imports = imports !== null && imports !== void 0 ? imports : {};
    // Promise<string | URL | Response | BufferSource | WebAssembly.Module>
    try {
        var then = typeof wasmInput === 'object' && wasmInput !== null && 'then' in wasmInput ? wasmInput.then : undefined;
        if (typeof then === 'function') {
            return then.call(wasmInput, function (input) { return load(input, imports); });
        }
    }
    catch (_) { }
    // BufferSource
    if (wasmInput instanceof ArrayBuffer || ArrayBuffer.isView(wasmInput)) {
        return _WebAssembly$1.instantiate(wasmInput, imports);
    }
    // WebAssembly.Module
    if (wasmInput instanceof _WebAssembly$1.Module) {
        return _WebAssembly$1.instantiate(wasmInput, imports).then(function (instance) {
            return { instance: instance, module: wasmInput };
        });
    }
    // Response
    if (typeof Response !== 'undefined' && wasmInput instanceof Response) {
        return wasmInput.arrayBuffer().then(function (buffer) {
            return _WebAssembly$1.instantiate(buffer, imports);
        });
    }
    // string | URL
    var inputIsString = typeof wasmInput === 'string';
    if (inputIsString || (typeof URL !== 'undefined' && wasmInput instanceof URL)) {
        if (inputIsString && typeof wx !== 'undefined' && typeof __wxConfig !== 'undefined') {
            return _WebAssembly$1.instantiate(wasmInput, imports);
        }
        if (typeof fetch !== 'function') {
            throw new TypeError('wasm source can not be a string or URL in this environment');
        }
        if (typeof _WebAssembly$1.instantiateStreaming === 'function') {
            try {
                return _WebAssembly$1.instantiateStreaming(fetch(wasmInput), imports).catch(function () {
                    return load(fetch(wasmInput), imports);
                });
            }
            catch (_) {
                return load(fetch(wasmInput), imports);
            }
        }
        else {
            return load(fetch(wasmInput), imports);
        }
    }
    throw new TypeError('Invalid wasm source');
}
function loadSync(wasmInput, imports) {
    if (!wasmInput)
        throw new TypeError('Invalid wasm source');
    validateImports(imports);
    imports = imports !== null && imports !== void 0 ? imports : {};
    var module;
    if ((wasmInput instanceof ArrayBuffer) || ArrayBuffer.isView(wasmInput)) {
        module = new _WebAssembly$1.Module(wasmInput);
    }
    else if (wasmInput instanceof WebAssembly.Module) {
        module = wasmInput;
    }
    else {
        throw new TypeError('Invalid wasm source');
    }
    var instance = new _WebAssembly$1.Instance(module, imports);
    var source = { instance: instance, module: module };
    return source;
}

function createNapiModule(options) {
    var napiModule = (function () {
        var ENVIRONMENT_IS_PTHREAD = Boolean(options.childThread);
        var waitThreadStart = typeof options.waitThreadStart === 'number' ? options.waitThreadStart : Boolean(options.waitThreadStart);
        var wasmInstance;
        var wasmMemory;
        var wasmTable;
        var _malloc;
        var _free;
        function abort(msg) {
            if (typeof _WebAssembly$1.RuntimeError === 'function') {
                throw new _WebAssembly$1.RuntimeError(msg);
            }
            throw Error(msg);
        }
        var napiModule = {
            imports: {
                env: {},
                napi: {},
                emnapi: {}
            },
            exports: {},
            emnapi: {},
            loaded: false,
            filename: '',
            childThread: ENVIRONMENT_IS_PTHREAD,
            initWorker: undefined,
            executeAsyncWork: undefined,
            waitThreadStart: waitThreadStart,
            PThread: undefined,
            init: function (options) {
                if (napiModule.loaded)
                    return napiModule.exports;
                if (!options)
                    throw new TypeError('Invalid napi init options');
                var instance = options.instance;
                if (!(instance === null || instance === void 0 ? void 0 : instance.exports))
                    throw new TypeError('Invalid wasm instance');
                wasmInstance = instance;
                var exports = instance.exports;
                var module = options.module;
                var memory = options.memory || exports.memory;
                var table = options.table || exports.__indirect_function_table;
                if (!(module instanceof _WebAssembly$1.Module))
                    throw new TypeError('Invalid wasm module');
                if (!(memory instanceof _WebAssembly$1.Memory))
                    throw new TypeError('Invalid wasm memory');
                if (!(table instanceof _WebAssembly$1.Table))
                    throw new TypeError('Invalid wasm table');
                wasmMemory = memory;
                wasmTable = table;
                if (typeof exports.malloc !== 'function')
                    throw new TypeError('malloc is not exported');
                if (typeof exports.free !== 'function')
                    throw new TypeError('free is not exported');
                _malloc = exports.malloc;
                _free = exports.free;
                if (!napiModule.childThread) {
                    // main thread only
                    var moduleApiVersion = 8 /* Version.NODE_API_DEFAULT_MODULE_API_VERSION */;
                    var node_api_module_get_api_version_v1 = instance.exports.node_api_module_get_api_version_v1;
                    if (typeof node_api_module_get_api_version_v1 === 'function') {
                        moduleApiVersion = node_api_module_get_api_version_v1();
                    }
                    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
                    var envObject = napiModule.envObject || (napiModule.envObject = emnapiCtx.createEnv(napiModule.filename, moduleApiVersion, function (cb) { return (wasmTable.get(cb)); }, function (cb) { return (wasmTable.get(cb)); }, abort, emnapiNodeBinding));
                    var scope_1 = emnapiCtx.openScope(envObject);
                    try {
                        envObject.callIntoModule(function (_envObject) {
                            var exports = napiModule.exports;
                            var exportsHandle = scope_1.add(exports);
                            var napi_register_wasm_v1 = instance.exports.napi_register_wasm_v1;
                            var napiValue = napi_register_wasm_v1(_envObject.id, exportsHandle.id);
                            napiModule.exports = (!napiValue) ? exports : emnapiCtx.handleStore.get(napiValue).value;
                        });
                    }
                    finally {
                        emnapiCtx.closeScope(envObject, scope_1);
                    }
                    napiModule.loaded = true;
                    delete napiModule.envObject;
                    return napiModule.exports;
                }
            }
        };
        var emnapiCtx;
        var emnapiNodeBinding;
        var onCreateWorker = undefined;
        var err;
        if (!ENVIRONMENT_IS_PTHREAD) {
            var context = options.context;
            if (typeof context !== 'object' || context === null) {
                throw new TypeError("Invalid `options.context`. Use `import { getDefaultContext } from '@emnapi/runtime'`");
            }
            emnapiCtx = context;
        }
        else {
            emnapiCtx = options === null || options === void 0 ? void 0 : options.context;
            var postMsg = typeof options.postMessage === 'function'
                ? options.postMessage
                : typeof postMessage === 'function'
                    ? postMessage
                    : undefined;
            if (typeof postMsg !== 'function') {
                throw new TypeError('No postMessage found');
            }
            napiModule.postMessage = postMsg;
        }
        if (typeof options.filename === 'string') {
            napiModule.filename = options.filename;
        }
        if (typeof options.onCreateWorker === 'function') {
            onCreateWorker = options.onCreateWorker;
        }
        if (typeof options.print === 'function') {
            options.print;
        }
        else {
            console.log.bind(console);
        }
        if (typeof options.printErr === 'function') {
            err = options.printErr;
        }
        else {
            err = console.warn.bind(console);
        }
        if ('nodeBinding' in options) {
            var nodeBinding = options.nodeBinding;
            if (typeof nodeBinding !== 'object' || nodeBinding === null) {
                throw new TypeError('Invalid `options.nodeBinding`. Use @emnapi/node-binding package');
            }
            emnapiNodeBinding = nodeBinding;
        }
        var emnapiAsyncWorkPoolSize = 0;
        if ('asyncWorkPoolSize' in options) {
            if (typeof options.asyncWorkPoolSize !== 'number') {
                throw new TypeError('options.asyncWorkPoolSize must be a integer');
            }
            emnapiAsyncWorkPoolSize = options.asyncWorkPoolSize >> 0;
            if (emnapiAsyncWorkPoolSize > 1024) {
                emnapiAsyncWorkPoolSize = 1024;
            }
            else if (emnapiAsyncWorkPoolSize < -1024) {
                emnapiAsyncWorkPoolSize = -1024;
            }
        }
        var singleThreadAsyncWork = ENVIRONMENT_IS_PTHREAD ? false : (emnapiAsyncWorkPoolSize <= 0);
        function _emnapi_async_work_pool_size() {
            return Math.abs(emnapiAsyncWorkPoolSize);
        }
        napiModule.imports.env._emnapi_async_work_pool_size = _emnapi_async_work_pool_size;
        // ------------------------------ pthread -------------------------------
        function emnapiAddSendListener(worker) {
            if (!worker)
                return false;
            if (worker._emnapiSendListener)
                return true;
            var handler = function (e) {
                var data = e.data;
                var __emnapi__ = data.__emnapi__;
                if (__emnapi__ && __emnapi__.type === 'async-send') {
                    if (ENVIRONMENT_IS_PTHREAD) {
                        var postMessage_1 = napiModule.postMessage;
                        postMessage_1({ __emnapi__: __emnapi__ });
                    }
                    else {
                        // eslint-disable-next-line @typescript-eslint/no-unused-vars
                        var callback = __emnapi__.payload.callback;
                        (wasmTable.get(callback))(__emnapi__.payload.data);
                    }
                }
            };
            var dispose = function () {
                {
                    worker.removeEventListener('message', handler, false);
                }
                delete worker._emnapiSendListener;
            };
            worker._emnapiSendListener = { handler: handler, dispose: dispose };
            {
                worker.addEventListener('message', handler, false);
            }
            return true;
        }
        napiModule.emnapi.addSendListener = emnapiAddSendListener;
        var PThread = new ThreadManager(ENVIRONMENT_IS_PTHREAD
            ? {
                printErr: err,
                childThread: true
            }
            : {
                printErr: err,
                beforeLoad: function (worker) {
                    emnapiAddSendListener(worker);
                },
                reuseWorker: options.reuseWorker,
                onCreateWorker: onCreateWorker
            });
        napiModule.PThread = PThread;
        /**
         * @__sig ipiip
         */
        function napi_set_last_error(env, error_code, engine_error_code, engine_reserved) {
            var envObject = emnapiCtx.envStore.get(env);
            return envObject.setLastError(error_code, engine_error_code, engine_reserved);
        }
        /**
         * @__sig ip
         */
        function napi_clear_last_error(env) {
            var envObject = emnapiCtx.envStore.get(env);
            return envObject.clearLastError();
        }
        /**
         * @__sig vppp
         */
        function _emnapi_get_node_version(major, minor, patch) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var versions = [0, 0, 0];
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setUint32(major, versions[0], true);
            HEAP_DATA_VIEW.setUint32(minor, versions[1], true);
            HEAP_DATA_VIEW.setUint32(patch, versions[2], true);
        }
        /**
         * @__sig v
         * @__deps $runtimeKeepalivePush
         */
        function _emnapi_runtime_keepalive_push() {
        }
        /**
         * @__sig v
         * @__deps $runtimeKeepalivePop
         */
        function _emnapi_runtime_keepalive_pop() {
        }
        /**
         * @__sig vpp
         */
        function _emnapi_set_immediate(callback, data) {
            emnapiCtx.feature.setImmediate(function () {
                (wasmTable.get(callback))(data);
            });
        }
        /**
         * @__sig vpp
         */
        function _emnapi_next_tick(callback, data) {
            // eslint-disable-next-line @typescript-eslint/no-floating-promises
            Promise.resolve().then(function () {
                (wasmTable.get(callback))(data);
            });
        }
        /**
         * @__sig vipppi
         */
        function _emnapi_callback_into_module(forceUncaught, env, callback, data, close_scope_if_throw) {
            var envObject = emnapiCtx.envStore.get(env);
            var scope = emnapiCtx.openScope(envObject);
            try {
                envObject.callbackIntoModule(Boolean(forceUncaught), function () {
                    (wasmTable.get(callback))(env, data);
                });
            }
            catch (err) {
                emnapiCtx.closeScope(envObject, scope);
                if (close_scope_if_throw) {
                    emnapiCtx.closeScope(envObject);
                }
                throw err;
            }
            emnapiCtx.closeScope(envObject, scope);
        }
        /**
         * @__sig vipppp
         */
        function _emnapi_call_finalizer(forceUncaught, env, callback, data, hint) {
            var envObject = emnapiCtx.envStore.get(env);
            envObject.callFinalizerInternal(forceUncaught, callback, data, hint);
        }
        /**
         * @__sig v
         */
        function _emnapi_ctx_increase_waiting_request_counter() {
            emnapiCtx.increaseWaitingRequestCounter();
        }
        /**
         * @__sig v
         */
        function _emnapi_ctx_decrease_waiting_request_counter() {
            emnapiCtx.decreaseWaitingRequestCounter();
        }
        function $emnapiSetValueI64(result, numberValue) {
            var tempDouble;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var tempI64 = [
                numberValue >>> 0,
                (tempDouble = numberValue, +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? (Math.min(+Math.floor(tempDouble / 4294967296), 4294967295) | 0) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)
            ];
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, tempI64[0], true);
            HEAP_DATA_VIEW.setInt32(result + 4, tempI64[1], true);
        }
        var utilMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            $emnapiSetValueI64: $emnapiSetValueI64,
            _emnapi_call_finalizer: _emnapi_call_finalizer,
            _emnapi_callback_into_module: _emnapi_callback_into_module,
            _emnapi_ctx_decrease_waiting_request_counter: _emnapi_ctx_decrease_waiting_request_counter,
            _emnapi_ctx_increase_waiting_request_counter: _emnapi_ctx_increase_waiting_request_counter,
            _emnapi_get_node_version: _emnapi_get_node_version,
            _emnapi_next_tick: _emnapi_next_tick,
            _emnapi_runtime_keepalive_pop: _emnapi_runtime_keepalive_pop,
            _emnapi_runtime_keepalive_push: _emnapi_runtime_keepalive_push,
            _emnapi_set_immediate: _emnapi_set_immediate,
            napi_clear_last_error: napi_clear_last_error,
            napi_set_last_error: napi_set_last_error
        });
        function emnapiGetWorkerByPthreadPtr(pthreadPtr) {
            var view = new DataView(wasmMemory.buffer);
            /**
             * wasi-sdk-20.0+threads
             *
             * struct pthread {
             *   struct pthread *self;        // 0
             *   struct pthread *prev, *next; // 4, 8
             *   uintptr_t sysinfo;           // 12
             *   uintptr_t canary;            // 16
             *   int tid;                     // 20
             *   // ...
             * }
             */
            var tidOffset = 20;
            var tid = view.getInt32(pthreadPtr + tidOffset, true);
            var worker = PThread.pthreads[tid];
            return worker;
        }
        /** @__sig vp */
        function _emnapi_worker_unref(pthreadPtr) {
            if (ENVIRONMENT_IS_PTHREAD)
                return;
            var worker = emnapiGetWorkerByPthreadPtr(pthreadPtr);
            if (worker && typeof worker.unref === 'function') {
                worker.unref();
            }
        }
        /** @__sig vipp */
        function _emnapi_async_send_js(type, callback, data) {
            if (ENVIRONMENT_IS_PTHREAD) {
                var postMessage_1 = napiModule.postMessage;
                postMessage_1({
                    __emnapi__: {
                        type: 'async-send',
                        payload: {
                            callback: callback,
                            data: data
                        }
                    }
                });
            }
            else {
                switch (type) {
                    case 0:
                        _emnapi_set_immediate(callback, data);
                        break;
                    case 1:
                        _emnapi_next_tick(callback, data);
                        break;
                }
            }
        }
        // function ptrToString (ptr: number): string {
        //   return '0x' + ('00000000' + ptr.toString(16)).slice(-8)
        // }
        var uvThreadpoolReadyResolve;
        var uvThreadpoolReady = new Promise(function (resolve) {
            uvThreadpoolReadyResolve = function () {
                uvThreadpoolReady.ready = true;
                resolve();
            };
        });
        uvThreadpoolReady.ready = false;
        /** @__sig i */
        function _emnapi_is_main_browser_thread() {
            return (typeof window !== 'undefined' && typeof document !== 'undefined' && true) ? 1 : 0;
        }
        /** @__sig vppi */
        function _emnapi_after_uvthreadpool_ready(callback, q, type) {
            if (uvThreadpoolReady.ready) {
                (wasmTable.get(callback))(q, type);
            }
            else {
                uvThreadpoolReady.then(function () {
                    (wasmTable.get(callback))(q, type);
                });
            }
        }
        /** @__sig vpi */
        function _emnapi_tell_js_uvthreadpool(threads, size) {
            var p = [];
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            var _loop_1 = function (i) {
                var pthreadPtr = HEAP_DATA_VIEW.getInt32(threads + i * 4, true);
                var worker = emnapiGetWorkerByPthreadPtr(pthreadPtr);
                p.push(new Promise(function (resolve) {
                    var handler = function (e) {
                        var data = e.data;
                        var __emnapi__ = data.__emnapi__;
                        if (__emnapi__ && __emnapi__.type === 'async-thread-ready') {
                            resolve();
                            if (worker && typeof worker.unref === 'function') {
                                worker.unref();
                            }
                            {
                                worker.removeEventListener('message', handler);
                            }
                        }
                    };
                    {
                        worker.addEventListener('message', handler);
                    }
                }));
            };
            for (var i = 0; i < size; i++) {
                _loop_1(i);
            }
            Promise.all(p).then(uvThreadpoolReadyResolve);
        }
        /** @__sig v */
        function _emnapi_emit_async_thread_ready() {
            if (!ENVIRONMENT_IS_PTHREAD)
                return;
            var postMessage = napiModule.postMessage;
            postMessage({
                __emnapi__: {
                    type: 'async-thread-ready',
                    payload: {}
                }
            });
        }
        var asyncMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            _emnapi_after_uvthreadpool_ready: _emnapi_after_uvthreadpool_ready,
            _emnapi_async_send_js: _emnapi_async_send_js,
            _emnapi_emit_async_thread_ready: _emnapi_emit_async_thread_ready,
            _emnapi_is_main_browser_thread: _emnapi_is_main_browser_thread,
            _emnapi_tell_js_uvthreadpool: _emnapi_tell_js_uvthreadpool,
            _emnapi_worker_unref: _emnapi_worker_unref
        });
        /* eslint-disable @typescript-eslint/indent */
        /** @__sig ipjp */
        function napi_adjust_external_memory(env, change_in_bytes, adjusted_value) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!adjusted_value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var change_in_bytes_number = Number(change_in_bytes);
            if (change_in_bytes_number < 0) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            var old_size = wasmMemory.buffer.byteLength;
            var new_size = old_size + change_in_bytes_number;
            new_size = new_size + ((65536 - new_size % 65536) % 65536);
            if (wasmMemory.grow((new_size - old_size + 65535) >> 16) === -1) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            if (emnapiCtx.feature.supportBigInt) {
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setBigInt64(adjusted_value, BigInt(wasmMemory.buffer.byteLength), true);
            }
            else {
                $emnapiSetValueI64(adjusted_value, wasmMemory.buffer.byteLength);
            }
            return envObject.clearLastError();
        }
        var memoryMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_adjust_external_memory: napi_adjust_external_memory
        });
        /**
         * @__postset
         * ```
         * emnapiAWST.init();
         * ```
         */
        var emnapiAWST = {
            idGen: {},
            values: [undefined],
            queued: new Set(),
            pending: [],
            init: function () {
                var idGen = {
                    nextId: 1,
                    list: [],
                    generate: function () {
                        var id;
                        if (idGen.list.length) {
                            id = idGen.list.shift();
                        }
                        else {
                            id = idGen.nextId;
                            idGen.nextId++;
                        }
                        return id;
                    },
                    reuse: function (id) {
                        idGen.list.push(id);
                    }
                };
                emnapiAWST.idGen = idGen;
                emnapiAWST.values = [undefined];
                emnapiAWST.queued = new Set();
                emnapiAWST.pending = [];
            },
            create: function (env, resource, resourceName, execute, complete, data) {
                var asyncId = 0;
                var triggerAsyncId = 0;
                if (emnapiNodeBinding) {
                    var asyncContext = emnapiNodeBinding.node.emitAsyncInit(resource, resourceName, -1);
                    asyncId = asyncContext.asyncId;
                    triggerAsyncId = asyncContext.triggerAsyncId;
                }
                var id = emnapiAWST.idGen.generate();
                emnapiAWST.values[id] = {
                    env: env,
                    id: id,
                    resource: resource,
                    asyncId: asyncId,
                    triggerAsyncId: triggerAsyncId,
                    status: 0,
                    execute: execute,
                    complete: complete,
                    data: data
                };
                return id;
            },
            callComplete: function (work, status) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var complete = work.complete;
                var env = work.env;
                var data = work.data;
                var callback = function () {
                    if (!complete)
                        return;
                    var envObject = emnapiCtx.envStore.get(env);
                    var scope = emnapiCtx.openScope(envObject);
                    try {
                        envObject.callbackIntoModule(true, function () {
                            (wasmTable.get(complete))(env, status, data);
                        });
                    }
                    finally {
                        emnapiCtx.closeScope(envObject, scope);
                    }
                };
                if (emnapiNodeBinding) {
                    emnapiNodeBinding.node.makeCallback(work.resource, callback, [], {
                        asyncId: work.asyncId,
                        triggerAsyncId: work.triggerAsyncId
                    });
                }
                else {
                    callback();
                }
            },
            queue: function (id) {
                var work = emnapiAWST.values[id];
                if (!work)
                    return;
                if (work.status === 0) {
                    work.status = 1;
                    if (emnapiAWST.queued.size >= (Math.abs(emnapiAsyncWorkPoolSize) || 4)) {
                        emnapiAWST.pending.push(id);
                        return;
                    }
                    emnapiAWST.queued.add(id);
                    var env_1 = work.env;
                    var data_1 = work.data;
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var execute = work.execute;
                    work.status = 2;
                    emnapiCtx.feature.setImmediate(function () {
                        (wasmTable.get(execute))(env_1, data_1);
                        emnapiAWST.queued.delete(id);
                        work.status = 3;
                        emnapiCtx.feature.setImmediate(function () {
                            emnapiAWST.callComplete(work, 0 /* napi_status.napi_ok */);
                        });
                        if (emnapiAWST.pending.length > 0) {
                            var nextWorkId = emnapiAWST.pending.shift();
                            emnapiAWST.values[nextWorkId].status = 0;
                            emnapiAWST.queue(nextWorkId);
                        }
                    });
                }
            },
            cancel: function (id) {
                var index = emnapiAWST.pending.indexOf(id);
                if (index !== -1) {
                    var work_1 = emnapiAWST.values[id];
                    if (work_1 && (work_1.status === 1)) {
                        work_1.status = 4;
                        emnapiAWST.pending.splice(index, 1);
                        emnapiCtx.feature.setImmediate(function () {
                            emnapiAWST.callComplete(work_1, 11 /* napi_status.napi_cancelled */);
                        });
                        return 0 /* napi_status.napi_ok */;
                    }
                    else {
                        return 9 /* napi_status.napi_generic_failure */;
                    }
                }
                return 9 /* napi_status.napi_generic_failure */;
            },
            remove: function (id) {
                var work = emnapiAWST.values[id];
                if (!work)
                    return;
                if (emnapiNodeBinding) {
                    emnapiNodeBinding.node.emitAsyncDestroy({
                        asyncId: work.asyncId,
                        triggerAsyncId: work.triggerAsyncId
                    });
                }
                emnapiAWST.values[id] = undefined;
                emnapiAWST.idGen.reuse(id);
            }
        };
        /** @__sig vppdp */
        function _emnapi_node_emit_async_init(async_resource, async_resource_name, trigger_async_id, result) {
            if (!emnapiNodeBinding)
                return;
            var resource = emnapiCtx.handleStore.get(async_resource).value;
            var resource_name = emnapiCtx.handleStore.get(async_resource_name).value;
            var asyncContext = emnapiNodeBinding.node.emitAsyncInit(resource, resource_name, trigger_async_id);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var asyncId = asyncContext.asyncId;
            var triggerAsyncId = asyncContext.triggerAsyncId;
            if (result) {
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setFloat64(result, asyncId, true);
                HEAP_DATA_VIEW.setFloat64(result + 8, triggerAsyncId, true);
            }
        }
        /** @__sig vdd */
        function _emnapi_node_emit_async_destroy(async_id, trigger_async_id) {
            if (!emnapiNodeBinding)
                return;
            emnapiNodeBinding.node.emitAsyncDestroy({
                asyncId: async_id,
                triggerAsyncId: trigger_async_id
            });
        }
        /* vpddp export function _emnapi_node_open_callback_scope (async_resource: napi_value, async_id: double, trigger_async_id: double, result: Pointer<int64_t>): void {
          if (!emnapiNodeBinding || !result) return
          const resource = emnapiCtx.handleStore.get(async_resource)!.value
          // eslint-disable-next-line @typescript-eslint/no-unused-vars
          const nativeCallbackScopePointer = emnapiNodeBinding.node.openCallbackScope(resource, {
            asyncId: async_id,
            triggerAsyncId: trigger_async_id
          })
    
          from64('result')
          $_TODO_makeSetValue('result', 0, 'nativeCallbackScopePointer', 'i64')
        }
    
        vp
        export function _emnapi_node_close_callback_scope (scope: Pointer<int64_t>): void {
          if (!emnapiNodeBinding || !scope) return
          from64('scope')
          const nativeCallbackScopePointer = $_TODO_makeGetValue('scope', 0, 'i64')
          emnapiNodeBinding.node.closeCallbackScope(BigInt(nativeCallbackScopePointer))
        } */
        /** @__sig ipppppddp */
        function _emnapi_node_make_callback(env, async_resource, cb, argv, size, async_id, trigger_async_id, result) {
            var i = 0;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!emnapiNodeBinding)
                return;
            var resource = emnapiCtx.handleStore.get(async_resource).value;
            var callback = emnapiCtx.handleStore.get(cb).value;
            size = size >>> 0;
            var arr = Array(size);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            for (; i < size; i++) {
                var argVal = HEAP_DATA_VIEW.getInt32(argv + i * 4, true);
                arr[i] = emnapiCtx.handleStore.get(argVal).value;
            }
            var ret = emnapiNodeBinding.node.makeCallback(resource, callback, arr, {
                asyncId: async_id,
                triggerAsyncId: trigger_async_id
            });
            if (result) {
                var envObject = emnapiCtx.envStore.get(env);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                v = envObject.ensureHandleId(ret);
                HEAP_DATA_VIEW.setInt32(result, v, true);
            }
        }
        /** @__sig ippp */
        function _emnapi_async_init_js(async_resource, async_resource_name, result) {
            if (!emnapiNodeBinding) {
                return 9 /* napi_status.napi_generic_failure */;
            }
            var resource;
            if (async_resource) {
                resource = Object(emnapiCtx.handleStore.get(async_resource).value);
            }
            var name = emnapiCtx.handleStore.get(async_resource_name).value;
            var ret = emnapiNodeBinding.napi.asyncInit(resource, name);
            if (ret.status !== 0)
                return ret.status;
            var numberValue = ret.value;
            if (!((numberValue >= (BigInt(-1) * (BigInt(1) << BigInt(63)))) && (numberValue < (BigInt(1) << BigInt(63))))) {
                numberValue = numberValue & ((BigInt(1) << BigInt(64)) - BigInt(1));
                if (numberValue >= (BigInt(1) << BigInt(63))) {
                    numberValue = numberValue - (BigInt(1) << BigInt(64));
                }
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var low = Number(numberValue & BigInt(0xffffffff));
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var high = Number(numberValue >> BigInt(32));
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, low, true);
            HEAP_DATA_VIEW.setInt32(result + 4, high, true);
            return 0 /* napi_status.napi_ok */;
        }
        /** @__sig ip */
        function _emnapi_async_destroy_js(async_context) {
            if (!emnapiNodeBinding) {
                return 9 /* napi_status.napi_generic_failure */;
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            var low = HEAP_DATA_VIEW.getInt32(async_context, true);
            var high = HEAP_DATA_VIEW.getInt32(async_context + 4, true);
            var pointer = BigInt(low >>> 0) | (BigInt(high) << BigInt(32));
            var ret = emnapiNodeBinding.napi.asyncDestroy(pointer);
            if (ret.status !== 0)
                return ret.status;
            return 0 /* napi_status.napi_ok */;
        }
        // https://github.com/nodejs/node-addon-api/pull/1283
        /** @__sig ipppp */
        function napi_open_callback_scope(env, ignored, async_context_handle, result) {
            throw new Error('napi_open_callback_scope has not been implemented yet');
        }
        /** @__sig ipp */
        function napi_close_callback_scope(env, scope) {
            throw new Error('napi_close_callback_scope has not been implemented yet');
        }
        /** @__sig ippppppp */
        function napi_make_callback(env, async_context, recv, func, argc, argv, result) {
            var i = 0;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!emnapiNodeBinding) {
                    return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                }
                if (!recv)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (argc > 0) {
                    if (!argv)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var v8recv = Object(emnapiCtx.handleStore.get(recv).value);
                var v8func = emnapiCtx.handleStore.get(func).value;
                if (typeof v8func !== 'function') {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                var low = HEAP_DATA_VIEW.getInt32(async_context, true);
                var high = HEAP_DATA_VIEW.getInt32(async_context + 4, true);
                var ctx = BigInt(low >>> 0) | (BigInt(high) << BigInt(32));
                argc = argc >>> 0;
                var arr = Array(argc);
                for (; i < argc; i++) {
                    var argVal = HEAP_DATA_VIEW.getInt32(argv + i * 4, true);
                    arr[i] = emnapiCtx.handleStore.get(argVal).value;
                }
                var ret = emnapiNodeBinding.napi.makeCallback(ctx, v8recv, v8func, arr);
                if (ret.error) {
                    throw ret.error;
                }
                if (ret.status !== 0 /* napi_status.napi_ok */)
                    return envObject.setLastError(ret.status);
                if (result) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    v = envObject.ensureHandleId(ret.value);
                    HEAP_DATA_VIEW.setInt32(result, v, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig vp */
        function _emnapi_env_check_gc_access(env) {
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
        }
        var nodeMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            _emnapi_async_destroy_js: _emnapi_async_destroy_js,
            _emnapi_async_init_js: _emnapi_async_init_js,
            _emnapi_env_check_gc_access: _emnapi_env_check_gc_access,
            _emnapi_node_emit_async_destroy: _emnapi_node_emit_async_destroy,
            _emnapi_node_emit_async_init: _emnapi_node_emit_async_init,
            _emnapi_node_make_callback: _emnapi_node_make_callback,
            napi_close_callback_scope: napi_close_callback_scope,
            napi_make_callback: napi_make_callback,
            napi_open_callback_scope: napi_open_callback_scope
        });
        /**
         * @__deps malloc
         * @__deps free
         * @__postset
         * ```
         * emnapiTSFN.init();
         * ```
         */
        var emnapiTSFN = {
            offset: {
                /* napi_ref */ resource: 0,
                /* double */ async_id: 8,
                /* double */ trigger_async_id: 16,
                /* size_t */ queue_size: 24,
                /* void* */ queue: 1 * 4 + 24,
                /* size_t */ thread_count: 2 * 4 + 24,
                /* bool */ is_closing: 3 * 4 + 24,
                /* atomic_uchar */ dispatch_state: 3 * 4 + 28,
                /* void* */ context: 3 * 4 + 32,
                /* size_t */ max_queue_size: 4 * 4 + 32,
                /* napi_ref */ ref: 5 * 4 + 32,
                /* napi_env */ env: 6 * 4 + 32,
                /* void* */ finalize_data: 7 * 4 + 32,
                /* napi_finalize */ finalize_cb: 8 * 4 + 32,
                /* napi_threadsafe_function_call_js */ call_js_cb: 9 * 4 + 32,
                /* bool */ handles_closing: 10 * 4 + 32,
                /* bool */ async_ref: 10 * 4 + 36,
                /* int32_t */ mutex: 10 * 4 + 40,
                /* int32_t */ cond: 10 * 4 + 44,
                end: 10 * 4 + 48
            },
            init: function () {
                if (typeof PThread !== 'undefined') {
                    PThread.unusedWorkers.forEach(emnapiTSFN.addListener);
                    PThread.runningWorkers.forEach(emnapiTSFN.addListener);
                    var __original_getNewWorker_1 = PThread.getNewWorker;
                    PThread.getNewWorker = function () {
                        var r = __original_getNewWorker_1.apply(this, arguments);
                        emnapiTSFN.addListener(r);
                        return r;
                    };
                }
            },
            addListener: function (worker) {
                if (!worker)
                    return false;
                if (worker._emnapiTSFNListener)
                    return true;
                var handler = function (e) {
                    var data = e.data;
                    var __emnapi__ = data.__emnapi__;
                    if (__emnapi__) {
                        var type = __emnapi__.type;
                        var payload = __emnapi__.payload;
                        if (type === 'tsfn-send') {
                            emnapiTSFN.dispatch(payload.tsfn);
                        }
                    }
                };
                var dispose = function () {
                    {
                        worker.removeEventListener('message', handler, false);
                    }
                    delete worker._emnapiTSFNListener;
                };
                worker._emnapiTSFNListener = { handler: handler, dispose: dispose };
                {
                    worker.addEventListener('message', handler, false);
                }
                return true;
            },
            initQueue: function (func) {
                var size = 2 * 4;
                var queue = _malloc(size);
                if (!queue)
                    return false;
                new Uint8Array(wasmMemory.buffer, queue, size).fill(0);
                emnapiTSFN.storeSizeTypeValue(func + emnapiTSFN.offset.queue, queue, false);
                return true;
            },
            destroyQueue: function (func) {
                var queue = emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.queue, false);
                if (queue) {
                    _free(queue);
                }
            },
            pushQueue: function (func, data) {
                var queue = emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.queue, false);
                var head = emnapiTSFN.loadSizeTypeValue(queue, false);
                var tail = emnapiTSFN.loadSizeTypeValue(queue + 4, false);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var size = 2 * 4;
                var node = _malloc(size);
                if (!node)
                    throw new Error('OOM');
                emnapiTSFN.storeSizeTypeValue(node, data, false);
                emnapiTSFN.storeSizeTypeValue(node + 4, 0, false);
                if (head === 0 && tail === 0) {
                    emnapiTSFN.storeSizeTypeValue(queue, node, false);
                    emnapiTSFN.storeSizeTypeValue(queue + 4, node, false);
                }
                else {
                    emnapiTSFN.storeSizeTypeValue(tail + 4, node, false);
                    emnapiTSFN.storeSizeTypeValue(queue + 4, node, false);
                }
                emnapiTSFN.addQueueSize(func);
            },
            shiftQueue: function (func) {
                var queue = emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.queue, false);
                var head = emnapiTSFN.loadSizeTypeValue(queue, false);
                if (head === 0)
                    return 0;
                var node = head;
                var next = emnapiTSFN.loadSizeTypeValue(head + 4, false);
                emnapiTSFN.storeSizeTypeValue(queue, next, false);
                if (next === 0) {
                    emnapiTSFN.storeSizeTypeValue(queue + 4, 0, false);
                }
                emnapiTSFN.storeSizeTypeValue(node + 4, 0, false);
                var value = emnapiTSFN.loadSizeTypeValue(node, false);
                _free(node);
                emnapiTSFN.subQueueSize(func);
                return value;
            },
            push: function (func, data, mode) {
                var mutex = emnapiTSFN.getMutex(func);
                var cond = emnapiTSFN.getCond(func);
                var waitCondition = function () {
                    var queueSize = emnapiTSFN.getQueueSize(func);
                    var maxSize = emnapiTSFN.getMaxQueueSize(func);
                    var isClosing = emnapiTSFN.getIsClosing(func);
                    return queueSize >= maxSize && maxSize > 0 && !isClosing;
                };
                var isBrowserMain = typeof window !== 'undefined' && typeof document !== 'undefined' && true;
                return mutex.execute(function () {
                    while (waitCondition()) {
                        if (mode === 0 /* napi_threadsafe_function_call_mode.napi_tsfn_nonblocking */) {
                            return 15 /* napi_status.napi_queue_full */;
                        }
                        /**
                         * Browser JS main thread can not use `Atomics.wait`
                         *
                         * Related:
                         * https://github.com/nodejs/node/pull/32689
                         * https://github.com/nodejs/node/pull/33453
                         */
                        if (isBrowserMain) {
                            return 21 /* napi_status.napi_would_deadlock */;
                        }
                        cond.wait();
                    }
                    if (emnapiTSFN.getIsClosing(func)) {
                        if (emnapiTSFN.getThreadCount(func) === 0) {
                            return 1 /* napi_status.napi_invalid_arg */;
                        }
                        else {
                            emnapiTSFN.subThreadCount(func);
                            return 16 /* napi_status.napi_closing */;
                        }
                    }
                    else {
                        emnapiTSFN.pushQueue(func, data);
                        emnapiTSFN.send(func);
                        return 0 /* napi_status.napi_ok */;
                    }
                });
            },
            getMutex: function (func) {
                var index = func + emnapiTSFN.offset.mutex;
                var mutex = {
                    lock: function () {
                        var isBrowserMain = typeof window !== 'undefined' && typeof document !== 'undefined' && true;
                        var i32a = new Int32Array(wasmMemory.buffer, index, 1);
                        if (isBrowserMain) {
                            while (true) {
                                var oldValue = Atomics.compareExchange(i32a, 0, 0, 1);
                                if (oldValue === 0) {
                                    return;
                                }
                            }
                        }
                        else {
                            while (true) {
                                var oldValue = Atomics.compareExchange(i32a, 0, 0, 1);
                                if (oldValue === 0) {
                                    return;
                                }
                                Atomics.wait(i32a, 0, 1);
                            }
                        }
                    },
                    /* lockAsync () {
                      return new Promise<void>(resolve => {
                        const again = (): void => { fn() }
                        const fn = (): void => {
                          const i32a = new Int32Array(wasmMemory.buffer, index, 1)
                          const oldValue = Atomics.compareExchange(i32a, 0, 0, 1)
                          if (oldValue === 0) {
                            resolve()
                            return
                          }
                          (Atomics as any).waitAsync(i32a, 0, 1).value.then(again)
                        }
                        fn()
                      })
                    }, */
                    unlock: function () {
                        var i32a = new Int32Array(wasmMemory.buffer, index, 1);
                        var oldValue = Atomics.compareExchange(i32a, 0, 1, 0);
                        if (oldValue !== 1) {
                            throw new Error('Tried to unlock while not holding the mutex');
                        }
                        Atomics.notify(i32a, 0, 1);
                    },
                    execute: function (fn) {
                        mutex.lock();
                        try {
                            return fn();
                        }
                        finally {
                            mutex.unlock();
                        }
                    } /* ,
                    executeAsync<T> (fn: () => Promise<T>): Promise<T> {
                      return mutex.lockAsync().then(() => {
                        const r = fn()
                        mutex.unlock()
                        return r
                      }, (err) => {
                        mutex.unlock()
                        throw err
                      })
                    } */
                };
                return mutex;
            },
            getCond: function (func) {
                var index = func + emnapiTSFN.offset.cond;
                var mutex = emnapiTSFN.getMutex(func);
                var cond = {
                    wait: function () {
                        var i32a = new Int32Array(wasmMemory.buffer, index, 1);
                        var value = Atomics.load(i32a, 0);
                        mutex.unlock();
                        Atomics.wait(i32a, 0, value);
                        mutex.lock();
                    },
                    /* waitAsync () {
                      const i32a = new Int32Array(wasmMemory.buffer, index, 1)
                      const value = Atomics.load(i32a, 0)
                      mutex.unlock()
                      const lock = (): Promise<void> => mutex.lockAsync()
                      try {
                        return (Atomics as any).waitAsync(i32a, 0, value).value.then(lock, lock)
                      } catch (err) {
                        return lock()
                      }
                    }, */
                    signal: function () {
                        var i32a = new Int32Array(wasmMemory.buffer, index, 1);
                        Atomics.add(i32a, 0, 1);
                        Atomics.notify(i32a, 0, 1);
                    }
                };
                return cond;
            },
            getQueueSize: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.queue_size, true);
            },
            addQueueSize: function (func) {
                var offset = emnapiTSFN.offset.queue_size;
                var arr, index;
                arr = new Uint32Array(wasmMemory.buffer);
                index = (func + offset) >> 2;
                Atomics.add(arr, index, 1);
            },
            subQueueSize: function (func) {
                var offset = emnapiTSFN.offset.queue_size;
                var arr, index;
                arr = new Uint32Array(wasmMemory.buffer);
                index = (func + offset) >> 2;
                Atomics.sub(arr, index, 1);
            },
            getThreadCount: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.thread_count, true);
            },
            addThreadCount: function (func) {
                var offset = emnapiTSFN.offset.thread_count;
                var arr, index;
                arr = new Uint32Array(wasmMemory.buffer);
                index = (func + offset) >> 2;
                Atomics.add(arr, index, 1);
            },
            subThreadCount: function (func) {
                var offset = emnapiTSFN.offset.thread_count;
                var arr, index;
                arr = new Uint32Array(wasmMemory.buffer);
                index = (func + offset) >> 2;
                Atomics.sub(arr, index, 1);
            },
            getIsClosing: function (func) {
                return Atomics.load(new Int32Array(wasmMemory.buffer), (func + emnapiTSFN.offset.is_closing) >> 2);
            },
            setIsClosing: function (func, value) {
                Atomics.store(new Int32Array(wasmMemory.buffer), (func + emnapiTSFN.offset.is_closing) >> 2, value);
            },
            getHandlesClosing: function (func) {
                return Atomics.load(new Int32Array(wasmMemory.buffer), (func + emnapiTSFN.offset.handles_closing) >> 2);
            },
            setHandlesClosing: function (func, value) {
                Atomics.store(new Int32Array(wasmMemory.buffer), (func + emnapiTSFN.offset.handles_closing) >> 2, value);
            },
            getDispatchState: function (func) {
                return Atomics.load(new Uint32Array(wasmMemory.buffer), (func + emnapiTSFN.offset.dispatch_state) >> 2);
            },
            getContext: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.context, false);
            },
            getMaxQueueSize: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.max_queue_size, true);
            },
            getEnv: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.env, false);
            },
            getCallJSCb: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.call_js_cb, false);
            },
            getRef: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.ref, false);
            },
            getResource: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.resource, false);
            },
            getFinalizeCb: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.finalize_cb, false);
            },
            getFinalizeData: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.finalize_data, false);
            },
            loadSizeTypeValue: function (offset, unsigned) {
                var ret;
                var arr;
                if (unsigned) {
                    arr = new Uint32Array(wasmMemory.buffer);
                    ret = Atomics.load(arr, offset >> 2);
                    return ret;
                }
                else {
                    arr = new Int32Array(wasmMemory.buffer);
                    ret = Atomics.load(arr, offset >> 2);
                    return ret;
                }
            },
            storeSizeTypeValue: function (offset, value, unsigned) {
                var arr;
                if (unsigned) {
                    arr = new Uint32Array(wasmMemory.buffer);
                    Atomics.store(arr, offset >> 2, value);
                    return undefined;
                }
                else {
                    arr = new Int32Array(wasmMemory.buffer);
                    Atomics.store(arr, offset >> 2, value >>> 0);
                    return undefined;
                }
            },
            destroy: function (func) {
                emnapiTSFN.destroyQueue(func);
                var env = emnapiTSFN.getEnv(func);
                var envObject = emnapiCtx.envStore.get(env);
                var ref = emnapiTSFN.getRef(func);
                if (ref) {
                    emnapiCtx.refStore.get(ref).dispose();
                }
                emnapiCtx.removeCleanupHook(envObject, emnapiTSFN.cleanup, func);
                envObject.unref();
                var asyncRefOffset = (func + emnapiTSFN.offset.async_ref) >> 2;
                var arr = new Int32Array(wasmMemory.buffer);
                if (Atomics.load(arr, asyncRefOffset)) {
                    Atomics.store(arr, asyncRefOffset, 0);
                    emnapiCtx.decreaseWaitingRequestCounter();
                }
                var resource = emnapiTSFN.getResource(func);
                emnapiCtx.refStore.get(resource).dispose();
                if (emnapiNodeBinding) {
                    var view = new DataView(wasmMemory.buffer);
                    var asyncId = view.getFloat64(func + emnapiTSFN.offset.async_id, true);
                    var triggerAsyncId = view.getFloat64(func + emnapiTSFN.offset.trigger_async_id, true);
                    _emnapi_node_emit_async_destroy(asyncId, triggerAsyncId);
                }
                _free(func);
            },
            emptyQueueAndDelete: function (func) {
                var callJsCb = emnapiTSFN.getCallJSCb(func);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var context = emnapiTSFN.getContext(func);
                var data;
                while (emnapiTSFN.getQueueSize(func) > 0) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    data = emnapiTSFN.shiftQueue(func);
                    if (callJsCb) {
                        (wasmTable.get(callJsCb))(0, 0, context, data);
                    }
                }
                emnapiTSFN.destroy(func);
            },
            finalize: function (func) {
                var env = emnapiTSFN.getEnv(func);
                var envObject = emnapiCtx.envStore.get(env);
                emnapiCtx.openScope(envObject);
                var finalize = emnapiTSFN.getFinalizeCb(func);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var data = emnapiTSFN.getFinalizeData(func);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var context = emnapiTSFN.getContext(func);
                var f = function () {
                    envObject.callFinalizerInternal(0, finalize, data, context);
                };
                try {
                    if (finalize) {
                        if (emnapiNodeBinding) {
                            var resource = emnapiTSFN.getResource(func);
                            var resource_value = emnapiCtx.refStore.get(resource).get();
                            var resourceObject = emnapiCtx.handleStore.get(resource_value).value;
                            var view = new DataView(wasmMemory.buffer);
                            var asyncId = view.getFloat64(func + emnapiTSFN.offset.async_id, true);
                            var triggerAsyncId = view.getFloat64(func + emnapiTSFN.offset.trigger_async_id, true);
                            emnapiNodeBinding.node.makeCallback(resourceObject, f, [], {
                                asyncId: asyncId,
                                triggerAsyncId: triggerAsyncId
                            });
                        }
                        else {
                            f();
                        }
                    }
                    emnapiTSFN.emptyQueueAndDelete(func);
                }
                finally {
                    emnapiCtx.closeScope(envObject);
                }
            },
            cleanup: function (func) {
                emnapiTSFN.closeHandlesAndMaybeDelete(func, 1);
            },
            closeHandlesAndMaybeDelete: function (func, set_closing) {
                var env = emnapiTSFN.getEnv(func);
                var envObject = emnapiCtx.envStore.get(env);
                emnapiCtx.openScope(envObject);
                try {
                    if (set_closing) {
                        emnapiTSFN.getMutex(func).execute(function () {
                            emnapiTSFN.setIsClosing(func, 1);
                            if (emnapiTSFN.getMaxQueueSize(func) > 0) {
                                emnapiTSFN.getCond(func).signal();
                            }
                        });
                    }
                    if (emnapiTSFN.getHandlesClosing(func)) {
                        return;
                    }
                    emnapiTSFN.setHandlesClosing(func, 1);
                    emnapiCtx.feature.setImmediate(function () {
                        emnapiTSFN.finalize(func);
                    });
                }
                finally {
                    emnapiCtx.closeScope(envObject);
                }
            },
            dispatchOne: function (func) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var data = 0;
                var popped_value = false;
                var has_more = false;
                var mutex = emnapiTSFN.getMutex(func);
                var cond = emnapiTSFN.getCond(func);
                mutex.execute(function () {
                    if (emnapiTSFN.getIsClosing(func)) {
                        emnapiTSFN.closeHandlesAndMaybeDelete(func, 0);
                    }
                    else {
                        var size = emnapiTSFN.getQueueSize(func);
                        if (size > 0) {
                            data = emnapiTSFN.shiftQueue(func);
                            popped_value = true;
                            var maxQueueSize = emnapiTSFN.getMaxQueueSize(func);
                            if (size === maxQueueSize && maxQueueSize > 0) {
                                cond.signal();
                            }
                            size--;
                        }
                        if (size === 0) {
                            if (emnapiTSFN.getThreadCount(func) === 0) {
                                emnapiTSFN.setIsClosing(func, 1);
                                if (emnapiTSFN.getMaxQueueSize(func) > 0) {
                                    cond.signal();
                                }
                                emnapiTSFN.closeHandlesAndMaybeDelete(func, 0);
                            }
                        }
                        else {
                            has_more = true;
                        }
                    }
                });
                if (popped_value) {
                    var env = emnapiTSFN.getEnv(func);
                    var envObject_1 = emnapiCtx.envStore.get(env);
                    emnapiCtx.openScope(envObject_1);
                    var f = function () {
                        envObject_1.callbackIntoModule(false, function () {
                            var callJsCb = emnapiTSFN.getCallJSCb(func);
                            var ref = emnapiTSFN.getRef(func);
                            var js_callback = ref ? emnapiCtx.refStore.get(ref).get() : 0;
                            if (callJsCb) {
                                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                                var context = emnapiTSFN.getContext(func);
                                (wasmTable.get(callJsCb))(env, js_callback, context, data);
                            }
                            else {
                                var jsCallback = js_callback ? emnapiCtx.handleStore.get(js_callback).value : null;
                                if (typeof jsCallback === 'function') {
                                    jsCallback();
                                }
                            }
                        });
                    };
                    try {
                        if (emnapiNodeBinding) {
                            var resource = emnapiTSFN.getResource(func);
                            var resource_value = emnapiCtx.refStore.get(resource).get();
                            var resourceObject = emnapiCtx.handleStore.get(resource_value).value;
                            var view = new DataView(wasmMemory.buffer);
                            emnapiNodeBinding.node.makeCallback(resourceObject, f, [], {
                                asyncId: view.getFloat64(func + emnapiTSFN.offset.async_id, true),
                                triggerAsyncId: view.getFloat64(func + emnapiTSFN.offset.trigger_async_id, true)
                            });
                        }
                        else {
                            f();
                        }
                    }
                    finally {
                        emnapiCtx.closeScope(envObject_1);
                    }
                }
                return has_more;
            },
            dispatch: function (func) {
                var has_more = true;
                var iterations_left = 1000;
                var ui32a = new Uint32Array(wasmMemory.buffer);
                var index = (func + emnapiTSFN.offset.dispatch_state) >> 2;
                while (has_more && --iterations_left !== 0) {
                    Atomics.store(ui32a, index, 1);
                    has_more = emnapiTSFN.dispatchOne(func);
                    if (Atomics.exchange(ui32a, index, 0) !== 1) {
                        has_more = true;
                    }
                }
                if (has_more) {
                    emnapiTSFN.send(func);
                }
            },
            send: function (func) {
                var current_state = Atomics.or(new Uint32Array(wasmMemory.buffer), (func + emnapiTSFN.offset.dispatch_state) >> 2, 1 << 1);
                if ((current_state & 1) === 1) {
                    return;
                }
                if ((typeof ENVIRONMENT_IS_PTHREAD !== 'undefined') && ENVIRONMENT_IS_PTHREAD) {
                    postMessage({
                        __emnapi__: {
                            type: 'tsfn-send',
                            payload: {
                                tsfn: func
                            }
                        }
                    });
                }
                else {
                    emnapiCtx.feature.setImmediate(function () {
                        emnapiTSFN.dispatch(func);
                    });
                }
            }
        };
        /** @__sig ippppppppppp */
        function napi_create_threadsafe_function(env, func, async_resource, async_resource_name, max_queue_size, initial_thread_count, thread_finalize_data, thread_finalize_cb, context, call_js_cb, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!async_resource_name)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            max_queue_size = max_queue_size >>> 0;
            initial_thread_count = initial_thread_count >>> 0;
            if (initial_thread_count === 0) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var ref = 0;
            if (!func) {
                if (!call_js_cb)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            else {
                var funcValue = emnapiCtx.handleStore.get(func).value;
                if (typeof funcValue !== 'function') {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                ref = emnapiCtx.createReference(envObject, func, 1, 1 /* ReferenceOwnership.kUserland */).id;
            }
            var asyncResourceObject;
            if (async_resource) {
                asyncResourceObject = emnapiCtx.handleStore.get(async_resource).value;
                if (asyncResourceObject == null) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                asyncResourceObject = Object(asyncResourceObject);
            }
            else {
                asyncResourceObject = {};
            }
            var resource = envObject.ensureHandleId(asyncResourceObject);
            var asyncResourceName = emnapiCtx.handleStore.get(async_resource_name).value;
            if (typeof asyncResourceName === 'symbol') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            asyncResourceName = String(asyncResourceName);
            var resource_name = envObject.ensureHandleId(asyncResourceName);
            // tsfn create
            var sizeofTSFN = emnapiTSFN.offset.end;
            var tsfn = _malloc(sizeofTSFN);
            if (!tsfn)
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            new Uint8Array(wasmMemory.buffer).subarray(tsfn, tsfn + sizeofTSFN).fill(0);
            var resourceRef = emnapiCtx.createReference(envObject, resource, 1, 1 /* ReferenceOwnership.kUserland */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var resource_ = resourceRef.id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(tsfn, resource_, true);
            if (!emnapiTSFN.initQueue(tsfn)) {
                _free(tsfn);
                resourceRef.dispose();
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            _emnapi_node_emit_async_init(resource, resource_name, -1, tsfn + emnapiTSFN.offset.async_id);
            HEAP_DATA_VIEW.setUint32(tsfn + emnapiTSFN.offset.thread_count, initial_thread_count, true);
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.context, context, true);
            HEAP_DATA_VIEW.setUint32(tsfn + emnapiTSFN.offset.max_queue_size, max_queue_size, true);
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.ref, ref, true);
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.env, env, true);
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.finalize_data, thread_finalize_data, true);
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.finalize_cb, thread_finalize_cb, true);
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.call_js_cb, call_js_cb, true);
            emnapiCtx.addCleanupHook(envObject, emnapiTSFN.cleanup, tsfn);
            envObject.ref();
            emnapiCtx.increaseWaitingRequestCounter();
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.async_ref, 1, true);
            HEAP_DATA_VIEW.setInt32(result, tsfn, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_get_threadsafe_function_context(func, result) {
            if (!func || !result) {
                abort();
                return 1 /* napi_status.napi_invalid_arg */;
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var context = emnapiTSFN.getContext(func);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, context, true);
            return 0 /* napi_status.napi_ok */;
        }
        /** @__sig ippi */
        function napi_call_threadsafe_function(func, data, mode) {
            if (!func) {
                abort();
                return 1 /* napi_status.napi_invalid_arg */;
            }
            return emnapiTSFN.push(func, data, mode);
        }
        /** @__sig ip */
        function napi_acquire_threadsafe_function(func) {
            if (!func) {
                abort();
                return 1 /* napi_status.napi_invalid_arg */;
            }
            var mutex = emnapiTSFN.getMutex(func);
            return mutex.execute(function () {
                if (emnapiTSFN.getIsClosing(func)) {
                    return 16 /* napi_status.napi_closing */;
                }
                emnapiTSFN.addThreadCount(func);
                return 0 /* napi_status.napi_ok */;
            });
        }
        /** @__sig ipi */
        function napi_release_threadsafe_function(func, mode) {
            if (!func) {
                abort();
                return 1 /* napi_status.napi_invalid_arg */;
            }
            var mutex = emnapiTSFN.getMutex(func);
            var cond = emnapiTSFN.getCond(func);
            return mutex.execute(function () {
                if (emnapiTSFN.getThreadCount(func) === 0) {
                    return 1 /* napi_status.napi_invalid_arg */;
                }
                emnapiTSFN.subThreadCount(func);
                if (emnapiTSFN.getThreadCount(func) === 0 || mode === 1 /* napi_threadsafe_function_release_mode.napi_tsfn_abort */) {
                    var isClosing = emnapiTSFN.getIsClosing(func);
                    if (!isClosing) {
                        var isClosingValue = (mode === 1 /* napi_threadsafe_function_release_mode.napi_tsfn_abort */) ? 1 : 0;
                        emnapiTSFN.setIsClosing(func, isClosingValue);
                        if (isClosingValue && emnapiTSFN.getMaxQueueSize(func) > 0) {
                            cond.signal();
                        }
                        emnapiTSFN.send(func);
                    }
                }
                return 0 /* napi_status.napi_ok */;
            });
        }
        /** @__sig ipp */
        function napi_unref_threadsafe_function(env, func) {
            if (!func) {
                abort();
                return 1 /* napi_status.napi_invalid_arg */;
            }
            var asyncRefOffset = (func + emnapiTSFN.offset.async_ref) >> 2;
            var arr = new Int32Array(wasmMemory.buffer);
            if (Atomics.load(arr, asyncRefOffset)) {
                Atomics.store(arr, asyncRefOffset, 0);
                emnapiCtx.decreaseWaitingRequestCounter();
            }
            return 0 /* napi_status.napi_ok */;
        }
        /** @__sig ipp */
        function napi_ref_threadsafe_function(env, func) {
            if (!func) {
                abort();
                return 1 /* napi_status.napi_invalid_arg */;
            }
            var asyncRefOffset = (func + emnapiTSFN.offset.async_ref) >> 2;
            var arr = new Int32Array(wasmMemory.buffer);
            if (!Atomics.load(arr, asyncRefOffset)) {
                Atomics.store(arr, asyncRefOffset, 1);
                emnapiCtx.increaseWaitingRequestCounter();
            }
            return 0 /* napi_status.napi_ok */;
        }
        var emnapiAWMT = {
            unusedWorkers: [],
            runningWorkers: [],
            workQueue: [],
            workerReady: null,
            offset: {
                /* napi_ref */ resource: 0,
                /* double */ async_id: 8,
                /* double */ trigger_async_id: 16,
                /* napi_env */ env: 24,
                /* void* */ data: 1 * 4 + 24,
                /* napi_async_execute_callback */ execute: 2 * 4 + 24,
                /* napi_async_complete_callback */ complete: 3 * 4 + 24,
                end: 4 * 4 + 24
            },
            init: function () {
                emnapiAWMT.unusedWorkers = [];
                emnapiAWMT.runningWorkers = [];
                emnapiAWMT.workQueue = [];
                emnapiAWMT.workerReady = null;
            },
            addListener: function (worker) {
                if (!worker)
                    return false;
                if (worker._emnapiAWMTListener)
                    return true;
                var handler = function (e) {
                    var data = e.data;
                    var __emnapi__ = data.__emnapi__;
                    if (__emnapi__) {
                        var type = __emnapi__.type;
                        var payload = __emnapi__.payload;
                        if (type === 'async-work-complete') {
                            emnapiCtx.decreaseWaitingRequestCounter();
                            emnapiAWMT.runningWorkers.splice(emnapiAWMT.runningWorkers.indexOf(worker), 1);
                            emnapiAWMT.unusedWorkers.push(worker);
                            emnapiAWMT.checkIdleWorker();
                            emnapiAWMT.callComplete(payload.work, 0 /* napi_status.napi_ok */);
                        }
                        else if (type === 'async-work-queue') {
                            emnapiAWMT.scheduleWork(payload.work);
                        }
                        else if (type === 'async-work-cancel') {
                            emnapiAWMT.cancelWork(payload.work);
                        }
                    }
                };
                var dispose = function () {
                    {
                        worker.removeEventListener('message', handler, false);
                    }
                    delete worker._emnapiAWMTListener;
                };
                worker._emnapiAWMTListener = { handler: handler, dispose: dispose };
                {
                    worker.addEventListener('message', handler, false);
                }
                return true;
            },
            initWorkers: function (n) {
                if (ENVIRONMENT_IS_PTHREAD) {
                    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
                    return emnapiAWMT.workerReady || (emnapiAWMT.workerReady = Promise.resolve());
                }
                if (emnapiAWMT.workerReady)
                    return emnapiAWMT.workerReady;
                if (typeof onCreateWorker !== 'function') {
                    throw new TypeError('`options.onCreateWorker` is not a function');
                }
                var promises = [];
                var args = [];
                if (!('emnapi_async_worker_create' in wasmInstance.exports)) {
                    throw new TypeError('`emnapi_async_worker_create` is not exported, please try to add `--export=emnapi_async_worker_create` to linker flags');
                }
                for (var i = 0; i < n; ++i) {
                    args.push(wasmInstance.exports.emnapi_async_worker_create());
                }
                try {
                    var _loop_1 = function (i) {
                        var worker = onCreateWorker({ type: 'async-work', name: 'emnapi-async-worker' });
                        var p = PThread.loadWasmModuleToWorker(worker);
                        emnapiAWMT.addListener(worker);
                        promises.push(p.then(function () {
                            if (typeof worker.unref === 'function') {
                                worker.unref();
                            }
                        }));
                        emnapiAWMT.unusedWorkers.push(worker);
                        var arg = args[i];
                        worker.threadBlockBase = arg;
                        worker.postMessage({
                            __emnapi__: {
                                type: 'async-worker-init',
                                payload: { arg: arg }
                            }
                        });
                    };
                    for (var i = 0; i < n; ++i) {
                        _loop_1(i);
                    }
                }
                catch (err) {
                    for (var i = 0; i < n; ++i) {
                        // eslint-disable-next-line @typescript-eslint/no-unused-vars
                        var arg = args[i];
                        _free(arg);
                    }
                    throw err;
                }
                emnapiAWMT.workerReady = Promise.all(promises);
                return emnapiAWMT.workerReady;
            },
            checkIdleWorker: function () {
                if (emnapiAWMT.unusedWorkers.length > 0 && emnapiAWMT.workQueue.length > 0) {
                    var worker = emnapiAWMT.unusedWorkers.shift();
                    var work = emnapiAWMT.workQueue.shift();
                    emnapiAWMT.runningWorkers.push(worker);
                    worker.postMessage({
                        __emnapi__: {
                            type: 'async-work-execute',
                            payload: { work: work }
                        }
                    });
                }
            },
            getResource: function (work) {
                return emnapiTSFN.loadSizeTypeValue(work + emnapiAWMT.offset.resource, false);
            },
            getExecute: function (work) {
                return emnapiTSFN.loadSizeTypeValue(work + emnapiAWMT.offset.execute, false);
            },
            getComplete: function (work) {
                return emnapiTSFN.loadSizeTypeValue(work + emnapiAWMT.offset.complete, false);
            },
            getEnv: function (work) {
                return emnapiTSFN.loadSizeTypeValue(work + emnapiAWMT.offset.env, false);
            },
            getData: function (work) {
                return emnapiTSFN.loadSizeTypeValue(work + emnapiAWMT.offset.data, false);
            },
            scheduleWork: function (work) {
                var _a;
                if (ENVIRONMENT_IS_PTHREAD) {
                    var postMessage_1 = napiModule.postMessage;
                    postMessage_1({
                        __emnapi__: {
                            type: 'async-work-queue',
                            payload: { work: work }
                        }
                    });
                    return;
                }
                emnapiCtx.increaseWaitingRequestCounter();
                emnapiAWMT.workQueue.push(work);
                if ((_a = emnapiAWMT.workerReady) === null || _a === void 0 ? void 0 : _a.ready) {
                    emnapiAWMT.checkIdleWorker();
                }
                else {
                    var fail = function (err) {
                        emnapiCtx.decreaseWaitingRequestCounter();
                        throw err;
                    };
                    try {
                        emnapiAWMT.initWorkers(_emnapi_async_work_pool_size()).then(function () {
                            emnapiAWMT.workerReady.ready = true;
                            emnapiAWMT.checkIdleWorker();
                        }, fail);
                    }
                    catch (err) {
                        fail(err);
                    }
                }
            },
            cancelWork: function (work) {
                if (ENVIRONMENT_IS_PTHREAD) {
                    var postMessage_2 = napiModule.postMessage;
                    postMessage_2({
                        __emnapi__: {
                            type: 'async-work-cancel',
                            payload: { work: work }
                        }
                    });
                    return 0 /* napi_status.napi_ok */;
                }
                var index = emnapiAWMT.workQueue.indexOf(work);
                if (index !== -1) {
                    emnapiAWMT.workQueue.splice(index, 1);
                    emnapiCtx.feature.setImmediate(function () {
                        emnapiCtx.decreaseWaitingRequestCounter();
                        emnapiAWMT.checkIdleWorker();
                        emnapiAWMT.callComplete(work, 11 /* napi_status.napi_cancelled */);
                    });
                    return 0 /* napi_status.napi_ok */;
                }
                return 9 /* napi_status.napi_generic_failure */;
            },
            callComplete: function (work, status) {
                var complete = emnapiAWMT.getComplete(work);
                var env = emnapiAWMT.getEnv(work);
                var data = emnapiAWMT.getData(work);
                var envObject = emnapiCtx.envStore.get(env);
                var scope = emnapiCtx.openScope(envObject);
                var callback = function () {
                    if (!complete)
                        return;
                    envObject.callbackIntoModule(true, function () {
                        (wasmTable.get(complete))(env, status, data);
                    });
                };
                try {
                    if (emnapiNodeBinding) {
                        var resource = emnapiAWMT.getResource(work);
                        var resource_value = emnapiCtx.refStore.get(resource).get();
                        var resourceObject = emnapiCtx.handleStore.get(resource_value).value;
                        var view = new DataView(wasmMemory.buffer);
                        var asyncId = view.getFloat64(work + emnapiAWMT.offset.async_id, true);
                        var triggerAsyncId = view.getFloat64(work + emnapiAWMT.offset.trigger_async_id, true);
                        emnapiNodeBinding.node.makeCallback(resourceObject, callback, [], {
                            asyncId: asyncId,
                            triggerAsyncId: triggerAsyncId
                        });
                    }
                    else {
                        callback();
                    }
                }
                finally {
                    emnapiCtx.closeScope(envObject, scope);
                }
            }
        };
        /** @__sig ippppppp */
        var napi_create_async_work = singleThreadAsyncWork
            ? function (env, resource, resource_name, execute, complete, data, result) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                // @ts-expect-error
                var envObject = emnapiCtx.envStore.get(env);
                envObject.checkGCAccess();
                if (!execute)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var resourceObject;
                if (resource) {
                    resourceObject = Object(emnapiCtx.handleStore.get(resource).value);
                }
                else {
                    resourceObject = {};
                }
                if (!resource_name)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var resourceName = String(emnapiCtx.handleStore.get(resource_name).value);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var id = emnapiAWST.create(env, resourceObject, resourceName, execute, complete, data);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, id, true);
                return envObject.clearLastError();
            }
            : function (env, resource, resource_name, execute, complete, data, result) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                // @ts-expect-error
                var envObject = emnapiCtx.envStore.get(env);
                envObject.checkGCAccess();
                if (!execute)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var resourceObject;
                if (resource) {
                    resourceObject = Object(emnapiCtx.handleStore.get(resource).value);
                }
                else {
                    resourceObject = {};
                }
                if (!resource_name)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var sizeofAW = emnapiAWMT.offset.end;
                var aw = _malloc(sizeofAW);
                if (!aw)
                    return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                new Uint8Array(wasmMemory.buffer).subarray(aw, aw + sizeofAW).fill(0);
                var s = envObject.ensureHandleId(resourceObject);
                var resourceRef = emnapiCtx.createReference(envObject, s, 1, 1 /* ReferenceOwnership.kUserland */);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var resource_ = resourceRef.id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(aw, resource_, true);
                _emnapi_node_emit_async_init(s, resource_name, -1, aw + emnapiAWMT.offset.async_id);
                HEAP_DATA_VIEW.setInt32(aw + emnapiAWMT.offset.env, env, true);
                HEAP_DATA_VIEW.setInt32(aw + emnapiAWMT.offset.execute, execute, true);
                HEAP_DATA_VIEW.setInt32(aw + emnapiAWMT.offset.complete, complete, true);
                HEAP_DATA_VIEW.setInt32(aw + emnapiAWMT.offset.data, data, true);
                HEAP_DATA_VIEW.setInt32(result, aw, true);
                return envObject.clearLastError();
            };
        /** @__sig ipp */
        var napi_delete_async_work = singleThreadAsyncWork
            ? function (env, work) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                // @ts-expect-error
                var envObject = emnapiCtx.envStore.get(env);
                envObject.checkGCAccess();
                if (!work)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                emnapiAWST.remove(work);
                return envObject.clearLastError();
            }
            : function (env, work) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                // @ts-expect-error
                var envObject = emnapiCtx.envStore.get(env);
                envObject.checkGCAccess();
                if (!work)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var resource = emnapiAWMT.getResource(work);
                emnapiCtx.refStore.get(resource).dispose();
                if (emnapiNodeBinding) {
                    var view = new DataView(wasmMemory.buffer);
                    var asyncId = view.getFloat64(work + emnapiAWMT.offset.async_id, true);
                    var triggerAsyncId = view.getFloat64(work + emnapiAWMT.offset.trigger_async_id, true);
                    _emnapi_node_emit_async_destroy(asyncId, triggerAsyncId);
                }
                _free(work);
                return envObject.clearLastError();
            };
        /** @__sig ipp */
        var napi_queue_async_work = singleThreadAsyncWork
            ? function (env, work) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                var envObject = emnapiCtx.envStore.get(env);
                if (!work)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                emnapiAWST.queue(work);
                return envObject.clearLastError();
            }
            : function (env, work) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                var envObject = emnapiCtx.envStore.get(env);
                if (!work)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                emnapiAWMT.scheduleWork(work);
                return envObject.clearLastError();
            };
        /** @__sig ipp */
        var napi_cancel_async_work = singleThreadAsyncWork
            ? function (env, work) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                var envObject = emnapiCtx.envStore.get(env);
                if (!work)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var status = emnapiAWST.cancel(work);
                if (status === 0 /* napi_status.napi_ok */)
                    return envObject.clearLastError();
                return envObject.setLastError(status);
            }
            : function (env, work) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                var envObject = emnapiCtx.envStore.get(env);
                if (!work)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var status = emnapiAWMT.cancelWork(work);
                if (status === 0 /* napi_status.napi_ok */)
                    return envObject.clearLastError();
                return envObject.setLastError(status);
            };
        function initWorker(startArg) {
            if (napiModule.childThread) {
                if (typeof wasmInstance.exports.emnapi_async_worker_init !== 'function') {
                    throw new TypeError('`emnapi_async_worker_init` is not exported, please try to add `--export=emnapi_async_worker_init` to linker flags');
                }
                wasmInstance.exports.emnapi_async_worker_init(startArg);
            }
            else {
                throw new Error('startThread is only available in child threads');
            }
        }
        function executeAsyncWork(work) {
            if (!ENVIRONMENT_IS_PTHREAD)
                return;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var execute = emnapiAWMT.getExecute(work);
            var env = emnapiAWMT.getEnv(work);
            var data = emnapiAWMT.getData(work);
            (wasmTable.get(execute))(env, data);
            var postMessage = napiModule.postMessage;
            postMessage({
                __emnapi__: {
                    type: 'async-work-complete',
                    payload: { work: work }
                }
            });
        }
        napiModule.initWorker = initWorker;
        napiModule.executeAsyncWork = executeAsyncWork;
        var asyncWorkMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_cancel_async_work: napi_cancel_async_work,
            napi_create_async_work: napi_create_async_work,
            napi_delete_async_work: napi_delete_async_work,
            napi_queue_async_work: napi_queue_async_work
        });
        /**
         * @__deps malloc
         * @__deps free
         * @__postset
         * ```
         * emnapiExternalMemory.init();
         * ```
         */
        var emnapiExternalMemory = {
            registry: typeof FinalizationRegistry === 'function' ? new FinalizationRegistry(function (_pointer) { _free(_pointer); }) : undefined,
            table: new WeakMap(),
            wasmMemoryViewTable: new WeakMap(),
            init: function () {
                emnapiExternalMemory.registry = typeof FinalizationRegistry === 'function' ? new FinalizationRegistry(function (_pointer) { _free(_pointer); }) : undefined;
                emnapiExternalMemory.table = new WeakMap();
                emnapiExternalMemory.wasmMemoryViewTable = new WeakMap();
            },
            isDetachedArrayBuffer: function (arrayBuffer) {
                if (arrayBuffer.byteLength === 0) {
                    try {
                        // eslint-disable-next-line no-new
                        new Uint8Array(arrayBuffer);
                    }
                    catch (_) {
                        return true;
                    }
                }
                return false;
            },
            getArrayBufferPointer: function (arrayBuffer, shouldCopy) {
                var _a;
                var info = {
                    address: 0,
                    ownership: 0 /* ReferenceOwnership.kRuntime */,
                    runtimeAllocated: 0
                };
                if (arrayBuffer === wasmMemory.buffer) {
                    return info;
                }
                var isDetached = emnapiExternalMemory.isDetachedArrayBuffer(arrayBuffer);
                if (emnapiExternalMemory.table.has(arrayBuffer)) {
                    var cachedInfo = emnapiExternalMemory.table.get(arrayBuffer);
                    if (isDetached) {
                        cachedInfo.address = 0;
                        return cachedInfo;
                    }
                    if (shouldCopy && cachedInfo.ownership === 0 /* ReferenceOwnership.kRuntime */ && cachedInfo.runtimeAllocated === 1) {
                        new Uint8Array(wasmMemory.buffer).set(new Uint8Array(arrayBuffer), cachedInfo.address);
                    }
                    return cachedInfo;
                }
                if (isDetached || (arrayBuffer.byteLength === 0)) {
                    return info;
                }
                if (!shouldCopy) {
                    return info;
                }
                var pointer = _malloc(arrayBuffer.byteLength);
                if (!pointer)
                    throw new Error('Out of memory');
                new Uint8Array(wasmMemory.buffer).set(new Uint8Array(arrayBuffer), pointer);
                info.address = pointer;
                info.ownership = emnapiExternalMemory.registry ? 0 /* ReferenceOwnership.kRuntime */ : 1 /* ReferenceOwnership.kUserland */;
                info.runtimeAllocated = 1;
                emnapiExternalMemory.table.set(arrayBuffer, info);
                (_a = emnapiExternalMemory.registry) === null || _a === void 0 ? void 0 : _a.register(arrayBuffer, pointer);
                return info;
            },
            getOrUpdateMemoryView: function (view) {
                if (view.buffer === wasmMemory.buffer) {
                    if (!emnapiExternalMemory.wasmMemoryViewTable.has(view)) {
                        emnapiExternalMemory.wasmMemoryViewTable.set(view, {
                            Ctor: view.constructor,
                            address: view.byteOffset,
                            length: view instanceof DataView ? view.byteLength : view.length,
                            ownership: 1 /* ReferenceOwnership.kUserland */,
                            runtimeAllocated: 0
                        });
                    }
                    return view;
                }
                var maybeOldWasmMemory = emnapiExternalMemory.isDetachedArrayBuffer(view.buffer) ||
                    ((typeof SharedArrayBuffer === 'function') && (view.buffer instanceof SharedArrayBuffer));
                if (maybeOldWasmMemory && emnapiExternalMemory.wasmMemoryViewTable.has(view)) {
                    var info = emnapiExternalMemory.wasmMemoryViewTable.get(view);
                    var Ctor = info.Ctor;
                    var newView = void 0;
                    var Buffer_1 = emnapiCtx.feature.Buffer;
                    if (typeof Buffer_1 === 'function' && Ctor === Buffer_1) {
                        newView = Buffer_1.from(wasmMemory.buffer, info.address, info.length);
                    }
                    else {
                        newView = new Ctor(wasmMemory.buffer, info.address, info.length);
                    }
                    emnapiExternalMemory.wasmMemoryViewTable.set(newView, info);
                    return newView;
                }
                return view;
            },
            getViewPointer: function (view, shouldCopy) {
                view = emnapiExternalMemory.getOrUpdateMemoryView(view);
                if (view.buffer === wasmMemory.buffer) {
                    if (emnapiExternalMemory.wasmMemoryViewTable.has(view)) {
                        var _a = emnapiExternalMemory.wasmMemoryViewTable.get(view), address_1 = _a.address, ownership_1 = _a.ownership, runtimeAllocated_1 = _a.runtimeAllocated;
                        return { address: address_1, ownership: ownership_1, runtimeAllocated: runtimeAllocated_1, view: view };
                    }
                    return { address: view.byteOffset, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0, view: view };
                }
                var _b = emnapiExternalMemory.getArrayBufferPointer(view.buffer, shouldCopy), address = _b.address, ownership = _b.ownership, runtimeAllocated = _b.runtimeAllocated;
                return { address: address === 0 ? 0 : (address + view.byteOffset), ownership: ownership, runtimeAllocated: runtimeAllocated, view: view };
            }
        };
        /* eslint-disable @typescript-eslint/indent */
        /**
         * @__postset
         * ```
         * emnapiString.init();
         * ```
         */
        var emnapiString = {
            utf8Decoder: undefined,
            utf16Decoder: undefined,
            init: function () {
                var fallbackDecoder = {
                    decode: function (bytes) {
                        var inputIndex = 0;
                        var pendingSize = Math.min(0x1000, bytes.length + 1);
                        var pending = new Uint16Array(pendingSize);
                        var chunks = [];
                        var pendingIndex = 0;
                        for (;;) {
                            var more = inputIndex < bytes.length;
                            if (!more || (pendingIndex >= pendingSize - 1)) {
                                var subarray = pending.subarray(0, pendingIndex);
                                var arraylike = subarray;
                                chunks.push(String.fromCharCode.apply(null, arraylike));
                                if (!more) {
                                    return chunks.join('');
                                }
                                bytes = bytes.subarray(inputIndex);
                                inputIndex = 0;
                                pendingIndex = 0;
                            }
                            var byte1 = bytes[inputIndex++];
                            if ((byte1 & 0x80) === 0) {
                                pending[pendingIndex++] = byte1;
                            }
                            else if ((byte1 & 0xe0) === 0xc0) {
                                var byte2 = bytes[inputIndex++] & 0x3f;
                                pending[pendingIndex++] = ((byte1 & 0x1f) << 6) | byte2;
                            }
                            else if ((byte1 & 0xf0) === 0xe0) {
                                var byte2 = bytes[inputIndex++] & 0x3f;
                                var byte3 = bytes[inputIndex++] & 0x3f;
                                pending[pendingIndex++] = ((byte1 & 0x1f) << 12) | (byte2 << 6) | byte3;
                            }
                            else if ((byte1 & 0xf8) === 0xf0) {
                                var byte2 = bytes[inputIndex++] & 0x3f;
                                var byte3 = bytes[inputIndex++] & 0x3f;
                                var byte4 = bytes[inputIndex++] & 0x3f;
                                var codepoint = ((byte1 & 0x07) << 0x12) | (byte2 << 0x0c) | (byte3 << 0x06) | byte4;
                                if (codepoint > 0xffff) {
                                    codepoint -= 0x10000;
                                    pending[pendingIndex++] = (codepoint >>> 10) & 0x3ff | 0xd800;
                                    codepoint = 0xdc00 | codepoint & 0x3ff;
                                }
                                pending[pendingIndex++] = codepoint;
                            }
                            else ;
                        }
                    }
                };
                var utf8Decoder;
                utf8Decoder = typeof TextDecoder === 'function' ? new TextDecoder() : fallbackDecoder;
                emnapiString.utf8Decoder = utf8Decoder;
                var fallbackDecoder2 = {
                    decode: function (input) {
                        var bytes = new Uint16Array(input.buffer, input.byteOffset, input.byteLength / 2);
                        if (bytes.length <= 0x1000) {
                            return String.fromCharCode.apply(null, bytes);
                        }
                        var chunks = [];
                        var i = 0;
                        var len = 0;
                        for (; i < bytes.length; i += len) {
                            len = Math.min(0x1000, bytes.length - i);
                            chunks.push(String.fromCharCode.apply(null, bytes.subarray(i, i + len)));
                        }
                        return chunks.join('');
                    }
                };
                var utf16Decoder;
                utf16Decoder = typeof TextDecoder === 'function' ? new TextDecoder('utf-16le') : fallbackDecoder2;
                emnapiString.utf16Decoder = utf16Decoder;
            },
            lengthBytesUTF8: function (str) {
                var c;
                var len = 0;
                for (var i = 0; i < str.length; ++i) {
                    c = str.charCodeAt(i);
                    if (c <= 0x7F) {
                        len++;
                    }
                    else if (c <= 0x7FF) {
                        len += 2;
                    }
                    else if (c >= 0xD800 && c <= 0xDFFF) {
                        len += 4;
                        ++i;
                    }
                    else {
                        len += 3;
                    }
                }
                return len;
            },
            UTF8ToString: function (ptr, length) {
                if (!ptr || !length)
                    return '';
                ptr >>>= 0;
                var HEAPU8 = new Uint8Array(wasmMemory.buffer);
                var end = ptr;
                if (length === -1) {
                    for (; HEAPU8[end];)
                        ++end;
                }
                else {
                    end = ptr + (length >>> 0);
                }
                length = end - ptr;
                if (length <= 16) {
                    var idx = ptr;
                    var str = '';
                    while (idx < end) {
                        var u0 = HEAPU8[idx++];
                        if (!(u0 & 0x80)) {
                            str += String.fromCharCode(u0);
                            continue;
                        }
                        var u1 = HEAPU8[idx++] & 63;
                        if ((u0 & 0xE0) === 0xC0) {
                            str += String.fromCharCode(((u0 & 31) << 6) | u1);
                            continue;
                        }
                        var u2 = HEAPU8[idx++] & 63;
                        if ((u0 & 0xF0) === 0xE0) {
                            u0 = ((u0 & 15) << 12) | (u1 << 6) | u2;
                        }
                        else {
                            u0 = ((u0 & 7) << 18) | (u1 << 12) | (u2 << 6) | (HEAPU8[idx++] & 63);
                        }
                        if (u0 < 0x10000) {
                            str += String.fromCharCode(u0);
                        }
                        else {
                            var ch = u0 - 0x10000;
                            str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
                        }
                    }
                    return str;
                }
                return emnapiString.utf8Decoder.decode(((typeof SharedArrayBuffer === "function" && HEAPU8.buffer instanceof SharedArrayBuffer) || (Object.prototype.toString.call(HEAPU8.buffer.constructor) === "[object SharedArrayBuffer]")) ? HEAPU8.slice(ptr, end) : HEAPU8.subarray(ptr, end));
            },
            stringToUTF8: function (str, outPtr, maxBytesToWrite) {
                var HEAPU8 = new Uint8Array(wasmMemory.buffer);
                var outIdx = outPtr;
                outIdx >>>= 0;
                if (!(maxBytesToWrite > 0)) {
                    return 0;
                }
                var startIdx = outIdx;
                var endIdx = outIdx + maxBytesToWrite - 1;
                for (var i = 0; i < str.length; ++i) {
                    var u = str.charCodeAt(i);
                    if (u >= 0xD800 && u <= 0xDFFF) {
                        var u1 = str.charCodeAt(++i);
                        u = 0x10000 + ((u & 0x3FF) << 10) | (u1 & 0x3FF);
                    }
                    if (u <= 0x7F) {
                        if (outIdx >= endIdx)
                            break;
                        HEAPU8[outIdx++] = u;
                    }
                    else if (u <= 0x7FF) {
                        if (outIdx + 1 >= endIdx)
                            break;
                        HEAPU8[outIdx++] = 0xC0 | (u >> 6);
                        HEAPU8[outIdx++] = 0x80 | (u & 63);
                    }
                    else if (u <= 0xFFFF) {
                        if (outIdx + 2 >= endIdx)
                            break;
                        HEAPU8[outIdx++] = 0xE0 | (u >> 12);
                        HEAPU8[outIdx++] = 0x80 | ((u >> 6) & 63);
                        HEAPU8[outIdx++] = 0x80 | (u & 63);
                    }
                    else {
                        if (outIdx + 3 >= endIdx)
                            break;
                        HEAPU8[outIdx++] = 0xF0 | (u >> 18);
                        HEAPU8[outIdx++] = 0x80 | ((u >> 12) & 63);
                        HEAPU8[outIdx++] = 0x80 | ((u >> 6) & 63);
                        HEAPU8[outIdx++] = 0x80 | (u & 63);
                    }
                }
                HEAPU8[outIdx] = 0;
                return outIdx - startIdx;
            },
            UTF16ToString: function (ptr, length) {
                if (!ptr || !length)
                    return '';
                ptr >>>= 0;
                var end = ptr;
                if (length === -1) {
                    var idx = end >> 1;
                    var HEAPU16 = new Uint16Array(wasmMemory.buffer);
                    while (HEAPU16[idx])
                        ++idx;
                    end = idx << 1;
                }
                else {
                    end = ptr + (length >>> 0) * 2;
                }
                length = end - ptr;
                if (length <= 32) {
                    return String.fromCharCode.apply(null, new Uint16Array(wasmMemory.buffer, ptr, length / 2));
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var HEAPU8 = new Uint8Array(wasmMemory.buffer);
                return emnapiString.utf16Decoder.decode(((typeof SharedArrayBuffer === "function" && HEAPU8.buffer instanceof SharedArrayBuffer) || (Object.prototype.toString.call(HEAPU8.buffer.constructor) === "[object SharedArrayBuffer]")) ? HEAPU8.slice(ptr, end) : HEAPU8.subarray(ptr, end));
            },
            stringToUTF16: function (str, outPtr, maxBytesToWrite) {
                if (maxBytesToWrite === undefined) {
                    maxBytesToWrite = 0x7FFFFFFF;
                }
                if (maxBytesToWrite < 2)
                    return 0;
                maxBytesToWrite -= 2;
                var startPtr = outPtr;
                var numCharsToWrite = (maxBytesToWrite < str.length * 2) ? (maxBytesToWrite / 2) : str.length;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                for (var i = 0; i < numCharsToWrite; ++i) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var codeUnit = str.charCodeAt(i);
                    HEAP_DATA_VIEW.setInt16(outPtr, codeUnit, true);
                    outPtr += 2;
                }
                HEAP_DATA_VIEW.setInt16(outPtr, 0, true);
                return outPtr - startPtr;
            },
            newString: function (env, str, length, result, stringMaker) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                // @ts-expect-error
                var envObject = emnapiCtx.envStore.get(env);
                envObject.checkGCAccess();
                var autoLength = length === -1;
                var sizelength = length >>> 0;
                if (length !== 0) {
                    if (!str)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!(autoLength || (sizelength <= 2147483647)))
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var strValue = stringMaker(str, autoLength, sizelength);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var value = emnapiCtx.addToCurrentScope(strValue).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.clearLastError();
            },
            newExternalString: function (env, str, length, finalize_callback, finalize_hint, result, copied, createApi, stringMaker) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                // @ts-expect-error
                var envObject = emnapiCtx.envStore.get(env);
                envObject.checkGCAccess();
                var autoLength = length === -1;
                var sizelength = length >>> 0;
                if (length !== 0) {
                    if (!str)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!(autoLength || (sizelength <= 2147483647)))
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var status = createApi(env, str, length, result);
                if (status === 0 /* napi_status.napi_ok */) {
                    if (copied) {
                        var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                        HEAP_DATA_VIEW.setInt8(copied, 1, true);
                    }
                    if (finalize_callback) {
                        envObject.callFinalizer(finalize_callback, str, finalize_hint);
                    }
                }
                return status;
            }
        };
        /**
         * @__sig ippp
         */
        function napi_get_array_length(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                if (!handle.isArray()) {
                    return envObject.setLastError(8 /* napi_status.napi_array_expected */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var v = handle.value.length >>> 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setUint32(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppp
         */
        function napi_get_arraybuffer_info(env, arraybuffer, data, byte_length) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!arraybuffer)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(arraybuffer);
            if (!handle.isArrayBuffer()) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (data) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var p = emnapiExternalMemory.getArrayBufferPointer(handle.value, true).address;
                HEAP_DATA_VIEW.setInt32(data, p, true);
            }
            if (byte_length) {
                HEAP_DATA_VIEW.setUint32(byte_length, handle.value.byteLength, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_prototype(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                if (handle.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = handle.isObject() || handle.isFunction() ? handle.value : Object(handle.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var p = envObject.ensureHandleId(Object.getPrototypeOf(v));
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, p, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ippppppp
         */
        function napi_get_typedarray_info(env, typedarray, type, length, data, arraybuffer, byte_offset) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!typedarray)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(typedarray);
            if (!handle.isTypedArray()) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            var v = handle.value;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (type) {
                var t = void 0;
                if (v instanceof Int8Array) {
                    t = 0 /* napi_typedarray_type.napi_int8_array */;
                }
                else if (v instanceof Uint8Array) {
                    t = 1 /* napi_typedarray_type.napi_uint8_array */;
                }
                else if (v instanceof Uint8ClampedArray) {
                    t = 2 /* napi_typedarray_type.napi_uint8_clamped_array */;
                }
                else if (v instanceof Int16Array) {
                    t = 3 /* napi_typedarray_type.napi_int16_array */;
                }
                else if (v instanceof Uint16Array) {
                    t = 4 /* napi_typedarray_type.napi_uint16_array */;
                }
                else if (v instanceof Int32Array) {
                    t = 5 /* napi_typedarray_type.napi_int32_array */;
                }
                else if (v instanceof Uint32Array) {
                    t = 6 /* napi_typedarray_type.napi_uint32_array */;
                }
                else if (v instanceof Float32Array) {
                    t = 7 /* napi_typedarray_type.napi_float32_array */;
                }
                else if (v instanceof Float64Array) {
                    t = 8 /* napi_typedarray_type.napi_float64_array */;
                }
                else if (v instanceof BigInt64Array) {
                    t = 9 /* napi_typedarray_type.napi_bigint64_array */;
                }
                else if (v instanceof BigUint64Array) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    t = 10 /* napi_typedarray_type.napi_biguint64_array */;
                }
                else {
                    return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                }
                HEAP_DATA_VIEW.setInt32(type, t, true);
            }
            if (length) {
                HEAP_DATA_VIEW.setUint32(length, v.length, true);
            }
            var buffer;
            if (data || arraybuffer) {
                buffer = v.buffer;
                if (data) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var p = emnapiExternalMemory.getViewPointer(v, true).address;
                    HEAP_DATA_VIEW.setInt32(data, p, true);
                }
                if (arraybuffer) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var ab = envObject.ensureHandleId(buffer);
                    HEAP_DATA_VIEW.setInt32(arraybuffer, ab, true);
                }
            }
            if (byte_offset) {
                HEAP_DATA_VIEW.setUint32(byte_offset, v.byteOffset, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ipppp
         */
        function napi_get_buffer_info(env, buffer, data, length) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!buffer)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(buffer);
            if (!handle.isBuffer(emnapiCtx.feature.Buffer))
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (handle.isDataView()) {
                return napi_get_dataview_info(env, buffer, length, data, 0, 0);
            }
            return napi_get_typedarray_info(env, buffer, 0, length, data, 0, 0);
        }
        /**
         * @__sig ipppppp
         */
        function napi_get_dataview_info(env, dataview, byte_length, data, arraybuffer, byte_offset) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!dataview)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(dataview);
            if (!handle.isDataView()) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            var v = handle.value;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (byte_length) {
                HEAP_DATA_VIEW.setUint32(byte_length, v.byteLength, true);
            }
            var buffer;
            if (data || arraybuffer) {
                buffer = v.buffer;
                if (data) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var p = emnapiExternalMemory.getViewPointer(v, true).address;
                    HEAP_DATA_VIEW.setInt32(data, p, true);
                }
                if (arraybuffer) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var ab = envObject.ensureHandleId(buffer);
                    HEAP_DATA_VIEW.setInt32(arraybuffer, ab, true);
                }
            }
            if (byte_offset) {
                HEAP_DATA_VIEW.setUint32(byte_offset, v.byteOffset, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_date_value(env, value, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                if (!handle.isDate()) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                v = handle.value.valueOf();
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setFloat64(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ippp
         */
        function napi_get_value_bool(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'boolean') {
                return envObject.setLastError(7 /* napi_status.napi_boolean_expected */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = handle.value ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_value_double(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'number') {
                return envObject.setLastError(6 /* napi_status.napi_number_expected */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = handle.value;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setFloat64(result, r, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipppp
         */
        function napi_get_value_bigint_int64(env, value, result, lossless) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!emnapiCtx.feature.supportBigInt) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!lossless)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            var numberValue = handle.value;
            if (typeof numberValue !== 'bigint') {
                return envObject.setLastError(6 /* napi_status.napi_number_expected */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if ((numberValue >= (BigInt(-1) * (BigInt(1) << BigInt(63)))) && (numberValue < (BigInt(1) << BigInt(63)))) {
                HEAP_DATA_VIEW.setInt8(lossless, 1, true);
            }
            else {
                HEAP_DATA_VIEW.setInt8(lossless, 0, true);
                numberValue = numberValue & ((BigInt(1) << BigInt(64)) - BigInt(1));
                if (numberValue >= (BigInt(1) << BigInt(63))) {
                    numberValue = numberValue - (BigInt(1) << BigInt(64));
                }
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var low = Number(numberValue & BigInt(0xffffffff));
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var high = Number(numberValue >> BigInt(32));
            HEAP_DATA_VIEW.setInt32(result, low, true);
            HEAP_DATA_VIEW.setInt32(result + 4, high, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipppp
         */
        function napi_get_value_bigint_uint64(env, value, result, lossless) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!emnapiCtx.feature.supportBigInt) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!lossless)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            var numberValue = handle.value;
            if (typeof numberValue !== 'bigint') {
                return envObject.setLastError(6 /* napi_status.napi_number_expected */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if ((numberValue >= BigInt(0)) && (numberValue < (BigInt(1) << BigInt(64)))) {
                HEAP_DATA_VIEW.setInt8(lossless, 1, true);
            }
            else {
                HEAP_DATA_VIEW.setInt8(lossless, 0, true);
                numberValue = numberValue & ((BigInt(1) << BigInt(64)) - BigInt(1));
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var low = Number(numberValue & BigInt(0xffffffff));
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var high = Number(numberValue >> BigInt(32));
            HEAP_DATA_VIEW.setUint32(result, low, true);
            HEAP_DATA_VIEW.setUint32(result + 4, high, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ippppp
         */
        function napi_get_value_bigint_words(env, value, sign_bit, word_count, words) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!emnapiCtx.feature.supportBigInt) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!word_count)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (!handle.isBigInt()) {
                return envObject.setLastError(17 /* napi_status.napi_bigint_expected */);
            }
            var isMinus = handle.value < BigInt(0);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            var word_count_int = HEAP_DATA_VIEW.getUint32(word_count, true);
            var wordCount = 0;
            var bigintValue = isMinus ? (handle.value * BigInt(-1)) : handle.value;
            while (bigintValue !== BigInt(0)) {
                wordCount++;
                bigintValue = bigintValue >> BigInt(64);
            }
            bigintValue = isMinus ? (handle.value * BigInt(-1)) : handle.value;
            if (!sign_bit && !words) {
                word_count_int = wordCount;
                HEAP_DATA_VIEW.setUint32(word_count, word_count_int, true);
            }
            else {
                if (!sign_bit)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!words)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var wordsArr = [];
                while (bigintValue !== BigInt(0)) {
                    var uint64 = bigintValue & ((BigInt(1) << BigInt(64)) - BigInt(1));
                    wordsArr.push(uint64);
                    bigintValue = bigintValue >> BigInt(64);
                }
                var len = Math.min(word_count_int, wordsArr.length);
                for (var i = 0; i < len; i++) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var low = Number(wordsArr[i] & BigInt(0xffffffff));
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var high = Number(wordsArr[i] >> BigInt(32));
                    HEAP_DATA_VIEW.setUint32(words + i * 8, low, true);
                    HEAP_DATA_VIEW.setUint32(words + (i * 8 + 4), high, true);
                }
                HEAP_DATA_VIEW.setInt32(sign_bit, isMinus ? 1 : 0, true);
                HEAP_DATA_VIEW.setUint32(word_count, len, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_value_external(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (!handle.isExternal()) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var p = handle.data();
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, p, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_value_int32(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'number') {
                return envObject.setLastError(6 /* napi_status.napi_number_expected */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v = new Int32Array([handle.value])[0];
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, v, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_value_int64(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'number') {
                return envObject.setLastError(6 /* napi_status.napi_number_expected */);
            }
            var numberValue = handle.value;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (numberValue === Number.POSITIVE_INFINITY || numberValue === Number.NEGATIVE_INFINITY || isNaN(numberValue)) {
                HEAP_DATA_VIEW.setInt32(result, 0, true);
                HEAP_DATA_VIEW.setInt32(result + 4, 0, true);
            }
            else if (numberValue < /* INT64_RANGE_NEGATIVE */ -9223372036854776e3) {
                HEAP_DATA_VIEW.setInt32(result, 0, true);
                HEAP_DATA_VIEW.setInt32(result + 4, 2147483648, true);
            }
            else if (numberValue >= /* INT64_RANGE_POSITIVE */ 9223372036854776000) {
                HEAP_DATA_VIEW.setUint32(result, 4294967295, true);
                HEAP_DATA_VIEW.setUint32(result + 4, 2147483647, true);
            }
            else {
                $emnapiSetValueI64(result, Math.trunc(numberValue));
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippppp
         */
        function napi_get_value_string_latin1(env, value, buf, buf_size, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            buf_size = buf_size >>> 0;
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (!buf) {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                HEAP_DATA_VIEW.setUint32(result, handle.value.length, true);
            }
            else if (buf_size !== 0) {
                var copied = 0;
                var v = void 0;
                for (var i = 0; i < buf_size - 1; ++i) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    v = handle.value.charCodeAt(i) & 0xff;
                    HEAP_DATA_VIEW.setUint8(buf + i, v, true);
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    copied++;
                }
                HEAP_DATA_VIEW.setUint8(buf + copied, 0, true);
                if (result) {
                    HEAP_DATA_VIEW.setUint32(result, copied, true);
                }
            }
            else if (result) {
                HEAP_DATA_VIEW.setUint32(result, 0, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippppp
         */
        function napi_get_value_string_utf8(env, value, buf, buf_size, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            buf_size = buf_size >>> 0;
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (!buf) {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var strLength = emnapiString.lengthBytesUTF8(handle.value);
                HEAP_DATA_VIEW.setUint32(result, strLength, true);
            }
            else if (buf_size !== 0) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var copied = emnapiString.stringToUTF8(handle.value, buf, buf_size);
                if (result) {
                    HEAP_DATA_VIEW.setUint32(result, copied, true);
                }
            }
            else if (result) {
                HEAP_DATA_VIEW.setUint32(result, 0, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippppp
         */
        function napi_get_value_string_utf16(env, value, buf, buf_size, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            buf_size = buf_size >>> 0;
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (!buf) {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                HEAP_DATA_VIEW.setUint32(result, handle.value.length, true);
            }
            else if (buf_size !== 0) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var copied = emnapiString.stringToUTF16(handle.value, buf, buf_size * 2);
                if (result) {
                    HEAP_DATA_VIEW.setUint32(result, copied / 2, true);
                }
            }
            else if (result) {
                HEAP_DATA_VIEW.setUint32(result, 0, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_value_uint32(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'number') {
                return envObject.setLastError(6 /* napi_status.napi_number_expected */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v = new Uint32Array([handle.value])[0];
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setUint32(result, v, true);
            return envObject.clearLastError();
        }
        var convert2cMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_get_array_length: napi_get_array_length,
            napi_get_arraybuffer_info: napi_get_arraybuffer_info,
            napi_get_buffer_info: napi_get_buffer_info,
            napi_get_dataview_info: napi_get_dataview_info,
            napi_get_date_value: napi_get_date_value,
            napi_get_prototype: napi_get_prototype,
            napi_get_typedarray_info: napi_get_typedarray_info,
            napi_get_value_bigint_int64: napi_get_value_bigint_int64,
            napi_get_value_bigint_uint64: napi_get_value_bigint_uint64,
            napi_get_value_bigint_words: napi_get_value_bigint_words,
            napi_get_value_bool: napi_get_value_bool,
            napi_get_value_double: napi_get_value_double,
            napi_get_value_external: napi_get_value_external,
            napi_get_value_int32: napi_get_value_int32,
            napi_get_value_int64: napi_get_value_int64,
            napi_get_value_string_latin1: napi_get_value_string_latin1,
            napi_get_value_string_utf16: napi_get_value_string_utf16,
            napi_get_value_string_utf8: napi_get_value_string_utf8,
            napi_get_value_uint32: napi_get_value_uint32
        });
        /**
         * @__sig ipip
         */
        function napi_create_int32(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v = emnapiCtx.addToCurrentScope(value).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, v, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipip
         */
        function napi_create_uint32(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v = emnapiCtx.addToCurrentScope(value >>> 0).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, v, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipjp
         */
        function napi_create_int64(env, low, high, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            var value;
            if (!high)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            value = Number(low);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v1 = emnapiCtx.addToCurrentScope(value).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(high, v1, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipdp
         */
        function napi_create_double(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v = emnapiCtx.addToCurrentScope(value).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, v, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipppp
         */
        function napi_create_string_latin1(env, str, length, result) {
            return emnapiString.newString(env, str, length, result, function (str, autoLength, sizeLength) {
                var latin1String = '';
                var len = 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                if (autoLength) {
                    while (true) {
                        var ch = HEAP_DATA_VIEW.getUint8(str, true);
                        if (!ch)
                            break;
                        latin1String += String.fromCharCode(ch);
                        str++;
                    }
                }
                else {
                    while (len < sizeLength) {
                        var ch = HEAP_DATA_VIEW.getUint8(str, true);
                        if (!ch)
                            break;
                        latin1String += String.fromCharCode(ch);
                        len++;
                        str++;
                    }
                }
                return latin1String;
            });
        }
        /**
         * @__sig ipppp
         */
        function napi_create_string_utf16(env, str, length, result) {
            return emnapiString.newString(env, str, length, result, function (str) {
                return emnapiString.UTF16ToString(str, length);
            });
        }
        /**
         * @__sig ipppp
         */
        function napi_create_string_utf8(env, str, length, result) {
            return emnapiString.newString(env, str, length, result, function (str) {
                return emnapiString.UTF8ToString(str, length);
            });
        }
        /**
         * @__sig ippppppp
         */
        function node_api_create_external_string_latin1(env, str, length, finalize_callback, finalize_hint, result, copied) {
            return emnapiString.newExternalString(env, str, length, finalize_callback, finalize_hint, result, copied, napi_create_string_latin1, undefined);
        }
        /**
         * @__sig ippppppp
         */
        function node_api_create_external_string_utf16(env, str, length, finalize_callback, finalize_hint, result, copied) {
            return emnapiString.newExternalString(env, str, length, finalize_callback, finalize_hint, result, copied, napi_create_string_utf16, undefined);
        }
        /**
         * @__sig ipppp
         */
        function node_api_create_property_key_latin1(env, str, length, result) {
            return napi_create_string_latin1(env, str, length, result);
        }
        /**
         * @__sig ipppp
         */
        function node_api_create_property_key_utf8(env, str, length, result) {
            return napi_create_string_utf8(env, str, length, result);
        }
        /**
         * @__sig ipppp
         */
        function node_api_create_property_key_utf16(env, str, length, result) {
            return napi_create_string_utf16(env, str, length, result);
        }
        /**
         * @__sig ipjp
         */
        function napi_create_bigint_int64(env, low, high, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!emnapiCtx.feature.supportBigInt) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            var value;
            if (!high)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            value = low;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v1 = emnapiCtx.addToCurrentScope(value).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(high, v1, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipjp
         */
        function napi_create_bigint_uint64(env, low, high, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!emnapiCtx.feature.supportBigInt) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            var value;
            if (!high)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            value = low & ((BigInt(1) << BigInt(64)) - BigInt(1));
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v1 = emnapiCtx.addToCurrentScope(value).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(high, v1, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipippp
         */
        function napi_create_bigint_words(env, sign_bit, word_count, words, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v, i;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!emnapiCtx.feature.supportBigInt) {
                    return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                }
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                word_count = word_count >>> 0;
                if (word_count > 2147483647) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if (word_count > (1024 * 1024 / (4 * 8) / 2)) {
                    throw new RangeError('Maximum BigInt size exceeded');
                }
                var value = BigInt(0);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                for (i = 0; i < word_count; i++) {
                    var low = HEAP_DATA_VIEW.getUint32(words + i * 8, true);
                    var high = HEAP_DATA_VIEW.getUint32(words + (i * 8 + 4), true);
                    var wordi = BigInt(low) | (BigInt(high) << BigInt(32));
                    value += wordi << BigInt(64 * i);
                }
                value *= ((BigInt(sign_bit) % BigInt(2) === BigInt(0)) ? BigInt(1) : BigInt(-1));
                v = emnapiCtx.addToCurrentScope(value).id;
                HEAP_DATA_VIEW.setInt32(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        var convert2napiMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_create_bigint_int64: napi_create_bigint_int64,
            napi_create_bigint_uint64: napi_create_bigint_uint64,
            napi_create_bigint_words: napi_create_bigint_words,
            napi_create_double: napi_create_double,
            napi_create_int32: napi_create_int32,
            napi_create_int64: napi_create_int64,
            napi_create_string_latin1: napi_create_string_latin1,
            napi_create_string_utf16: napi_create_string_utf16,
            napi_create_string_utf8: napi_create_string_utf8,
            napi_create_uint32: napi_create_uint32,
            node_api_create_external_string_latin1: node_api_create_external_string_latin1,
            node_api_create_external_string_utf16: node_api_create_external_string_utf16,
            node_api_create_property_key_latin1: node_api_create_property_key_latin1,
            node_api_create_property_key_utf16: node_api_create_property_key_utf16,
            node_api_create_property_key_utf8: node_api_create_property_key_utf8
        });
        function emnapiCreateFunction(envObject, utf8name, length, cb, data) {
            var functionName = (!utf8name || !length) ? '' : (emnapiString.UTF8ToString(utf8name, length));
            var f;
            var napiCallback = (wasmTable.get(cb));
            var callback = function (envObject) {
                return napiCallback(envObject.id, envObject.ctx.scopeStore.currentScope.id);
            };
            var makeFunction = function (envObject, callback) {
                return function () {
                    var scope = envObject.ctx.openScope(envObject);
                    var callbackInfo = scope.callbackInfo;
                    callbackInfo.data = data;
                    callbackInfo.args = arguments;
                    callbackInfo.thiz = this;
                    callbackInfo.fn = f;
                    try {
                        var napiValue = envObject.callIntoModule(callback);
                        return (!napiValue) ? undefined : envObject.ctx.handleStore.get(napiValue).value;
                    }
                    finally {
                        callbackInfo.data = 0;
                        callbackInfo.args = undefined;
                        callbackInfo.thiz = undefined;
                        callbackInfo.fn = undefined;
                        envObject.ctx.closeScope(envObject, scope);
                    }
                };
            };
            if (functionName === '') {
                f = makeFunction(envObject, callback);
                return { status: 0 /* napi_status.napi_ok */, f: f };
            }
            if (!(/^[_$a-zA-Z][_$a-zA-Z0-9]*$/.test(functionName))) {
                return { status: 1 /* napi_status.napi_invalid_arg */, f: undefined };
            }
            if (emnapiCtx.feature.supportNewFunction) {
                var _ = makeFunction(envObject, callback);
                try {
                    f = (new Function('_', 'return function ' + functionName + '(){' +
                        '"use strict";' +
                        'return _.apply(this,arguments);' +
                        '};'))(_);
                }
                catch (_err) {
                    f = makeFunction(envObject, callback);
                    if (emnapiCtx.feature.canSetFunctionName)
                        Object.defineProperty(f, 'name', { value: functionName });
                }
            }
            else {
                f = makeFunction(envObject, callback);
                if (emnapiCtx.feature.canSetFunctionName)
                    Object.defineProperty(f, 'name', { value: functionName });
            }
            return { status: 0 /* napi_status.napi_ok */, f: f };
        }
        function emnapiDefineProperty(envObject, obj, propertyName, method, getter, setter, value, attributes, data) {
            if (getter || setter) {
                var localGetter = void 0;
                var localSetter = void 0;
                if (getter) {
                    localGetter = emnapiCreateFunction(envObject, 0, 0, getter, data).f;
                }
                if (setter) {
                    localSetter = emnapiCreateFunction(envObject, 0, 0, setter, data).f;
                }
                var desc = {
                    configurable: (attributes & 4 /* napi_property_attributes.napi_configurable */) !== 0,
                    enumerable: (attributes & 2 /* napi_property_attributes.napi_enumerable */) !== 0,
                    get: localGetter,
                    set: localSetter
                };
                Object.defineProperty(obj, propertyName, desc);
            }
            else if (method) {
                var localMethod = emnapiCreateFunction(envObject, 0, 0, method, data).f;
                var desc = {
                    configurable: (attributes & 4 /* napi_property_attributes.napi_configurable */) !== 0,
                    enumerable: (attributes & 2 /* napi_property_attributes.napi_enumerable */) !== 0,
                    writable: (attributes & 1 /* napi_property_attributes.napi_writable */) !== 0,
                    value: localMethod
                };
                Object.defineProperty(obj, propertyName, desc);
            }
            else {
                var desc = {
                    configurable: (attributes & 4 /* napi_property_attributes.napi_configurable */) !== 0,
                    enumerable: (attributes & 2 /* napi_property_attributes.napi_enumerable */) !== 0,
                    writable: (attributes & 1 /* napi_property_attributes.napi_writable */) !== 0,
                    value: emnapiCtx.handleStore.get(value).value
                };
                Object.defineProperty(obj, propertyName, desc);
            }
        }
        function emnapiGetHandle(js_object) {
            var handle = emnapiCtx.handleStore.get(js_object);
            if (!(handle.isObject() || handle.isFunction())) {
                return { status: 1 /* napi_status.napi_invalid_arg */ };
            }
            if (typeof emnapiExternalMemory !== 'undefined' && ArrayBuffer.isView(handle.value)) {
                if (emnapiExternalMemory.wasmMemoryViewTable.has(handle.value)) {
                    handle = emnapiCtx.addToCurrentScope(emnapiExternalMemory.wasmMemoryViewTable.get(handle.value));
                }
            }
            return { status: 0 /* napi_status.napi_ok */, handle: handle };
        }
        function emnapiWrap(env, js_object, native_object, finalize_cb, finalize_hint, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var referenceId;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!emnapiCtx.feature.supportFinalizer) {
                    if (finalize_cb) {
                        throw emnapiCtx.createNotSupportWeakRefError('napi_wrap', 'Parameter "finalize_cb" must be 0(NULL)');
                    }
                    if (result) {
                        throw emnapiCtx.createNotSupportWeakRefError('napi_wrap', 'Parameter "result" must be 0(NULL)');
                    }
                }
                if (!js_object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handleResult = emnapiGetHandle(js_object);
                if (handleResult.status !== 0 /* napi_status.napi_ok */) {
                    return envObject.setLastError(handleResult.status);
                }
                var handle = handleResult.handle;
                if (envObject.getObjectBinding(handle.value).wrapped !== 0) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var reference = void 0;
                if (result) {
                    if (!finalize_cb)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                    reference = emnapiCtx.createReferenceWithFinalizer(envObject, handle.id, 0, 1 /* ReferenceOwnership.kUserland */, finalize_cb, native_object, finalize_hint);
                    referenceId = reference.id;
                    var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                    HEAP_DATA_VIEW.setInt32(result, referenceId, true);
                }
                else {
                    if (finalize_cb) {
                        reference = emnapiCtx.createReferenceWithFinalizer(envObject, handle.id, 0, 0 /* ReferenceOwnership.kRuntime */, finalize_cb, native_object, finalize_hint);
                    }
                    else {
                        reference = emnapiCtx.createReferenceWithData(envObject, handle.id, 0, 0 /* ReferenceOwnership.kRuntime */, native_object);
                    }
                }
                envObject.getObjectBinding(handle.value).wrapped = reference.id;
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        function emnapiUnwrap(env, js_object, result, action) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var data;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!js_object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (action === 0 /* UnwrapAction.KeepWrap */) {
                    if (!result)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var value = emnapiCtx.handleStore.get(js_object);
                if (!(value.isObject() || value.isFunction())) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var binding = envObject.getObjectBinding(value.value);
                var referenceId = binding.wrapped;
                var ref = emnapiCtx.refStore.get(referenceId);
                if (!ref)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (result) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    data = ref.data();
                    var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                    HEAP_DATA_VIEW.setInt32(result, data, true);
                }
                if (action === 1 /* UnwrapAction.RemoveWrap */) {
                    binding.wrapped = 0;
                    if (ref.ownership() === 1 /* ReferenceOwnership.kUserland */) {
                        // When the wrap is been removed, the finalizer should be reset.
                        ref.resetFinalizer();
                    }
                    else {
                        ref.dispose();
                    }
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppppppp
         */
        function napi_define_class(env, utf8name, length, constructor, callback_data, property_count, properties, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var propPtr, valueHandleId, attributes;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!constructor)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                property_count = property_count >>> 0;
                if (property_count > 0) {
                    if (!properties)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if ((length < -1) || (length > 2147483647) || (!utf8name)) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var fresult = emnapiCreateFunction(envObject, utf8name, length, constructor, callback_data);
                if (fresult.status !== 0 /* napi_status.napi_ok */)
                    return envObject.setLastError(fresult.status);
                var F = fresult.f;
                var propertyName = void 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                for (var i = 0; i < property_count; i++) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    propPtr = properties + (i * (4 * 8));
                    var utf8Name = HEAP_DATA_VIEW.getInt32(propPtr, true);
                    var name_1 = HEAP_DATA_VIEW.getInt32(propPtr + 4, true);
                    var method = HEAP_DATA_VIEW.getInt32(propPtr + 8, true);
                    var getter = HEAP_DATA_VIEW.getInt32(propPtr + 12, true);
                    var setter = HEAP_DATA_VIEW.getInt32(propPtr + 16, true);
                    var value = HEAP_DATA_VIEW.getInt32(propPtr + 20, true);
                    attributes = HEAP_DATA_VIEW.getInt32(propPtr + 24, true);
                    var data = HEAP_DATA_VIEW.getInt32(propPtr + 28, true);
                    if (utf8Name) {
                        propertyName = emnapiString.UTF8ToString(utf8Name, -1);
                    }
                    else {
                        if (!name_1) {
                            return envObject.setLastError(4 /* napi_status.napi_name_expected */);
                        }
                        propertyName = emnapiCtx.handleStore.get(name_1).value;
                        if (typeof propertyName !== 'string' && typeof propertyName !== 'symbol') {
                            return envObject.setLastError(4 /* napi_status.napi_name_expected */);
                        }
                    }
                    if ((attributes & 1024 /* napi_property_attributes.napi_static */) !== 0) {
                        emnapiDefineProperty(envObject, F, propertyName, method, getter, setter, value, attributes, data);
                        continue;
                    }
                    emnapiDefineProperty(envObject, F.prototype, propertyName, method, getter, setter, value, attributes, data);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var valueHandle = emnapiCtx.addToCurrentScope(F);
                valueHandleId = valueHandle.id;
                HEAP_DATA_VIEW.setInt32(result, valueHandleId, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppppp
         */
        function napi_wrap(env, js_object, native_object, finalize_cb, finalize_hint, result) {
            return emnapiWrap(env, js_object, native_object, finalize_cb, finalize_hint, result);
        }
        /**
         * @__sig ippp
         */
        function napi_unwrap(env, js_object, result) {
            return emnapiUnwrap(env, js_object, result, 0 /* UnwrapAction.KeepWrap */);
        }
        /**
         * @__sig ippp
         */
        function napi_remove_wrap(env, js_object, result) {
            return emnapiUnwrap(env, js_object, result, 1 /* UnwrapAction.RemoveWrap */);
        }
        /**
         * @__sig ippp
         */
        function napi_type_tag_object(env, object, type_tag) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!object) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 1 /* napi_status.napi_invalid_arg */);
                }
                var value = emnapiCtx.handleStore.get(object);
                if (!(value.isObject() || value.isFunction())) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 2 /* napi_status.napi_object_expected */);
                }
                if (!type_tag) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 1 /* napi_status.napi_invalid_arg */);
                }
                var binding = envObject.getObjectBinding(value.value);
                if (binding.tag !== null) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 1 /* napi_status.napi_invalid_arg */);
                }
                var tag = new Uint8Array(16);
                tag.set(new Uint8Array(wasmMemory.buffer, type_tag, 16));
                binding.tag = new Uint32Array(tag.buffer);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppp
         */
        function napi_check_object_type_tag(env, object, type_tag, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars, one-var
            var ret = true;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!object) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 1 /* napi_status.napi_invalid_arg */);
                }
                var value = emnapiCtx.handleStore.get(object);
                if (!(value.isObject() || value.isFunction())) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 2 /* napi_status.napi_object_expected */);
                }
                if (!type_tag) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 1 /* napi_status.napi_invalid_arg */);
                }
                if (!result) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 1 /* napi_status.napi_invalid_arg */);
                }
                var binding = envObject.getObjectBinding(value.value);
                if (binding.tag !== null) {
                    var tag = binding.tag;
                    var typeTag = new Uint32Array(wasmMemory.buffer, type_tag, 4);
                    ret = (tag[0] === typeTag[0] &&
                        tag[1] === typeTag[1] &&
                        tag[2] === typeTag[2] &&
                        tag[3] === typeTag[3]);
                }
                else {
                    ret = false;
                }
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, ret ? 1 : 0, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppppp
         */
        function napi_add_finalizer(env, js_object, finalize_data, finalize_cb, finalize_hint, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!emnapiCtx.feature.supportFinalizer) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            if (!js_object)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!finalize_cb)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handleResult = emnapiGetHandle(js_object);
            if (handleResult.status !== 0 /* napi_status.napi_ok */) {
                return envObject.setLastError(handleResult.status);
            }
            var handle = handleResult.handle;
            var ownership = !result ? 0 /* ReferenceOwnership.kRuntime */ : 1 /* ReferenceOwnership.kUserland */;
            var reference = emnapiCtx.createReferenceWithFinalizer(envObject, handle.id, 0, ownership, finalize_cb, finalize_data, finalize_hint);
            if (result) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var referenceId = reference.id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, referenceId, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ipppp
         */
        function node_api_post_finalizer(env, finalize_cb, finalize_data, finalize_hint) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            envObject.enqueueFinalizer(emnapiCtx.createTrackedFinalizer(envObject, finalize_cb, finalize_data, finalize_hint));
            return envObject.clearLastError();
        }
        var wrapMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_add_finalizer: napi_add_finalizer,
            napi_check_object_type_tag: napi_check_object_type_tag,
            napi_define_class: napi_define_class,
            napi_remove_wrap: napi_remove_wrap,
            napi_type_tag_object: napi_type_tag_object,
            napi_unwrap: napi_unwrap,
            napi_wrap: napi_wrap,
            node_api_post_finalizer: node_api_post_finalizer
        });
        /**
         * @__sig ipippppp
         */
        function emnapi_create_memory_view(env, typedarray_type, external_data, byte_length, finalize_cb, finalize_hint, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                byte_length = byte_length >>> 0;
                if (!external_data) {
                    byte_length = 0;
                }
                if (byte_length > 2147483647) {
                    throw new RangeError('Cannot create a memory view larger than 2147483647 bytes');
                }
                if ((external_data + byte_length) > wasmMemory.buffer.byteLength) {
                    throw new RangeError('Memory out of range');
                }
                if (!emnapiCtx.feature.supportFinalizer && finalize_cb) {
                    throw emnapiCtx.createNotSupportWeakRefError('emnapi_create_memory_view', 'Parameter "finalize_cb" must be 0(NULL)');
                }
                var viewDescriptor = void 0;
                switch (typedarray_type) {
                    case 0 /* emnapi_memory_view_type.emnapi_int8_array */:
                        viewDescriptor = { Ctor: Int8Array, address: external_data, length: byte_length, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 1 /* emnapi_memory_view_type.emnapi_uint8_array */:
                        viewDescriptor = { Ctor: Uint8Array, address: external_data, length: byte_length, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 2 /* emnapi_memory_view_type.emnapi_uint8_clamped_array */:
                        viewDescriptor = { Ctor: Uint8ClampedArray, address: external_data, length: byte_length, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 3 /* emnapi_memory_view_type.emnapi_int16_array */:
                        viewDescriptor = { Ctor: Int16Array, address: external_data, length: byte_length >> 1, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 4 /* emnapi_memory_view_type.emnapi_uint16_array */:
                        viewDescriptor = { Ctor: Uint16Array, address: external_data, length: byte_length >> 1, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 5 /* emnapi_memory_view_type.emnapi_int32_array */:
                        viewDescriptor = { Ctor: Int32Array, address: external_data, length: byte_length >> 2, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 6 /* emnapi_memory_view_type.emnapi_uint32_array */:
                        viewDescriptor = { Ctor: Uint32Array, address: external_data, length: byte_length >> 2, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 7 /* emnapi_memory_view_type.emnapi_float32_array */:
                        viewDescriptor = { Ctor: Float32Array, address: external_data, length: byte_length >> 2, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 8 /* emnapi_memory_view_type.emnapi_float64_array */:
                        viewDescriptor = { Ctor: Float64Array, address: external_data, length: byte_length >> 3, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 9 /* emnapi_memory_view_type.emnapi_bigint64_array */:
                        viewDescriptor = { Ctor: BigInt64Array, address: external_data, length: byte_length >> 3, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 10 /* emnapi_memory_view_type.emnapi_biguint64_array */:
                        viewDescriptor = { Ctor: BigUint64Array, address: external_data, length: byte_length >> 3, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case -1 /* emnapi_memory_view_type.emnapi_data_view */:
                        viewDescriptor = { Ctor: DataView, address: external_data, length: byte_length, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case -2 /* emnapi_memory_view_type.emnapi_buffer */: {
                        if (!emnapiCtx.feature.Buffer) {
                            throw emnapiCtx.createNotSupportBufferError('emnapi_create_memory_view', '');
                        }
                        viewDescriptor = { Ctor: emnapiCtx.feature.Buffer, address: external_data, length: byte_length, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    }
                    default: return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var Ctor = viewDescriptor.Ctor;
                var typedArray = typedarray_type === -2 /* emnapi_memory_view_type.emnapi_buffer */
                    ? emnapiCtx.feature.Buffer.from(wasmMemory.buffer, viewDescriptor.address, viewDescriptor.length)
                    : new Ctor(wasmMemory.buffer, viewDescriptor.address, viewDescriptor.length);
                var handle = emnapiCtx.addToCurrentScope(typedArray);
                emnapiExternalMemory.wasmMemoryViewTable.set(typedArray, viewDescriptor);
                if (finalize_cb) {
                    var status_1 = napi_add_finalizer(env, handle.id, external_data, finalize_cb, finalize_hint, /* NULL */ 0);
                    if (status_1 === 10 /* napi_status.napi_pending_exception */) {
                        var err = envObject.tryCatch.extractException();
                        envObject.clearLastError();
                        throw err;
                    }
                    else if (status_1 !== 0 /* napi_status.napi_ok */) {
                        return envObject.setLastError(status_1);
                    }
                }
                value = handle.id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig i
         */
        function emnapi_is_support_weakref() {
            return emnapiCtx.feature.supportFinalizer ? 1 : 0;
        }
        /**
         * @__sig i
         */
        function emnapi_is_support_bigint() {
            return emnapiCtx.feature.supportBigInt ? 1 : 0;
        }
        /**
         * @__sig i
         */
        function emnapi_is_node_binding_available() {
            return emnapiNodeBinding ? 1 : 0;
        }
        function $emnapiSyncMemory(js_to_wasm, arrayBufferOrView, offset, len) {
            offset = offset !== null && offset !== void 0 ? offset : 0;
            offset = offset >>> 0;
            var view;
            if (arrayBufferOrView instanceof ArrayBuffer) {
                var pointer = emnapiExternalMemory.getArrayBufferPointer(arrayBufferOrView, false).address;
                if (!pointer)
                    throw new Error('Unknown ArrayBuffer address');
                if (typeof len !== 'number' || len === -1) {
                    len = arrayBufferOrView.byteLength - offset;
                }
                len = len >>> 0;
                if (len === 0)
                    return arrayBufferOrView;
                view = new Uint8Array(arrayBufferOrView, offset, len);
                var wasmMemoryU8 = new Uint8Array(wasmMemory.buffer);
                if (!js_to_wasm) {
                    view.set(wasmMemoryU8.subarray(pointer, pointer + len));
                }
                else {
                    wasmMemoryU8.set(view, pointer);
                }
                return arrayBufferOrView;
            }
            if (ArrayBuffer.isView(arrayBufferOrView)) {
                var viewPointerInfo = emnapiExternalMemory.getViewPointer(arrayBufferOrView, false);
                var latestView = viewPointerInfo.view;
                var pointer = viewPointerInfo.address;
                if (!pointer)
                    throw new Error('Unknown ArrayBuffer address');
                if (typeof len !== 'number' || len === -1) {
                    len = latestView.byteLength - offset;
                }
                len = len >>> 0;
                if (len === 0)
                    return latestView;
                view = new Uint8Array(latestView.buffer, latestView.byteOffset + offset, len);
                var wasmMemoryU8 = new Uint8Array(wasmMemory.buffer);
                if (!js_to_wasm) {
                    view.set(wasmMemoryU8.subarray(pointer, pointer + len));
                }
                else {
                    wasmMemoryU8.set(view, pointer);
                }
                return latestView;
            }
            throw new TypeError('emnapiSyncMemory expect ArrayBuffer or ArrayBufferView as first parameter');
        }
        /**
         * @__sig ipippp
         */
        function emnapi_sync_memory(env, js_to_wasm, arraybuffer_or_view, offset, len) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!arraybuffer_or_view)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                var handleId = HEAP_DATA_VIEW.getInt32(arraybuffer_or_view, true);
                var handle = envObject.ctx.handleStore.get(handleId);
                if (!handle.isArrayBuffer() && !handle.isTypedArray() && !handle.isDataView()) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var ret = $emnapiSyncMemory(Boolean(js_to_wasm), handle.value, offset, len);
                if (handle.value !== ret) {
                    v = envObject.ensureHandleId(ret);
                    HEAP_DATA_VIEW.setInt32(arraybuffer_or_view, v, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        function $emnapiGetMemoryAddress(arrayBufferOrView) {
            var isArrayBuffer = arrayBufferOrView instanceof ArrayBuffer;
            var isDataView = arrayBufferOrView instanceof DataView;
            var isTypedArray = ArrayBuffer.isView(arrayBufferOrView) && !isDataView;
            if (!isArrayBuffer && !isTypedArray && !isDataView) {
                throw new TypeError('emnapiGetMemoryAddress expect ArrayBuffer or ArrayBufferView as first parameter');
            }
            var info;
            if (isArrayBuffer) {
                info = emnapiExternalMemory.getArrayBufferPointer(arrayBufferOrView, false);
            }
            else {
                info = emnapiExternalMemory.getViewPointer(arrayBufferOrView, false);
            }
            return {
                address: info.address,
                ownership: info.ownership,
                runtimeAllocated: info.runtimeAllocated
            };
        }
        /**
         * @__sig ipppp
         */
        function emnapi_get_memory_address(env, arraybuffer_or_view, address, ownership, runtime_allocated) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var p, runtimeAllocated, ownershipOut;
            var info;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!arraybuffer_or_view)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!address && !ownership && !runtime_allocated) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var handle = envObject.ctx.handleStore.get(arraybuffer_or_view);
                info = $emnapiGetMemoryAddress(handle.value);
                p = info.address;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                if (address) {
                    HEAP_DATA_VIEW.setInt32(address, p, true);
                }
                if (ownership) {
                    ownershipOut = info.ownership;
                    HEAP_DATA_VIEW.setInt32(ownership, ownershipOut, true);
                }
                if (runtime_allocated) {
                    runtimeAllocated = info.runtimeAllocated;
                    HEAP_DATA_VIEW.setInt8(runtime_allocated, runtimeAllocated, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipp
         */
        function emnapi_get_runtime_version(env, version) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!version)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var runtimeVersion;
            try {
                runtimeVersion = emnapiCtx.getRuntimeVersions().version;
            }
            catch (_) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var versions = runtimeVersion.split('.')
                .map(function (n) { return Number(n); });
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setUint32(version, versions[0], true);
            HEAP_DATA_VIEW.setUint32(version + 4, versions[1], true);
            HEAP_DATA_VIEW.setUint32(version + 8, versions[2], true);
            return envObject.clearLastError();
        }
        var emnapiMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            $emnapiGetMemoryAddress: $emnapiGetMemoryAddress,
            $emnapiSyncMemory: $emnapiSyncMemory,
            emnapi_create_memory_view: emnapi_create_memory_view,
            emnapi_get_memory_address: emnapi_get_memory_address,
            emnapi_get_runtime_version: emnapi_get_runtime_version,
            emnapi_is_node_binding_available: emnapi_is_node_binding_available,
            emnapi_is_support_bigint: emnapi_is_support_bigint,
            emnapi_is_support_weakref: emnapi_is_support_weakref,
            emnapi_sync_memory: emnapi_sync_memory
        });
        /**
         * @__sig ipp
         */
        function napi_create_array(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope([]).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_create_array_with_length(env, length, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            length = length >>> 0;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope(new Array(length)).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        function emnapiCreateArrayBuffer(byte_length, data) {
            byte_length = byte_length >>> 0;
            var arrayBuffer = new ArrayBuffer(byte_length);
            if (data) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var p = emnapiExternalMemory.getArrayBufferPointer(arrayBuffer, true).address;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(data, p, true);
            }
            return arrayBuffer;
        }
        /**
         * @__sig ipppp
         */
        function napi_create_arraybuffer(env, byte_length, data, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var arrayBuffer = emnapiCreateArrayBuffer(byte_length, data);
                value = emnapiCtx.addToCurrentScope(arrayBuffer).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipdp
         */
        function napi_create_date(env, time, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = emnapiCtx.addToCurrentScope(new Date(time)).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ippppp
         */
        function napi_create_external(env, data, finalize_cb, finalize_hint, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!emnapiCtx.feature.supportFinalizer && finalize_cb) {
                    throw emnapiCtx.createNotSupportWeakRefError('napi_create_external', 'Parameter "finalize_cb" must be 0(NULL)');
                }
                var externalHandle = emnapiCtx.getCurrentScope().addExternal(data);
                if (finalize_cb) {
                    emnapiCtx.createReferenceWithFinalizer(envObject, externalHandle.id, 0, 0 /* ReferenceOwnership.kRuntime */, finalize_cb, data, finalize_hint);
                }
                value = externalHandle.id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppppp
         */
        function napi_create_external_arraybuffer(env, external_data, byte_length, finalize_cb, finalize_hint, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                byte_length = byte_length >>> 0;
                if (!external_data) {
                    byte_length = 0;
                }
                if ((external_data + byte_length) > wasmMemory.buffer.byteLength) {
                    throw new RangeError('Memory out of range');
                }
                if (!emnapiCtx.feature.supportFinalizer && finalize_cb) {
                    throw emnapiCtx.createNotSupportWeakRefError('napi_create_external_arraybuffer', 'Parameter "finalize_cb" must be 0(NULL)');
                }
                var arrayBuffer = new ArrayBuffer(byte_length);
                if (byte_length === 0) {
                    try {
                        var MessageChannel_1 = emnapiCtx.feature.MessageChannel;
                        var messageChannel = new MessageChannel_1();
                        messageChannel.port1.postMessage(arrayBuffer, [arrayBuffer]);
                    }
                    catch (_) { }
                }
                else {
                    var u8arr = new Uint8Array(arrayBuffer);
                    u8arr.set(new Uint8Array(wasmMemory.buffer).subarray(external_data, external_data + byte_length));
                    emnapiExternalMemory.table.set(arrayBuffer, {
                        address: external_data,
                        ownership: 1 /* ReferenceOwnership.kUserland */,
                        runtimeAllocated: 0
                    });
                }
                var handle = emnapiCtx.addToCurrentScope(arrayBuffer);
                if (finalize_cb) {
                    var status_1 = napi_add_finalizer(env, handle.id, external_data, finalize_cb, finalize_hint, /* NULL */ 0);
                    if (status_1 === 10 /* napi_status.napi_pending_exception */) {
                        var err = envObject.tryCatch.extractException();
                        envObject.clearLastError();
                        throw err;
                    }
                    else if (status_1 !== 0 /* napi_status.napi_ok */) {
                        return envObject.setLastError(status_1);
                    }
                }
                value = handle.id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipp
         */
        function napi_create_object(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope({}).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_create_symbol(env, description, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (!description) {
                // eslint-disable-next-line symbol-description, @typescript-eslint/no-unused-vars
                var value = emnapiCtx.addToCurrentScope(Symbol()).id;
                HEAP_DATA_VIEW.setInt32(result, value, true);
            }
            else {
                var handle = emnapiCtx.handleStore.get(description);
                var desc = handle.value;
                if (typeof desc !== 'string') {
                    return envObject.setLastError(3 /* napi_status.napi_string_expected */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var v = emnapiCtx.addToCurrentScope(Symbol(desc)).id;
                HEAP_DATA_VIEW.setInt32(result, v, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ipipppp
         */
        function napi_create_typedarray(env, type, length, arraybuffer, byte_offset, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!arraybuffer)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(arraybuffer);
                if (!handle.isArrayBuffer()) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var buffer = handle.value;
                var createTypedArray = function (envObject, Type, size_of_element, buffer, byte_offset, length) {
                    var _a;
                    byte_offset = byte_offset >>> 0;
                    length = length >>> 0;
                    if (size_of_element > 1) {
                        if ((byte_offset) % (size_of_element) !== 0) {
                            var err = new RangeError("start offset of ".concat((_a = Type.name) !== null && _a !== void 0 ? _a : '', " should be a multiple of ").concat(size_of_element));
                            err.code = 'ERR_NAPI_INVALID_TYPEDARRAY_ALIGNMENT';
                            envObject.tryCatch.setError(err);
                            return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                        }
                    }
                    if (((length * size_of_element) + byte_offset) > buffer.byteLength) {
                        var err = new RangeError('Invalid typed array length');
                        err.code = 'ERR_NAPI_INVALID_TYPEDARRAY_LENGTH';
                        envObject.tryCatch.setError(err);
                        return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                    }
                    var out = new Type(buffer, byte_offset, length);
                    if (buffer === wasmMemory.buffer) {
                        if (!emnapiExternalMemory.wasmMemoryViewTable.has(out)) {
                            emnapiExternalMemory.wasmMemoryViewTable.set(out, {
                                Ctor: Type,
                                address: byte_offset,
                                length: length,
                                ownership: 1 /* ReferenceOwnership.kUserland */,
                                runtimeAllocated: 0
                            });
                        }
                    }
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    value = emnapiCtx.addToCurrentScope(out).id;
                    var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                    HEAP_DATA_VIEW.setInt32(result, value, true);
                    return envObject.getReturnStatus();
                };
                switch (type) {
                    case 0 /* napi_typedarray_type.napi_int8_array */:
                        return createTypedArray(envObject, Int8Array, 1, buffer, byte_offset, length);
                    case 1 /* napi_typedarray_type.napi_uint8_array */:
                        return createTypedArray(envObject, Uint8Array, 1, buffer, byte_offset, length);
                    case 2 /* napi_typedarray_type.napi_uint8_clamped_array */:
                        return createTypedArray(envObject, Uint8ClampedArray, 1, buffer, byte_offset, length);
                    case 3 /* napi_typedarray_type.napi_int16_array */:
                        return createTypedArray(envObject, Int16Array, 2, buffer, byte_offset, length);
                    case 4 /* napi_typedarray_type.napi_uint16_array */:
                        return createTypedArray(envObject, Uint16Array, 2, buffer, byte_offset, length);
                    case 5 /* napi_typedarray_type.napi_int32_array */:
                        return createTypedArray(envObject, Int32Array, 4, buffer, byte_offset, length);
                    case 6 /* napi_typedarray_type.napi_uint32_array */:
                        return createTypedArray(envObject, Uint32Array, 4, buffer, byte_offset, length);
                    case 7 /* napi_typedarray_type.napi_float32_array */:
                        return createTypedArray(envObject, Float32Array, 4, buffer, byte_offset, length);
                    case 8 /* napi_typedarray_type.napi_float64_array */:
                        return createTypedArray(envObject, Float64Array, 8, buffer, byte_offset, length);
                    case 9 /* napi_typedarray_type.napi_bigint64_array */:
                        return createTypedArray(envObject, BigInt64Array, 8, buffer, byte_offset, length);
                    case 10 /* napi_typedarray_type.napi_biguint64_array */:
                        return createTypedArray(envObject, BigUint64Array, 8, buffer, byte_offset, length);
                    default:
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__deps malloc
         * @__sig ippp
         */
        function napi_create_buffer(env, size, data, result) {
            var _a;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value, pointer;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var Buffer = emnapiCtx.feature.Buffer;
                if (!Buffer) {
                    throw emnapiCtx.createNotSupportBufferError('napi_create_buffer', '');
                }
                var buffer = void 0;
                size = size >>> 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                if (!data || (size === 0)) {
                    buffer = Buffer.alloc(size);
                    value = emnapiCtx.addToCurrentScope(buffer).id;
                    HEAP_DATA_VIEW.setInt32(result, value, true);
                }
                else {
                    pointer = _malloc(size);
                    if (!pointer)
                        throw new Error('Out of memory');
                    new Uint8Array(wasmMemory.buffer).subarray(pointer, pointer + size).fill(0);
                    var buffer_1 = Buffer.from(wasmMemory.buffer, pointer, size);
                    var viewDescriptor = {
                        Ctor: Buffer,
                        address: pointer,
                        length: size,
                        ownership: emnapiExternalMemory.registry ? 0 /* ReferenceOwnership.kRuntime */ : 1 /* ReferenceOwnership.kUserland */,
                        runtimeAllocated: 1
                    };
                    emnapiExternalMemory.wasmMemoryViewTable.set(buffer_1, viewDescriptor);
                    (_a = emnapiExternalMemory.registry) === null || _a === void 0 ? void 0 : _a.register(viewDescriptor, pointer);
                    value = emnapiCtx.addToCurrentScope(buffer_1).id;
                    HEAP_DATA_VIEW.setInt32(result, value, true);
                    HEAP_DATA_VIEW.setInt32(data, pointer, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ippppp
         */
        function napi_create_buffer_copy(env, length, data, result_data, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var Buffer = emnapiCtx.feature.Buffer;
                if (!Buffer) {
                    throw emnapiCtx.createNotSupportBufferError('napi_create_buffer_copy', '');
                }
                var arrayBuffer = emnapiCreateArrayBuffer(length, result_data);
                var buffer = Buffer.from(arrayBuffer);
                buffer.set(new Uint8Array(wasmMemory.buffer).subarray(data, data + length));
                value = emnapiCtx.addToCurrentScope(buffer).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppppp
         */
        function napi_create_external_buffer(env, length, data, finalize_cb, finalize_hint, result) {
            return emnapi_create_memory_view(env, -2 /* emnapi_memory_view_type.emnapi_buffer */, data, length, finalize_cb, finalize_hint, result);
        }
        /**
         * @__sig ippppp
         */
        function node_api_create_buffer_from_arraybuffer(env, arraybuffer, byte_offset, byte_length, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!arraybuffer)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                byte_offset = byte_offset >>> 0;
                byte_length = byte_length >>> 0;
                var handle = emnapiCtx.handleStore.get(arraybuffer);
                if (!handle.isArrayBuffer()) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var buffer = handle.value;
                if ((byte_length + byte_offset) > buffer.byteLength) {
                    var err = new RangeError('The byte offset + length is out of range');
                    err.code = 'ERR_OUT_OF_RANGE';
                    throw err;
                }
                var Buffer = emnapiCtx.feature.Buffer;
                if (!Buffer) {
                    throw emnapiCtx.createNotSupportBufferError('node_api_create_buffer_from_arraybuffer', '');
                }
                var out = Buffer.from(buffer, byte_offset, byte_length);
                if (buffer === wasmMemory.buffer) {
                    if (!emnapiExternalMemory.wasmMemoryViewTable.has(out)) {
                        emnapiExternalMemory.wasmMemoryViewTable.set(out, {
                            Ctor: Buffer,
                            address: byte_offset,
                            length: byte_length,
                            ownership: 1 /* ReferenceOwnership.kUserland */,
                            runtimeAllocated: 0
                        });
                    }
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = emnapiCtx.addToCurrentScope(out).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ippppp
         */
        function napi_create_dataview(env, byte_length, arraybuffer, byte_offset, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!arraybuffer)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                byte_length = byte_length >>> 0;
                byte_offset = byte_offset >>> 0;
                var handle = emnapiCtx.handleStore.get(arraybuffer);
                if (!handle.isArrayBuffer()) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var buffer = handle.value;
                if ((byte_length + byte_offset) > buffer.byteLength) {
                    var err = new RangeError('byte_offset + byte_length should be less than or equal to the size in bytes of the array passed in');
                    err.code = 'ERR_NAPI_INVALID_DATAVIEW_ARGS';
                    throw err;
                }
                var dataview = new DataView(buffer, byte_offset, byte_length);
                if (buffer === wasmMemory.buffer) {
                    if (!emnapiExternalMemory.wasmMemoryViewTable.has(dataview)) {
                        emnapiExternalMemory.wasmMemoryViewTable.set(dataview, {
                            Ctor: DataView,
                            address: byte_offset,
                            length: byte_length,
                            ownership: 1 /* ReferenceOwnership.kUserland */,
                            runtimeAllocated: 0
                        });
                    }
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = emnapiCtx.addToCurrentScope(dataview).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppp
         */
        function node_api_symbol_for(env, utf8description, length, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var autoLength = length === -1;
            var sizelength = length >>> 0;
            if (length !== 0) {
                if (!utf8description)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            if (!(autoLength || (sizelength <= 2147483647))) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            var descriptionString = emnapiString.UTF8ToString(utf8description, length);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope(Symbol.for(descriptionString)).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        var createMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_create_array: napi_create_array,
            napi_create_array_with_length: napi_create_array_with_length,
            napi_create_arraybuffer: napi_create_arraybuffer,
            napi_create_buffer: napi_create_buffer,
            napi_create_buffer_copy: napi_create_buffer_copy,
            napi_create_dataview: napi_create_dataview,
            napi_create_date: napi_create_date,
            napi_create_external: napi_create_external,
            napi_create_external_arraybuffer: napi_create_external_arraybuffer,
            napi_create_external_buffer: napi_create_external_buffer,
            napi_create_object: napi_create_object,
            napi_create_symbol: napi_create_symbol,
            napi_create_typedarray: napi_create_typedarray,
            node_api_create_buffer_from_arraybuffer: node_api_create_buffer_from_arraybuffer,
            node_api_symbol_for: node_api_symbol_for
        });
        /** @__sig ipip */
        function napi_get_boolean(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v = value === 0 ? 3 /* GlobalHandle.FALSE */ : 4 /* GlobalHandle.TRUE */;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, v, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_get_global(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = 5 /* GlobalHandle.GLOBAL */;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_get_null(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = 2 /* GlobalHandle.NULL */;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_get_undefined(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = 1 /* GlobalHandle.UNDEFINED */;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        var globalMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_get_boolean: napi_get_boolean,
            napi_get_global: napi_get_global,
            napi_get_null: napi_get_null,
            napi_get_undefined: napi_get_undefined
        });
        /** @__sig ipppp */
        function napi_set_instance_data(env, data, finalize_cb, finalize_hint) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            envObject.setInstanceData(data, finalize_cb, finalize_hint);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_get_instance_data(env, data) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!data)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = envObject.getInstanceData();
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(data, value, true);
            return envObject.clearLastError();
        }
        var envMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_get_instance_data: napi_get_instance_data,
            napi_set_instance_data: napi_set_instance_data
        });
        /** @__sig vpppp */
        function _emnapi_get_last_error_info(env, error_code, engine_error_code, engine_reserved) {
            var envObject = emnapiCtx.envStore.get(env);
            var lastError = envObject.lastError;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var errorCode = lastError.errorCode;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var engineErrorCode = lastError.engineErrorCode >>> 0;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var engineReserved = lastError.engineReserved;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(error_code, errorCode, true);
            HEAP_DATA_VIEW.setUint32(engine_error_code, engineErrorCode, true);
            HEAP_DATA_VIEW.setInt32(engine_reserved, engineReserved, true);
        }
        /** @__sig ipp */
        function napi_throw(env, error) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!error)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                envObject.tryCatch.setError(emnapiCtx.handleStore.get(error).value);
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_throw_error(env, code, msg) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!msg)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var error = new Error(emnapiString.UTF8ToString(msg, -1));
                if (code)
                    error.code = emnapiString.UTF8ToString(code, -1);
                envObject.tryCatch.setError(error);
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_throw_type_error(env, code, msg) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!msg)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var error = new TypeError(emnapiString.UTF8ToString(msg, -1));
                if (code)
                    error.code = emnapiString.UTF8ToString(code, -1);
                envObject.tryCatch.setError(error);
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_throw_range_error(env, code, msg) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!msg)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var error = new RangeError(emnapiString.UTF8ToString(msg, -1));
                if (code)
                    error.code = emnapiString.UTF8ToString(code, -1);
                envObject.tryCatch.setError(error);
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function node_api_throw_syntax_error(env, code, msg) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!msg)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var error = new SyntaxError(emnapiString.UTF8ToString(msg, -1));
                if (code)
                    error.code = emnapiString.UTF8ToString(code, -1);
                envObject.tryCatch.setError(error);
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipp */
        function napi_is_exception_pending(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = envObject.tryCatch.hasCaught();
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r ? 1 : 0, true);
            return envObject.clearLastError();
        }
        /** @__sig ipppp */
        function napi_create_error(env, code, msg, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!msg)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var msgValue = emnapiCtx.handleStore.get(msg).value;
            if (typeof msgValue !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var error = new Error(msgValue);
            if (code) {
                var codeValue = emnapiCtx.handleStore.get(code).value;
                if (typeof codeValue !== 'string') {
                    return envObject.setLastError(3 /* napi_status.napi_string_expected */);
                }
                error.code = codeValue;
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope(error).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /** @__sig ipppp */
        function napi_create_type_error(env, code, msg, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!msg)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var msgValue = emnapiCtx.handleStore.get(msg).value;
            if (typeof msgValue !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var error = new TypeError(msgValue);
            if (code) {
                var codeValue = emnapiCtx.handleStore.get(code).value;
                if (typeof codeValue !== 'string') {
                    return envObject.setLastError(3 /* napi_status.napi_string_expected */);
                }
                error.code = codeValue;
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope(error).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /** @__sig ipppp */
        function napi_create_range_error(env, code, msg, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!msg)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var msgValue = emnapiCtx.handleStore.get(msg).value;
            if (typeof msgValue !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var error = new RangeError(msgValue);
            if (code) {
                var codeValue = emnapiCtx.handleStore.get(code).value;
                if (typeof codeValue !== 'string') {
                    return envObject.setLastError(3 /* napi_status.napi_string_expected */);
                }
                error.code = codeValue;
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope(error).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /** @__sig ipppp */
        function node_api_create_syntax_error(env, code, msg, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!msg)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var msgValue = emnapiCtx.handleStore.get(msg).value;
            if (typeof msgValue !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var error = new SyntaxError(msgValue);
            if (code) {
                var codeValue = emnapiCtx.handleStore.get(code).value;
                if (typeof codeValue !== 'string') {
                    return envObject.setLastError(3 /* napi_status.napi_string_expected */);
                }
                error.code = codeValue;
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope(error).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_get_and_clear_last_exception(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (!envObject.tryCatch.hasCaught()) {
                HEAP_DATA_VIEW.setInt32(result, 1, true); // ID_UNDEFINED
                return envObject.clearLastError();
            }
            else {
                var err = envObject.tryCatch.exception();
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var value = envObject.ensureHandleId(err);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                envObject.tryCatch.reset();
            }
            return envObject.clearLastError();
        }
        /** @__sig vpppp */
        function napi_fatal_error(location, location_len, message, message_len) {
            var locationStr = emnapiString.UTF8ToString(location, location_len);
            var messageStr = emnapiString.UTF8ToString(message, message_len);
            if (emnapiNodeBinding) {
                emnapiNodeBinding.napi.fatalError(locationStr, messageStr);
            }
            else {
                abort('FATAL ERROR: ' + locationStr + ' ' + messageStr);
            }
        }
        /** @__sig ipp */
        function napi_fatal_exception(env, err) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!err)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var error = envObject.ctx.handleStore.get(err);
                try {
                    envObject.triggerFatalException(error.value);
                }
                catch (_) {
                    return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                }
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        var errorMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            _emnapi_get_last_error_info: _emnapi_get_last_error_info,
            napi_create_error: napi_create_error,
            napi_create_range_error: napi_create_range_error,
            napi_create_type_error: napi_create_type_error,
            napi_fatal_error: napi_fatal_error,
            napi_fatal_exception: napi_fatal_exception,
            napi_get_and_clear_last_exception: napi_get_and_clear_last_exception,
            napi_is_exception_pending: napi_is_exception_pending,
            napi_throw: napi_throw,
            napi_throw_error: napi_throw_error,
            napi_throw_range_error: napi_throw_range_error,
            napi_throw_type_error: napi_throw_type_error,
            node_api_create_syntax_error: node_api_create_syntax_error,
            node_api_throw_syntax_error: node_api_throw_syntax_error
        });
        /** @__sig ipppppp */
        function napi_create_function(env, utf8name, length, cb, data, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!cb)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var fresult = emnapiCreateFunction(envObject, utf8name, length, cb, data);
                if (fresult.status !== 0 /* napi_status.napi_ok */)
                    return envObject.setLastError(fresult.status);
                var f = fresult.f;
                var valueHandle = emnapiCtx.addToCurrentScope(f);
                value = valueHandle.id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppppp */
        function napi_get_cb_info(env, cbinfo, argc, argv, this_arg, data) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!cbinfo)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var cbinfoValue = emnapiCtx.scopeStore.get(cbinfo).callbackInfo;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (argv) {
                if (!argc)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var argcValue = HEAP_DATA_VIEW.getUint32(argc, true);
                var len = cbinfoValue.args.length;
                var arrlen = argcValue < len ? argcValue : len;
                var i = 0;
                for (; i < arrlen; i++) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var argVal = envObject.ensureHandleId(cbinfoValue.args[i]);
                    HEAP_DATA_VIEW.setInt32(argv + i * 4, argVal, true);
                }
                if (i < argcValue) {
                    for (; i < argcValue; i++) {
                        HEAP_DATA_VIEW.setInt32(argv + i * 4, 1, true);
                    }
                }
            }
            if (argc) {
                HEAP_DATA_VIEW.setUint32(argc, cbinfoValue.args.length, true);
            }
            if (this_arg) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var v = envObject.ensureHandleId(cbinfoValue.thiz);
                HEAP_DATA_VIEW.setInt32(this_arg, v, true);
            }
            if (data) {
                HEAP_DATA_VIEW.setInt32(data, cbinfoValue.data, true);
            }
            return envObject.clearLastError();
        }
        /** @__sig ipppppp */
        function napi_call_function(env, recv, func, argc, argv, result) {
            var i = 0;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!recv)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                argc = argc >>> 0;
                if (argc > 0) {
                    if (!argv)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var v8recv = emnapiCtx.handleStore.get(recv).value;
                if (!func)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var v8func = emnapiCtx.handleStore.get(func).value;
                if (typeof v8func !== 'function')
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var args = [];
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                for (; i < argc; i++) {
                    var argVal = HEAP_DATA_VIEW.getInt32(argv + i * 4, true);
                    args.push(emnapiCtx.handleStore.get(argVal).value);
                }
                var ret = v8func.apply(v8recv, args);
                if (result) {
                    v = envObject.ensureHandleId(ret);
                    HEAP_DATA_VIEW.setInt32(result, v, true);
                }
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippppp */
        function napi_new_instance(env, constructor, argc, argv, result) {
            var i;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!constructor)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                argc = argc >>> 0;
                if (argc > 0) {
                    if (!argv)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var Ctor = emnapiCtx.handleStore.get(constructor).value;
                if (typeof Ctor !== 'function')
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var ret = void 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                if (emnapiCtx.feature.supportReflect) {
                    var argList = Array(argc);
                    for (i = 0; i < argc; i++) {
                        var argVal = HEAP_DATA_VIEW.getInt32(argv + i * 4, true);
                        argList[i] = emnapiCtx.handleStore.get(argVal).value;
                    }
                    ret = Reflect.construct(Ctor, argList, Ctor);
                }
                else {
                    var args = Array(argc + 1);
                    args[0] = undefined;
                    for (i = 0; i < argc; i++) {
                        var argVal = HEAP_DATA_VIEW.getInt32(argv + i * 4, true);
                        args[i + 1] = emnapiCtx.handleStore.get(argVal).value;
                    }
                    var BoundCtor = Ctor.bind.apply(Ctor, args);
                    ret = new BoundCtor();
                }
                if (result) {
                    v = envObject.ensureHandleId(ret);
                    HEAP_DATA_VIEW.setInt32(result, v, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_get_new_target(env, cbinfo, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!cbinfo)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var cbinfoValue = emnapiCtx.scopeStore.get(cbinfo).callbackInfo;
            var thiz = cbinfoValue.thiz, fn = cbinfoValue.fn;
            var value = thiz == null || thiz.constructor == null
                ? 0
                : thiz instanceof fn
                    ? envObject.ensureHandleId(thiz.constructor)
                    : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        var functionMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_call_function: napi_call_function,
            napi_create_function: napi_create_function,
            napi_get_cb_info: napi_get_cb_info,
            napi_get_new_target: napi_get_new_target,
            napi_new_instance: napi_new_instance
        });
        /** @__sig ipp */
        function napi_open_handle_scope(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var scope = emnapiCtx.openScope(envObject);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, scope.id, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_close_handle_scope(env, scope) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!scope)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if ((envObject.openHandleScopes === 0)) {
                return 13 /* napi_status.napi_handle_scope_mismatch */;
            }
            emnapiCtx.closeScope(envObject);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_open_escapable_handle_scope(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var scope = emnapiCtx.openScope(envObject);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, scope.id, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_close_escapable_handle_scope(env, scope) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!scope)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if ((envObject.openHandleScopes === 0)) {
                return 13 /* napi_status.napi_handle_scope_mismatch */;
            }
            emnapiCtx.closeScope(envObject);
            return envObject.clearLastError();
        }
        /** @__sig ipppp */
        function napi_escape_handle(env, scope, escapee, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!scope)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!escapee)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var scopeObject = emnapiCtx.scopeStore.get(scope);
            if (!scopeObject.escapeCalled()) {
                var newHandle = scopeObject.escape(escapee);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var value = newHandle ? newHandle.id : 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.clearLastError();
            }
            return envObject.setLastError(12 /* napi_status.napi_escape_called_twice */);
        }
        /** @__sig ippip */
        function napi_create_reference(env, value, initial_refcount, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (envObject.moduleApiVersion < 10) {
                if (!(handle.isObject() || handle.isFunction() || handle.isSymbol())) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var ref = emnapiCtx.createReference(envObject, handle.id, initial_refcount >>> 0, 1 /* ReferenceOwnership.kUserland */);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, ref.id, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_delete_reference(env, ref) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!ref)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            emnapiCtx.refStore.get(ref).dispose();
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_reference_ref(env, ref, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!ref)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var count = emnapiCtx.refStore.get(ref).ref();
            if (result) {
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setUint32(result, count, true);
            }
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_reference_unref(env, ref, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!ref)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var reference = emnapiCtx.refStore.get(ref);
            var refcount = reference.refcount();
            if (refcount === 0) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var count = reference.unref();
            if (result) {
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setUint32(result, count, true);
            }
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_get_reference_value(env, ref, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!ref)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var reference = emnapiCtx.refStore.get(ref);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var handleId = reference.get(envObject);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, handleId, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_add_env_cleanup_hook(env, fun, arg) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!fun)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            emnapiCtx.addCleanupHook(envObject, fun, arg);
            return 0 /* napi_status.napi_ok */;
        }
        /** @__sig ippp */
        function napi_remove_env_cleanup_hook(env, fun, arg) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!fun)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            emnapiCtx.removeCleanupHook(envObject, fun, arg);
            return 0 /* napi_status.napi_ok */;
        }
        /** @__sig vp */
        function _emnapi_env_ref(env) {
            var envObject = emnapiCtx.envStore.get(env);
            envObject.ref();
        }
        /** @__sig vp */
        function _emnapi_env_unref(env) {
            var envObject = emnapiCtx.envStore.get(env);
            envObject.unref();
        }
        var lifeMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            _emnapi_env_ref: _emnapi_env_ref,
            _emnapi_env_unref: _emnapi_env_unref,
            napi_add_env_cleanup_hook: napi_add_env_cleanup_hook,
            napi_close_escapable_handle_scope: napi_close_escapable_handle_scope,
            napi_close_handle_scope: napi_close_handle_scope,
            napi_create_reference: napi_create_reference,
            napi_delete_reference: napi_delete_reference,
            napi_escape_handle: napi_escape_handle,
            napi_get_reference_value: napi_get_reference_value,
            napi_open_escapable_handle_scope: napi_open_escapable_handle_scope,
            napi_open_handle_scope: napi_open_handle_scope,
            napi_reference_ref: napi_reference_ref,
            napi_reference_unref: napi_reference_unref,
            napi_remove_env_cleanup_hook: napi_remove_env_cleanup_hook
        });
        /** @__sig ippi */
        function _emnapi_get_filename(env, buf, len) {
            var envObject = emnapiCtx.envStore.get(env);
            var filename = envObject.filename;
            if (!buf) {
                return emnapiString.lengthBytesUTF8(filename);
            }
            return emnapiString.stringToUTF8(filename, buf, len);
        }
        var miscellaneousMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            _emnapi_get_filename: _emnapi_get_filename
        });
        /** @__sig ippp */
        function napi_create_promise(env, deferred, promise) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var deferredObjectId, value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!deferred)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!promise)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                var p = new Promise(function (resolve, reject) {
                    var deferredObject = emnapiCtx.createDeferred({ resolve: resolve, reject: reject });
                    deferredObjectId = deferredObject.id;
                    HEAP_DATA_VIEW.setInt32(deferred, deferredObjectId, true);
                });
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = emnapiCtx.addToCurrentScope(p).id;
                HEAP_DATA_VIEW.setInt32(promise, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_resolve_deferred(env, deferred, resolution) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!deferred)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!resolution)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var deferredObject = emnapiCtx.deferredStore.get(deferred);
                deferredObject.resolve(emnapiCtx.handleStore.get(resolution).value);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_reject_deferred(env, deferred, resolution) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!deferred)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!resolution)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var deferredObject = emnapiCtx.deferredStore.get(deferred);
                deferredObject.reject(emnapiCtx.handleStore.get(resolution).value);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_is_promise(env, value, is_promise) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!is_promise)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isPromise() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(is_promise, r, true);
            return envObject.clearLastError();
        }
        var promiseMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_create_promise: napi_create_promise,
            napi_is_promise: napi_is_promise,
            napi_reject_deferred: napi_reject_deferred,
            napi_resolve_deferred: napi_resolve_deferred
        });
        /** @__sig ippiiip */
        function napi_get_all_property_names(env, object, key_mode, key_filter, key_conversion, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var obj = void 0;
                try {
                    obj = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                if (key_mode !== 0 /* napi_key_collection_mode.napi_key_include_prototypes */ && key_mode !== 1 /* napi_key_collection_mode.napi_key_own_only */) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if (key_conversion !== 0 /* napi_key_conversion.napi_key_keep_numbers */ && key_conversion !== 1 /* napi_key_conversion.napi_key_numbers_to_strings */) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var props = [];
                var names = void 0;
                var symbols = void 0;
                var i = void 0;
                var own = true;
                var integerIndiceRegex = /^(0|[1-9][0-9]*)$/;
                do {
                    names = Object.getOwnPropertyNames(obj);
                    symbols = Object.getOwnPropertySymbols(obj);
                    for (i = 0; i < names.length; i++) {
                        props.push({
                            name: integerIndiceRegex.test(names[i]) ? Number(names[i]) : names[i],
                            desc: Object.getOwnPropertyDescriptor(obj, names[i]),
                            own: own
                        });
                    }
                    for (i = 0; i < symbols.length; i++) {
                        props.push({
                            name: symbols[i],
                            desc: Object.getOwnPropertyDescriptor(obj, symbols[i]),
                            own: own
                        });
                    }
                    if (key_mode === 1 /* napi_key_collection_mode.napi_key_own_only */) {
                        break;
                    }
                    obj = Object.getPrototypeOf(obj);
                    own = false;
                } while (obj);
                var ret = [];
                var addName = function (ret, name, key_filter, conversion_mode) {
                    if (ret.indexOf(name) !== -1)
                        return;
                    if (conversion_mode === 0 /* napi_key_conversion.napi_key_keep_numbers */) {
                        ret.push(name);
                    }
                    else if (conversion_mode === 1 /* napi_key_conversion.napi_key_numbers_to_strings */) {
                        var realName = typeof name === 'number' ? String(name) : name;
                        if (typeof realName === 'string') {
                            if (!(key_filter & 8 /* napi_key_filter.napi_key_skip_strings */)) {
                                ret.push(realName);
                            }
                        }
                        else {
                            ret.push(realName);
                        }
                    }
                };
                for (i = 0; i < props.length; i++) {
                    var prop = props[i];
                    var name_1 = prop.name;
                    var desc = prop.desc;
                    if (key_filter === 0 /* napi_key_filter.napi_key_all_properties */) {
                        addName(ret, name_1, key_filter, key_conversion);
                    }
                    else {
                        if (key_filter & 8 /* napi_key_filter.napi_key_skip_strings */ && typeof name_1 === 'string') {
                            continue;
                        }
                        if (key_filter & 16 /* napi_key_filter.napi_key_skip_symbols */ && typeof name_1 === 'symbol') {
                            continue;
                        }
                        var shouldAdd = true;
                        switch (key_filter & 7) {
                            case 1 /* napi_key_filter.napi_key_writable */: {
                                shouldAdd = Boolean(desc.writable);
                                break;
                            }
                            case 2 /* napi_key_filter.napi_key_enumerable */: {
                                shouldAdd = Boolean(desc.enumerable);
                                break;
                            }
                            case (1 /* napi_key_filter.napi_key_writable */ | 2 /* napi_key_filter.napi_key_enumerable */): {
                                shouldAdd = Boolean(desc.writable && desc.enumerable);
                                break;
                            }
                            case 4 /* napi_key_filter.napi_key_configurable */: {
                                shouldAdd = Boolean(desc.configurable);
                                break;
                            }
                            case (4 /* napi_key_filter.napi_key_configurable */ | 1 /* napi_key_filter.napi_key_writable */): {
                                shouldAdd = Boolean(desc.configurable && desc.writable);
                                break;
                            }
                            case (4 /* napi_key_filter.napi_key_configurable */ | 2 /* napi_key_filter.napi_key_enumerable */): {
                                shouldAdd = Boolean(desc.configurable && desc.enumerable);
                                break;
                            }
                            case (4 /* napi_key_filter.napi_key_configurable */ | 2 /* napi_key_filter.napi_key_enumerable */ | 1 /* napi_key_filter.napi_key_writable */): {
                                shouldAdd = Boolean(desc.configurable && desc.enumerable && desc.writable);
                                break;
                            }
                        }
                        if (shouldAdd) {
                            addName(ret, name_1, key_filter, key_conversion);
                        }
                    }
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = emnapiCtx.addToCurrentScope(ret).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_get_property_names(env, object, result) {
            return napi_get_all_property_names(env, object, 0 /* napi_key_collection_mode.napi_key_include_prototypes */, 2 /* napi_key_filter.napi_key_enumerable */ | 16 /* napi_key_filter.napi_key_skip_symbols */, 1 /* napi_key_conversion.napi_key_numbers_to_strings */, result);
        }
        /** @__sig ipppp */
        function napi_set_property(env, object, key, value) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!key)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                h.value[emnapiCtx.handleStore.get(key).value] = emnapiCtx.handleStore.get(value).value;
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_has_property(env, object, key, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!key)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                r = (emnapiCtx.handleStore.get(key).value in v) ? 1 : 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, r, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_get_property(env, object, key, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!key)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = envObject.ensureHandleId(v[emnapiCtx.handleStore.get(key).value]);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_delete_property(env, object, key, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!key)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                var propertyKey = emnapiCtx.handleStore.get(key).value;
                if (emnapiCtx.feature.supportReflect) {
                    r = Reflect.deleteProperty(h.value, propertyKey);
                }
                else {
                    try {
                        r = delete h.value[propertyKey];
                    }
                    catch (_) {
                        r = false;
                    }
                }
                if (result) {
                    var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                    HEAP_DATA_VIEW.setInt8(result, r ? 1 : 0, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_has_own_property(env, object, key, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!key)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                var prop = emnapiCtx.handleStore.get(key).value;
                if (typeof prop !== 'string' && typeof prop !== 'symbol') {
                    return envObject.setLastError(4 /* napi_status.napi_name_expected */);
                }
                r = Object.prototype.hasOwnProperty.call(v, emnapiCtx.handleStore.get(key).value);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, r ? 1 : 0, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_set_named_property(env, object, cname, value) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                if (!cname) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                emnapiCtx.handleStore.get(object).value[emnapiString.UTF8ToString(cname, -1)] = emnapiCtx.handleStore.get(value).value;
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_has_named_property(env, object, utf8name, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!utf8name) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                r = emnapiString.UTF8ToString(utf8name, -1) in v;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, r ? 1 : 0, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_get_named_property(env, object, utf8name, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!utf8name) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = envObject.ensureHandleId(v[emnapiString.UTF8ToString(utf8name, -1)]);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippip */
        function napi_set_element(env, object, index, value) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                h.value[index >>> 0] = emnapiCtx.handleStore.get(value).value;
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippip */
        function napi_has_element(env, object, index, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                r = ((index >>> 0) in v) ? 1 : 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, r, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippip */
        function napi_get_element(env, object, index, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = envObject.ensureHandleId(v[index >>> 0]);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippip */
        function napi_delete_element(env, object, index, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                if (emnapiCtx.feature.supportReflect) {
                    r = Reflect.deleteProperty(h.value, index >>> 0);
                }
                else {
                    try {
                        r = delete h.value[index >>> 0];
                    }
                    catch (_) {
                        r = false;
                    }
                }
                if (result) {
                    var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                    HEAP_DATA_VIEW.setInt8(result, r ? 1 : 0, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_define_properties(env, object, property_count, properties) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var propPtr, attributes;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                property_count = property_count >>> 0;
                if (property_count > 0) {
                    if (!properties)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                var maybeObject = h.value;
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                var propertyName = void 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                for (var i = 0; i < property_count; i++) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    propPtr = properties + (i * (4 * 8));
                    var utf8Name = HEAP_DATA_VIEW.getInt32(propPtr, true);
                    var name_2 = HEAP_DATA_VIEW.getInt32(propPtr + 4, true);
                    var method = HEAP_DATA_VIEW.getInt32(propPtr + 8, true);
                    var getter = HEAP_DATA_VIEW.getInt32(propPtr + 12, true);
                    var setter = HEAP_DATA_VIEW.getInt32(propPtr + 16, true);
                    var value = HEAP_DATA_VIEW.getInt32(propPtr + 20, true);
                    attributes = HEAP_DATA_VIEW.getInt32(propPtr + 24, true);
                    var data = HEAP_DATA_VIEW.getInt32(propPtr + 28, true);
                    if (utf8Name) {
                        propertyName = emnapiString.UTF8ToString(utf8Name, -1);
                    }
                    else {
                        if (!name_2) {
                            return envObject.setLastError(4 /* napi_status.napi_name_expected */);
                        }
                        propertyName = emnapiCtx.handleStore.get(name_2).value;
                        if (typeof propertyName !== 'string' && typeof propertyName !== 'symbol') {
                            return envObject.setLastError(4 /* napi_status.napi_name_expected */);
                        }
                    }
                    emnapiDefineProperty(envObject, maybeObject, propertyName, method, getter, setter, value, attributes, data);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipp */
        function napi_object_freeze(env, object) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                var maybeObject = h.value;
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                Object.freeze(maybeObject);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipp */
        function napi_object_seal(env, object) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                var maybeObject = h.value;
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                Object.seal(maybeObject);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        var propertyMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_define_properties: napi_define_properties,
            napi_delete_element: napi_delete_element,
            napi_delete_property: napi_delete_property,
            napi_get_all_property_names: napi_get_all_property_names,
            napi_get_element: napi_get_element,
            napi_get_named_property: napi_get_named_property,
            napi_get_property: napi_get_property,
            napi_get_property_names: napi_get_property_names,
            napi_has_element: napi_has_element,
            napi_has_named_property: napi_has_named_property,
            napi_has_own_property: napi_has_own_property,
            napi_has_property: napi_has_property,
            napi_object_freeze: napi_object_freeze,
            napi_object_seal: napi_object_seal,
            napi_set_element: napi_set_element,
            napi_set_named_property: napi_set_named_property,
            napi_set_property: napi_set_property
        });
        /** @__sig ippp */
        function napi_run_script(env, script, result) {
            var status;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!script)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var v8Script = emnapiCtx.handleStore.get(script);
                if (!v8Script.isString()) {
                    return envObject.setLastError(3 /* napi_status.napi_string_expected */);
                }
                var g = emnapiCtx.handleStore.get(5 /* GlobalHandle.GLOBAL */).value;
                var ret = g.eval(v8Script.value);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = envObject.ensureHandleId(ret);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                status = envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
            return status;
        }
        var scriptMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_run_script: napi_run_script
        });
        /** @__sig ippp */
        function napi_typeof(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var v = emnapiCtx.handleStore.get(value);
            var r;
            if (v.isNumber()) {
                r = 3 /* napi_valuetype.napi_number */;
            }
            else if (v.isBigInt()) {
                r = 9 /* napi_valuetype.napi_bigint */;
            }
            else if (v.isString()) {
                r = 4 /* napi_valuetype.napi_string */;
            }
            else if (v.isFunction()) {
                // This test has to come before IsObject because IsFunction
                // implies IsObject
                r = 7 /* napi_valuetype.napi_function */;
            }
            else if (v.isExternal()) {
                // This test has to come before IsObject because IsExternal
                // implies IsObject
                r = 8 /* napi_valuetype.napi_external */;
            }
            else if (v.isObject()) {
                r = 6 /* napi_valuetype.napi_object */;
            }
            else if (v.isBoolean()) {
                r = 2 /* napi_valuetype.napi_boolean */;
            }
            else if (v.isUndefined()) {
                r = 0 /* napi_valuetype.napi_undefined */;
            }
            else if (v.isSymbol()) {
                r = 5 /* napi_valuetype.napi_symbol */;
            }
            else if (v.isNull()) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                r = 1 /* napi_valuetype.napi_null */;
            }
            else {
                // Should not get here unless V8 has added some new kind of value.
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_coerce_to_bool(env, value, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                v = handle.value ? 4 /* GlobalHandle.TRUE */ : 3 /* GlobalHandle.FALSE */;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_coerce_to_number(env, value, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                if (handle.isBigInt()) {
                    throw new TypeError('Cannot convert a BigInt value to a number');
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                v = emnapiCtx.addToCurrentScope(Number(handle.value)).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_coerce_to_object(env, value, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                if (handle.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                v = envObject.ensureHandleId(Object(handle.value));
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_coerce_to_string(env, value, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                if (handle.isSymbol()) {
                    throw new TypeError('Cannot convert a Symbol value to a string');
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                v = emnapiCtx.addToCurrentScope(String(handle.value)).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_instanceof(env, object, constructor, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!constructor)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, 0, true);
                var ctor = emnapiCtx.handleStore.get(constructor);
                if (!ctor.isFunction()) {
                    return envObject.setLastError(5 /* napi_status.napi_function_expected */);
                }
                var val = emnapiCtx.handleStore.get(object).value;
                var ret = val instanceof ctor.value;
                r = ret ? 1 : 0;
                HEAP_DATA_VIEW.setInt8(result, r, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_is_array(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isArray() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_arraybuffer(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isArrayBuffer() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_date(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isDate() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_error(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var val = emnapiCtx.handleStore.get(value).value;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = (val instanceof Error) ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_typedarray(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isTypedArray() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_buffer(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isBuffer(emnapiCtx.feature.Buffer) ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_dataview(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isDataView() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ipppp */
        function napi_strict_equals(env, lhs, rhs, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!lhs)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!rhs)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var lv = emnapiCtx.handleStore.get(lhs).value;
                var rv = emnapiCtx.handleStore.get(rhs).value;
                r = (lv === rv) ? 1 : 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, r, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipp */
        function napi_detach_arraybuffer(env, arraybuffer) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!arraybuffer)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var value = emnapiCtx.handleStore.get(arraybuffer).value;
            if (!(value instanceof ArrayBuffer)) {
                if (typeof SharedArrayBuffer === 'function' && (value instanceof SharedArrayBuffer)) {
                    return envObject.setLastError(20 /* napi_status.napi_detachable_arraybuffer_expected */);
                }
                return envObject.setLastError(19 /* napi_status.napi_arraybuffer_expected */);
            }
            try {
                var MessageChannel_1 = emnapiCtx.feature.MessageChannel;
                var messageChannel = new MessageChannel_1();
                messageChannel.port1.postMessage(value, [value]);
            }
            catch (_) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_detached_arraybuffer(env, arraybuffer, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!arraybuffer)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(arraybuffer);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                if (h.isArrayBuffer() && h.value.byteLength === 0) {
                    try {
                        // eslint-disable-next-line no-new
                        new Uint8Array(h.value);
                    }
                    catch (_) {
                        HEAP_DATA_VIEW.setInt8(result, 1, true);
                        return envObject.getReturnStatus();
                    }
                }
                HEAP_DATA_VIEW.setInt8(result, 0, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        var valueOperationMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_coerce_to_bool: napi_coerce_to_bool,
            napi_coerce_to_number: napi_coerce_to_number,
            napi_coerce_to_object: napi_coerce_to_object,
            napi_coerce_to_string: napi_coerce_to_string,
            napi_detach_arraybuffer: napi_detach_arraybuffer,
            napi_instanceof: napi_instanceof,
            napi_is_array: napi_is_array,
            napi_is_arraybuffer: napi_is_arraybuffer,
            napi_is_buffer: napi_is_buffer,
            napi_is_dataview: napi_is_dataview,
            napi_is_date: napi_is_date,
            napi_is_detached_arraybuffer: napi_is_detached_arraybuffer,
            napi_is_error: napi_is_error,
            napi_is_typedarray: napi_is_typedarray,
            napi_strict_equals: napi_strict_equals,
            napi_typeof: napi_typeof
        });
        /** @__sig ipp */
        function napi_get_version(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var NODE_API_SUPPORTED_VERSION_MAX = 10 /* Version.NODE_API_SUPPORTED_VERSION_MAX */;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setUint32(result, NODE_API_SUPPORTED_VERSION_MAX, true);
            return envObject.clearLastError();
        }
        var versionMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_get_version: napi_get_version
        });
        emnapiAWST.init();
        emnapiExternalMemory.init();
        emnapiString.init();
        emnapiTSFN.init();
        PThread.init();
        napiModule.emnapi.syncMemory = $emnapiSyncMemory;
        napiModule.emnapi.getMemoryAddress = $emnapiGetMemoryAddress;
        function addImports(mod) {
            var keys = Object.keys(mod);
            for (var i = 0; i < keys.length; ++i) {
                var k = keys[i];
                if (k.indexOf('$') === 0)
                    continue;
                if (k.indexOf('emnapi_') === 0) {
                    napiModule.imports.emnapi[k] = mod[k];
                }
                else if (k.indexOf('_emnapi_') === 0 || k === 'napi_set_last_error' || k === 'napi_clear_last_error') {
                    napiModule.imports.env[k] = mod[k];
                }
                else {
                    napiModule.imports.napi[k] = mod[k];
                }
            }
        }
        addImports(asyncMod);
        addImports(memoryMod);
        addImports(asyncWorkMod);
        addImports(utilMod);
        addImports(convert2cMod);
        addImports(convert2napiMod);
        addImports(createMod);
        addImports(globalMod);
        addImports(wrapMod);
        addImports(envMod);
        addImports(emnapiMod);
        addImports(errorMod);
        addImports(functionMod);
        addImports(lifeMod);
        addImports(miscellaneousMod);
        addImports(nodeMod);
        addImports(promiseMod);
        addImports(propertyMod);
        addImports(scriptMod);
        addImports(valueOperationMod);
        addImports(versionMod);
        napiModule.imports.napi.napi_create_threadsafe_function = napi_create_threadsafe_function;
        napiModule.imports.napi.napi_get_threadsafe_function_context = napi_get_threadsafe_function_context;
        napiModule.imports.napi.napi_call_threadsafe_function = napi_call_threadsafe_function;
        napiModule.imports.napi.napi_acquire_threadsafe_function = napi_acquire_threadsafe_function;
        napiModule.imports.napi.napi_release_threadsafe_function = napi_release_threadsafe_function;
        napiModule.imports.napi.napi_unref_threadsafe_function = napi_unref_threadsafe_function;
        napiModule.imports.napi.napi_ref_threadsafe_function = napi_ref_threadsafe_function;
        return napiModule;
    })();
    return napiModule;
}

function loadNapiModuleImpl(loadFn, userNapiModule, wasmInput, options) {
    // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
    options = options !== null && options !== void 0 ? options : {};
    var getMemory = options.getMemory;
    var getTable = options.getTable;
    var beforeInit = options.beforeInit;
    if (getMemory != null && typeof getMemory !== 'function') {
        throw new TypeError('options.getMemory is not a function');
    }
    if (getTable != null && typeof getTable !== 'function') {
        throw new TypeError('options.getTable is not a function');
    }
    if (beforeInit != null && typeof beforeInit !== 'function') {
        throw new TypeError('options.beforeInit is not a function');
    }
    var napiModule;
    {
        napiModule = createNapiModule(options);
    }
    var wasi = options.wasi;
    var wasiThreads;
    var importObject = {
        env: napiModule.imports.env,
        napi: napiModule.imports.napi,
        emnapi: napiModule.imports.emnapi
    };
    if (wasi) {
        wasiThreads = new WASIThreads(napiModule.childThread
            ? {
                wasi: wasi,
                childThread: true,
                postMessage: napiModule.postMessage
            }
            : {
                wasi: wasi,
                threadManager: napiModule.PThread,
                waitThreadStart: napiModule.waitThreadStart
            });
        Object.assign(importObject, typeof wasi.getImportObject === 'function'
            ? wasi.getImportObject()
            : { wasi_snapshot_preview1: wasi.wasiImport });
        Object.assign(importObject, wasiThreads.getImportObject());
    }
    var overwriteImports = options.overwriteImports;
    if (typeof overwriteImports === 'function') {
        var newImportObject = overwriteImports(importObject);
        if (typeof newImportObject === 'object' && newImportObject !== null) {
            importObject = newImportObject;
        }
    }
    return loadFn(wasmInput, importObject, function (err, source) {
        if (err) {
            throw err;
        }
        var originalInstance = source.instance;
        var instance = originalInstance;
        var originalExports = originalInstance.exports;
        var exportMemory = 'memory' in originalExports;
        var importMemory = 'memory' in importObject.env;
        var memory = getMemory
            ? getMemory(originalExports)
            : exportMemory
                ? originalExports.memory
                : importMemory
                    ? importObject.env.memory
                    : undefined;
        if (!memory) {
            throw new Error('memory is neither exported nor imported');
        }
        var table = getTable ? getTable(originalExports) : originalExports.__indirect_function_table;
        if (wasi && !exportMemory) {
            var exports_1 = Object.create(null);
            Object.assign(exports_1, originalExports, { memory: memory });
            instance = { exports: exports_1 };
        }
        var module = source.module;
        if (wasi) {
            instance = wasiThreads.initialize(instance, module, memory);
        }
        else {
            napiModule.PThread.setup(module, memory);
        }
        var emnapiInit = function () {
            if (beforeInit) {
                beforeInit({
                    instance: originalInstance,
                    module: module
                });
            }
            napiModule.init({
                instance: instance,
                module: module,
                memory: memory,
                table: table
            });
            var ret = {
                instance: originalInstance,
                module: module,
                usedInstance: instance
            };
            {
                ret.napiModule = napiModule;
            }
            return ret;
        };
        if (napiModule.PThread.shouldPreloadWorkers()) {
            var poolReady = napiModule.PThread.loadWasmModuleToAllWorkers();
            if (loadFn === loadCallback) {
                return poolReady.then(emnapiInit);
            }
            else {
                throw new Error('Synchronous loading is not supported with worker pool (reuseWorker.size > 0)');
            }
        }
        return emnapiInit();
    });
}
function loadCallback(wasmInput, importObject, callback) {
    return load(wasmInput, importObject).then(function (source) {
        return callback(null, source);
    }, function (err) {
        return callback(err);
    });
}
function loadSyncCallback(wasmInput, importObject, callback) {
    var source;
    try {
        source = loadSync(wasmInput, importObject);
    }
    catch (err) {
        return callback(err);
    }
    return callback(null, source);
}
/** @public */
function instantiateNapiModule(
/** Only support `BufferSource` or `WebAssembly.Module` on Node.js */
wasmInput, options) {
    return loadNapiModuleImpl(loadCallback, undefined, wasmInput, options);
}
/** @public */
function instantiateNapiModuleSync(wasmInput, options) {
    return loadNapiModuleImpl(loadSyncCallback, undefined, wasmInput, options);
}

/** @public */
var MessageHandler = /*#__PURE__*/ (function (_super) {
    __extends(MessageHandler, _super);
    function MessageHandler(options) {
        var _this = this;
        if (typeof options.onLoad !== 'function') {
            throw new TypeError('options.onLoad is not a function');
        }
        _this = _super.call(this, options) || this;
        _this.napiModule = undefined;
        return _this;
    }
    MessageHandler.prototype.instantiate = function (data) {
        var _this = this;
        var source = this.onLoad(data);
        var then = source.then;
        if (typeof then === 'function') {
            return source.then(function (result) {
                _this.napiModule = result.napiModule;
                return result;
            });
        }
        this.napiModule = source.napiModule;
        return source;
    };
    MessageHandler.prototype.handle = function (e) {
        var _this = this;
        var _a;
        _super.prototype.handle.call(this, e);
        if ((_a = e === null || e === void 0 ? void 0 : e.data) === null || _a === void 0 ? void 0 : _a.__emnapi__) {
            var type = e.data.__emnapi__.type;
            var payload_1 = e.data.__emnapi__.payload;
            if (type === 'async-worker-init') {
                this.handleAfterLoad(e, function () {
                    _this.napiModule.initWorker(payload_1.arg);
                });
            }
            else if (type === 'async-work-execute') {
                this.handleAfterLoad(e, function () {
                    _this.napiModule.executeAsyncWork(payload_1.work);
                });
            }
        }
    };
    return MessageHandler;
}(ThreadMessageHandler));

var externalValue = new WeakMap();
/** @public */
function isExternal(object) {
    return externalValue.has(object);
}
/** @public */ // eslint-disable-next-line @typescript-eslint/no-redeclare
var External = (function () {
    function External(value) {
        Object.setPrototypeOf(this, null);
        externalValue.set(this, value);
    }
    External.prototype = null;
    return External;
})();
/** @public */
function getExternalValue(external) {
    if (!isExternal(external)) {
        throw new TypeError('not external');
    }
    return externalValue.get(external);
}

var supportNewFunction = /*#__PURE__*/ (function () {
    var f;
    try {
        f = new Function();
    }
    catch (_) {
        return false;
    }
    return typeof f === 'function';
})();
var _global = /*#__PURE__*/ (function () {
    if (typeof globalThis !== 'undefined')
        return globalThis;
    var g = (function () { return this; })();
    if (!g && supportNewFunction) {
        try {
            g = new Function('return this')();
        }
        catch (_) { }
    }
    if (!g) {
        {
            if (typeof global !== 'undefined')
                return global;
        }
        if (typeof window !== 'undefined')
            return window;
        if (typeof self !== 'undefined')
            return self;
    }
    return g;
})();
var TryCatch = /*#__PURE__*/ (function () {
    function TryCatch() {
        this._exception = undefined;
        this._caught = false;
    }
    TryCatch.prototype.isEmpty = function () {
        return !this._caught;
    };
    TryCatch.prototype.hasCaught = function () {
        return this._caught;
    };
    TryCatch.prototype.exception = function () {
        return this._exception;
    };
    TryCatch.prototype.setError = function (err) {
        this._caught = true;
        this._exception = err;
    };
    TryCatch.prototype.reset = function () {
        this._caught = false;
        this._exception = undefined;
    };
    TryCatch.prototype.extractException = function () {
        var e = this._exception;
        this.reset();
        return e;
    };
    return TryCatch;
}());
var canSetFunctionName = /*#__PURE__*/ (function () {
    var _a;
    try {
        return Boolean((_a = Object.getOwnPropertyDescriptor(Function.prototype, 'name')) === null || _a === void 0 ? void 0 : _a.configurable);
    }
    catch (_) {
        return false;
    }
})();
var supportReflect = typeof Reflect === 'object';
var supportFinalizer = (typeof FinalizationRegistry !== 'undefined') && (typeof WeakRef !== 'undefined');
var supportWeakSymbol = /*#__PURE__*/ (function () {
    try {
        // eslint-disable-next-line symbol-description
        var sym = Symbol();
        // eslint-disable-next-line no-new
        new WeakRef(sym);
        new WeakMap().set(sym, undefined);
    }
    catch (_) {
        return false;
    }
    return true;
})();
var supportBigInt = typeof BigInt !== 'undefined';
var _require = /*#__PURE__*/ (function () {
    var nativeRequire;
    {
        nativeRequire = (function () {
            return (typeof require !== 'undefined' ? require : undefined);
        })();
    }
    return nativeRequire;
})();
var _MessageChannel = typeof MessageChannel === 'function'
    ? MessageChannel
    : /*#__PURE__*/ (function () {
        try {
            return _require('worker_threads').MessageChannel;
        }
        catch (_) { }
        return undefined;
    })();
var _setImmediate = typeof setImmediate === 'function'
    ? setImmediate
    : function (callback) {
        if (typeof callback !== 'function') {
            throw new TypeError('The "callback" argument must be of type function');
        }
        if (_MessageChannel) {
            var channel_1 = new _MessageChannel();
            channel_1.port1.onmessage = function () {
                channel_1.port1.onmessage = null;
                channel_1 = undefined;
                callback();
            };
            channel_1.port2.postMessage(null);
        }
        else {
            setTimeout(callback, 0);
        }
    };
var _Buffer = typeof Buffer === 'function'
    ? Buffer
    : /*#__PURE__*/ (function () {
        try {
            return _require('buffer').Buffer;
        }
        catch (_) { }
        return undefined;
    })();
var version = "1.4.0";
var NODE_API_SUPPORTED_VERSION_MAX = 10 /* Version.NODE_API_SUPPORTED_VERSION_MAX */;
var NAPI_VERSION_EXPERIMENTAL = 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */;
var NODE_API_DEFAULT_MODULE_API_VERSION = 8 /* Version.NODE_API_DEFAULT_MODULE_API_VERSION */;

var Handle = /*#__PURE__*/ (function () {
    function Handle(id, value) {
        this.id = id;
        this.value = value;
    }
    Handle.prototype.data = function () {
        return getExternalValue(this.value);
    };
    Handle.prototype.isNumber = function () {
        return typeof this.value === 'number';
    };
    Handle.prototype.isBigInt = function () {
        return typeof this.value === 'bigint';
    };
    Handle.prototype.isString = function () {
        return typeof this.value === 'string';
    };
    Handle.prototype.isFunction = function () {
        return typeof this.value === 'function';
    };
    Handle.prototype.isExternal = function () {
        return isExternal(this.value);
    };
    Handle.prototype.isObject = function () {
        return typeof this.value === 'object' && this.value !== null;
    };
    Handle.prototype.isArray = function () {
        return Array.isArray(this.value);
    };
    Handle.prototype.isArrayBuffer = function () {
        return (this.value instanceof ArrayBuffer);
    };
    Handle.prototype.isTypedArray = function () {
        return (ArrayBuffer.isView(this.value)) && !(this.value instanceof DataView);
    };
    Handle.prototype.isBuffer = function (BufferConstructor) {
        if (ArrayBuffer.isView(this.value))
            return true;
        BufferConstructor !== null && BufferConstructor !== void 0 ? BufferConstructor : (BufferConstructor = _Buffer);
        return typeof BufferConstructor === 'function' && BufferConstructor.isBuffer(this.value);
    };
    Handle.prototype.isDataView = function () {
        return (this.value instanceof DataView);
    };
    Handle.prototype.isDate = function () {
        return (this.value instanceof Date);
    };
    Handle.prototype.isPromise = function () {
        return (this.value instanceof Promise);
    };
    Handle.prototype.isBoolean = function () {
        return typeof this.value === 'boolean';
    };
    Handle.prototype.isUndefined = function () {
        return this.value === undefined;
    };
    Handle.prototype.isSymbol = function () {
        return typeof this.value === 'symbol';
    };
    Handle.prototype.isNull = function () {
        return this.value === null;
    };
    Handle.prototype.dispose = function () {
        this.value = undefined;
    };
    return Handle;
}());
var ConstHandle = /*#__PURE__*/ (function (_super) {
    __extends(ConstHandle, _super);
    function ConstHandle(id, value) {
        return _super.call(this, id, value) || this;
    }
    ConstHandle.prototype.dispose = function () { };
    return ConstHandle;
}(Handle));
var HandleStore = /*#__PURE__*/ (function () {
    function HandleStore() {
        this._values = [
            undefined,
            HandleStore.UNDEFINED,
            HandleStore.NULL,
            HandleStore.FALSE,
            HandleStore.TRUE,
            HandleStore.GLOBAL
        ];
        this._next = HandleStore.MIN_ID;
    }
    HandleStore.prototype.push = function (value) {
        var h;
        var next = this._next;
        var values = this._values;
        if (next < values.length) {
            h = values[next];
            h.value = value;
        }
        else {
            h = new Handle(next, value);
            values[next] = h;
        }
        this._next++;
        return h;
    };
    HandleStore.prototype.erase = function (start, end) {
        this._next = start;
        var values = this._values;
        for (var i = start; i < end; ++i) {
            values[i].dispose();
        }
    };
    HandleStore.prototype.get = function (id) {
        return this._values[id];
    };
    HandleStore.prototype.swap = function (a, b) {
        var values = this._values;
        var h = values[a];
        values[a] = values[b];
        values[a].id = Number(a);
        values[b] = h;
        h.id = Number(b);
    };
    HandleStore.prototype.dispose = function () {
        this._values.length = HandleStore.MIN_ID;
        this._next = HandleStore.MIN_ID;
    };
    HandleStore.UNDEFINED = new ConstHandle(1 /* GlobalHandle.UNDEFINED */, undefined);
    HandleStore.NULL = new ConstHandle(2 /* GlobalHandle.NULL */, null);
    HandleStore.FALSE = new ConstHandle(3 /* GlobalHandle.FALSE */, false);
    HandleStore.TRUE = new ConstHandle(4 /* GlobalHandle.TRUE */, true);
    HandleStore.GLOBAL = new ConstHandle(5 /* GlobalHandle.GLOBAL */, _global);
    HandleStore.MIN_ID = 6;
    return HandleStore;
}());

var HandleScope = /*#__PURE__*/ (function () {
    function HandleScope(handleStore, id, parentScope, start, end) {
        if (end === void 0) { end = start; }
        this.handleStore = handleStore;
        this.id = id;
        this.parent = parentScope;
        this.child = null;
        if (parentScope !== null)
            parentScope.child = this;
        this.start = start;
        this.end = end;
        this._escapeCalled = false;
        this.callbackInfo = {
            thiz: undefined,
            data: 0,
            args: undefined,
            fn: undefined
        };
    }
    HandleScope.prototype.add = function (value) {
        var h = this.handleStore.push(value);
        this.end++;
        return h;
    };
    HandleScope.prototype.addExternal = function (data) {
        return this.add(new External(data));
    };
    HandleScope.prototype.dispose = function () {
        if (this._escapeCalled)
            this._escapeCalled = false;
        if (this.start === this.end)
            return;
        this.handleStore.erase(this.start, this.end);
    };
    HandleScope.prototype.escape = function (handle) {
        if (this._escapeCalled)
            return null;
        this._escapeCalled = true;
        if (handle < this.start || handle >= this.end) {
            return null;
        }
        this.handleStore.swap(handle, this.start);
        var h = this.handleStore.get(this.start);
        this.start++;
        this.parent.end++;
        return h;
    };
    HandleScope.prototype.escapeCalled = function () {
        return this._escapeCalled;
    };
    return HandleScope;
}());

var ScopeStore = /*#__PURE__*/ (function () {
    function ScopeStore() {
        this._rootScope = new HandleScope(null, 0, null, 1, HandleStore.MIN_ID);
        this.currentScope = this._rootScope;
        this._values = [undefined];
    }
    ScopeStore.prototype.get = function (id) {
        return this._values[id];
    };
    ScopeStore.prototype.openScope = function (envObject) {
        var currentScope = this.currentScope;
        var scope = currentScope.child;
        if (scope !== null) {
            scope.start = scope.end = currentScope.end;
        }
        else {
            var id = currentScope.id + 1;
            scope = new HandleScope(envObject.ctx.handleStore, id, currentScope, currentScope.end);
            this._values[id] = scope;
        }
        this.currentScope = scope;
        envObject.openHandleScopes++;
        return scope;
    };
    ScopeStore.prototype.closeScope = function (envObject) {
        if (envObject.openHandleScopes === 0)
            return;
        var scope = this.currentScope;
        this.currentScope = scope.parent;
        scope.dispose();
        envObject.openHandleScopes--;
    };
    ScopeStore.prototype.dispose = function () {
        this.currentScope = this._rootScope;
        this._values.length = 1;
    };
    return ScopeStore;
}());

var RefTracker = /*#__PURE__*/ (function () {
    function RefTracker() {
        this._next = null;
        this._prev = null;
    }
    /** @virtual */
    RefTracker.prototype.dispose = function () { };
    /** @virtual */
    RefTracker.prototype.finalize = function () { };
    RefTracker.prototype.link = function (list) {
        this._prev = list;
        this._next = list._next;
        if (this._next !== null) {
            this._next._prev = this;
        }
        list._next = this;
    };
    RefTracker.prototype.unlink = function () {
        if (this._prev !== null) {
            this._prev._next = this._next;
        }
        if (this._next !== null) {
            this._next._prev = this._prev;
        }
        this._prev = null;
        this._next = null;
    };
    RefTracker.finalizeAll = function (list) {
        while (list._next !== null) {
            list._next.finalize();
        }
    };
    return RefTracker;
}());

var Finalizer = /*#__PURE__*/ (function () {
    function Finalizer(envObject, _finalizeCallback, _finalizeData, _finalizeHint) {
        if (_finalizeCallback === void 0) { _finalizeCallback = 0; }
        if (_finalizeData === void 0) { _finalizeData = 0; }
        if (_finalizeHint === void 0) { _finalizeHint = 0; }
        this.envObject = envObject;
        this._finalizeCallback = _finalizeCallback;
        this._finalizeData = _finalizeData;
        this._finalizeHint = _finalizeHint;
        this._makeDynCall_vppp = envObject.makeDynCall_vppp;
    }
    Finalizer.prototype.callback = function () { return this._finalizeCallback; };
    Finalizer.prototype.data = function () { return this._finalizeData; };
    Finalizer.prototype.hint = function () { return this._finalizeHint; };
    Finalizer.prototype.resetEnv = function () {
        this.envObject = undefined;
    };
    Finalizer.prototype.resetFinalizer = function () {
        this._finalizeCallback = 0;
        this._finalizeData = 0;
        this._finalizeHint = 0;
    };
    Finalizer.prototype.callFinalizer = function () {
        var finalize_callback = this._finalizeCallback;
        var finalize_data = this._finalizeData;
        var finalize_hint = this._finalizeHint;
        this.resetFinalizer();
        if (!finalize_callback)
            return;
        var fini = Number(finalize_callback);
        if (!this.envObject) {
            this._makeDynCall_vppp(fini)(0, finalize_data, finalize_hint);
        }
        else {
            this.envObject.callFinalizer(fini, finalize_data, finalize_hint);
        }
    };
    Finalizer.prototype.dispose = function () {
        this.envObject = undefined;
        this._makeDynCall_vppp = undefined;
    };
    return Finalizer;
}());

var TrackedFinalizer = /*#__PURE__*/ (function (_super) {
    __extends(TrackedFinalizer, _super);
    function TrackedFinalizer(envObject, finalize_callback, finalize_data, finalize_hint) {
        var _this = _super.call(this) || this;
        _this._finalizer = new Finalizer(envObject, finalize_callback, finalize_data, finalize_hint);
        return _this;
    }
    TrackedFinalizer.create = function (envObject, finalize_callback, finalize_data, finalize_hint) {
        var finalizer = new TrackedFinalizer(envObject, finalize_callback, finalize_data, finalize_hint);
        finalizer.link(envObject.finalizing_reflist);
        return finalizer;
    };
    TrackedFinalizer.prototype.data = function () {
        return this._finalizer.data();
    };
    TrackedFinalizer.prototype.dispose = function () {
        if (!this._finalizer)
            return;
        this.unlink();
        this._finalizer.envObject.dequeueFinalizer(this);
        this._finalizer.dispose();
        this._finalizer = undefined;
        _super.prototype.dispose.call(this);
    };
    TrackedFinalizer.prototype.finalize = function () {
        this.unlink();
        var error;
        var caught = false;
        try {
            this._finalizer.callFinalizer();
        }
        catch (err) {
            caught = true;
            error = err;
        }
        this.dispose();
        if (caught) {
            throw error;
        }
    };
    return TrackedFinalizer;
}(RefTracker));

function throwNodeApiVersionError(moduleName, moduleApiVersion) {
    var errorMessage = "".concat(moduleName, " requires Node-API version ").concat(moduleApiVersion, ", but this version of Node.js only supports version ").concat(NODE_API_SUPPORTED_VERSION_MAX, " add-ons.");
    throw new Error(errorMessage);
}
function handleThrow(envObject, value) {
    if (envObject.terminatedOrTerminating()) {
        return;
    }
    throw value;
}
var Env = /*#__PURE__*/ (function () {
    function Env(ctx, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort) {
        this.ctx = ctx;
        this.moduleApiVersion = moduleApiVersion;
        this.makeDynCall_vppp = makeDynCall_vppp;
        this.makeDynCall_vp = makeDynCall_vp;
        this.abort = abort;
        this.openHandleScopes = 0;
        this.instanceData = null;
        this.tryCatch = new TryCatch();
        this.refs = 1;
        this.reflist = new RefTracker();
        this.finalizing_reflist = new RefTracker();
        this.pendingFinalizers = [];
        this.lastError = {
            errorCode: 0 /* napi_status.napi_ok */,
            engineErrorCode: 0,
            engineReserved: 0
        };
        this.inGcFinalizer = false;
        this._bindingMap = new WeakMap();
        this.id = 0;
    }
    /** @virtual */
    Env.prototype.canCallIntoJs = function () {
        return true;
    };
    Env.prototype.terminatedOrTerminating = function () {
        return !this.canCallIntoJs();
    };
    Env.prototype.ref = function () {
        this.refs++;
    };
    Env.prototype.unref = function () {
        this.refs--;
        if (this.refs === 0) {
            this.dispose();
        }
    };
    Env.prototype.ensureHandle = function (value) {
        return this.ctx.ensureHandle(value);
    };
    Env.prototype.ensureHandleId = function (value) {
        return this.ensureHandle(value).id;
    };
    Env.prototype.clearLastError = function () {
        var lastError = this.lastError;
        if (lastError.errorCode !== 0 /* napi_status.napi_ok */)
            lastError.errorCode = 0 /* napi_status.napi_ok */;
        if (lastError.engineErrorCode !== 0)
            lastError.engineErrorCode = 0;
        if (lastError.engineReserved !== 0)
            lastError.engineReserved = 0;
        return 0 /* napi_status.napi_ok */;
    };
    Env.prototype.setLastError = function (error_code, engine_error_code, engine_reserved) {
        if (engine_error_code === void 0) { engine_error_code = 0; }
        if (engine_reserved === void 0) { engine_reserved = 0; }
        var lastError = this.lastError;
        if (lastError.errorCode !== error_code)
            lastError.errorCode = error_code;
        if (lastError.engineErrorCode !== engine_error_code)
            lastError.engineErrorCode = engine_error_code;
        if (lastError.engineReserved !== engine_reserved)
            lastError.engineReserved = engine_reserved;
        return error_code;
    };
    Env.prototype.getReturnStatus = function () {
        return !this.tryCatch.hasCaught() ? 0 /* napi_status.napi_ok */ : this.setLastError(10 /* napi_status.napi_pending_exception */);
    };
    Env.prototype.callIntoModule = function (fn, handleException) {
        if (handleException === void 0) { handleException = handleThrow; }
        var openHandleScopesBefore = this.openHandleScopes;
        this.clearLastError();
        var r = fn(this);
        if (openHandleScopesBefore !== this.openHandleScopes) {
            this.abort('open_handle_scopes != open_handle_scopes_before');
        }
        if (this.tryCatch.hasCaught()) {
            var err = this.tryCatch.extractException();
            handleException(this, err);
        }
        return r;
    };
    Env.prototype.invokeFinalizerFromGC = function (finalizer) {
        if (this.moduleApiVersion !== NAPI_VERSION_EXPERIMENTAL) {
            this.enqueueFinalizer(finalizer);
        }
        else {
            var saved = this.inGcFinalizer;
            this.inGcFinalizer = true;
            try {
                finalizer.finalize();
            }
            finally {
                this.inGcFinalizer = saved;
            }
        }
    };
    Env.prototype.checkGCAccess = function () {
        if (this.moduleApiVersion === NAPI_VERSION_EXPERIMENTAL && this.inGcFinalizer) {
            this.abort('Finalizer is calling a function that may affect GC state.\n' +
                'The finalizers are run directly from GC and must not affect GC ' +
                'state.\n' +
                'Use `node_api_post_finalizer` from inside of the finalizer to work ' +
                'around this issue.\n' +
                'It schedules the call as a new task in the event loop.');
        }
    };
    /** @virtual */
    Env.prototype.enqueueFinalizer = function (finalizer) {
        if (this.pendingFinalizers.indexOf(finalizer) === -1) {
            this.pendingFinalizers.push(finalizer);
        }
    };
    /** @virtual */
    Env.prototype.dequeueFinalizer = function (finalizer) {
        var index = this.pendingFinalizers.indexOf(finalizer);
        if (index !== -1) {
            this.pendingFinalizers.splice(index, 1);
        }
    };
    /** @virtual */
    Env.prototype.deleteMe = function () {
        RefTracker.finalizeAll(this.finalizing_reflist);
        RefTracker.finalizeAll(this.reflist);
        this.tryCatch.extractException();
        this.ctx.envStore.remove(this.id);
    };
    Env.prototype.dispose = function () {
        if (this.id === 0)
            return;
        this.deleteMe();
        this.finalizing_reflist.dispose();
        this.reflist.dispose();
        this.id = 0;
    };
    Env.prototype.initObjectBinding = function (value) {
        var binding = {
            wrapped: 0,
            tag: null
        };
        this._bindingMap.set(value, binding);
        return binding;
    };
    Env.prototype.getObjectBinding = function (value) {
        if (this._bindingMap.has(value)) {
            return this._bindingMap.get(value);
        }
        return this.initObjectBinding(value);
    };
    Env.prototype.setInstanceData = function (data, finalize_cb, finalize_hint) {
        if (this.instanceData) {
            this.instanceData.dispose();
        }
        this.instanceData = TrackedFinalizer.create(this, finalize_cb, data, finalize_hint);
    };
    Env.prototype.getInstanceData = function () {
        return this.instanceData ? this.instanceData.data() : 0;
    };
    return Env;
}());
var NodeEnv = /*#__PURE__*/ (function (_super) {
    __extends(NodeEnv, _super);
    function NodeEnv(ctx, filename, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort, nodeBinding) {
        var _this = _super.call(this, ctx, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort) || this;
        _this.filename = filename;
        _this.nodeBinding = nodeBinding;
        _this.destructing = false;
        _this.finalizationScheduled = false;
        return _this;
    }
    NodeEnv.prototype.deleteMe = function () {
        this.destructing = true;
        this.drainFinalizerQueue();
        _super.prototype.deleteMe.call(this);
    };
    NodeEnv.prototype.canCallIntoJs = function () {
        return _super.prototype.canCallIntoJs.call(this) && this.ctx.canCallIntoJs();
    };
    NodeEnv.prototype.triggerFatalException = function (err) {
        if (this.nodeBinding) {
            this.nodeBinding.napi.fatalException(err);
        }
        else {
            {
                throw err;
            }
        }
    };
    NodeEnv.prototype.callbackIntoModule = function (enforceUncaughtExceptionPolicy, fn) {
        return this.callIntoModule(fn, function (envObject, err) {
            if (envObject.terminatedOrTerminating()) {
                return;
            }
            if (envObject.moduleApiVersion < 10 && true && !enforceUncaughtExceptionPolicy) {
                var warn = function (warning, type, code) {
                        if (warning instanceof Error) {
                            console.warn(warning.toString());
                        }
                        else {
                            var prefix = code ? "[".concat(code, "] ") : '';
                            // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
                            console.warn("".concat(prefix).concat(type || 'Warning', ": ").concat(warning));
                        }
                    };
                warn('Uncaught N-API callback exception detected, please run node with option --force-node-api-uncaught-exceptions-policy=true to handle those exceptions properly.', 'DeprecationWarning', 'DEP0168');
                return;
            }
            envObject.triggerFatalException(err);
        });
    };
    NodeEnv.prototype.callFinalizer = function (cb, data, hint) {
        this.callFinalizerInternal(1, cb, data, hint);
    };
    NodeEnv.prototype.callFinalizerInternal = function (forceUncaught, cb, data, hint) {
        var f = this.makeDynCall_vppp(cb);
        var env = this.id;
        var scope = this.ctx.openScope(this);
        try {
            this.callbackIntoModule(Boolean(forceUncaught), function () { f(env, data, hint); });
        }
        finally {
            this.ctx.closeScope(this, scope);
        }
    };
    NodeEnv.prototype.enqueueFinalizer = function (finalizer) {
        var _this = this;
        _super.prototype.enqueueFinalizer.call(this, finalizer);
        if (!this.finalizationScheduled && !this.destructing) {
            this.finalizationScheduled = true;
            this.ref();
            _setImmediate(function () {
                _this.finalizationScheduled = false;
                _this.unref();
                _this.drainFinalizerQueue();
            });
        }
    };
    NodeEnv.prototype.drainFinalizerQueue = function () {
        while (this.pendingFinalizers.length > 0) {
            var refTracker = this.pendingFinalizers.shift();
            refTracker.finalize();
        }
    };
    return NodeEnv;
}(Env));
function newEnv(ctx, filename, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort, nodeBinding) {
    moduleApiVersion = typeof moduleApiVersion !== 'number' ? NODE_API_DEFAULT_MODULE_API_VERSION : moduleApiVersion;
    // Validate module_api_version.
    if (moduleApiVersion < NODE_API_DEFAULT_MODULE_API_VERSION) {
        moduleApiVersion = NODE_API_DEFAULT_MODULE_API_VERSION;
    }
    else if (moduleApiVersion > NODE_API_SUPPORTED_VERSION_MAX && moduleApiVersion !== NAPI_VERSION_EXPERIMENTAL) {
        throwNodeApiVersionError(filename, moduleApiVersion);
    }
    var env = new NodeEnv(ctx, filename, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort, nodeBinding);
    ctx.envStore.add(env);
    ctx.addCleanupHook(env, function () { env.unref(); }, 0);
    return env;
}

var EmnapiError = /*#__PURE__*/ (function (_super) {
    __extends(EmnapiError, _super);
    function EmnapiError(message) {
        var _newTarget = this.constructor;
        var _this = _super.call(this, message) || this;
        var ErrorConstructor = _newTarget;
        var proto = ErrorConstructor.prototype;
        if (!(_this instanceof EmnapiError)) {
            var setPrototypeOf = Object.setPrototypeOf;
            if (typeof setPrototypeOf === 'function') {
                setPrototypeOf.call(Object, _this, proto);
            }
            else {
                // eslint-disable-next-line no-proto
                _this.__proto__ = proto;
            }
            if (typeof Error.captureStackTrace === 'function') {
                Error.captureStackTrace(_this, ErrorConstructor);
            }
        }
        return _this;
    }
    return EmnapiError;
}(Error));
Object.defineProperty(EmnapiError.prototype, 'name', {
    configurable: true,
    writable: true,
    value: 'EmnapiError'
});
var NotSupportWeakRefError = /*#__PURE__*/ (function (_super) {
    __extends(NotSupportWeakRefError, _super);
    function NotSupportWeakRefError(api, message) {
        return _super.call(this, "".concat(api, ": The current runtime does not support \"FinalizationRegistry\" and \"WeakRef\".").concat(message ? " ".concat(message) : '')) || this;
    }
    return NotSupportWeakRefError;
}(EmnapiError));
Object.defineProperty(NotSupportWeakRefError.prototype, 'name', {
    configurable: true,
    writable: true,
    value: 'NotSupportWeakRefError'
});
var NotSupportBufferError = /*#__PURE__*/ (function (_super) {
    __extends(NotSupportBufferError, _super);
    function NotSupportBufferError(api, message) {
        return _super.call(this, "".concat(api, ": The current runtime does not support \"Buffer\". Consider using buffer polyfill to make sure `globalThis.Buffer` is defined.").concat(message ? " ".concat(message) : '')) || this;
    }
    return NotSupportBufferError;
}(EmnapiError));
Object.defineProperty(NotSupportBufferError.prototype, 'name', {
    configurable: true,
    writable: true,
    value: 'NotSupportBufferError'
});

var StrongRef = /*#__PURE__*/ (function () {
    function StrongRef(value) {
        this._value = value;
    }
    StrongRef.prototype.deref = function () {
        return this._value;
    };
    StrongRef.prototype.dispose = function () {
        this._value = undefined;
    };
    return StrongRef;
}());
var Persistent = /*#__PURE__*/ (function () {
    function Persistent(value) {
        this._ref = new StrongRef(value);
    }
    Persistent.prototype.setWeak = function (param, callback) {
        if (!supportFinalizer || this._ref === undefined || this._ref instanceof WeakRef)
            return;
        var value = this._ref.deref();
        try {
            Persistent._registry.register(value, this, this);
            var weakRef = new WeakRef(value);
            this._ref.dispose();
            this._ref = weakRef;
            this._param = param;
            this._callback = callback;
        }
        catch (err) {
            if (typeof value === 'symbol') ;
            else {
                throw err;
            }
        }
    };
    Persistent.prototype.clearWeak = function () {
        if (!supportFinalizer || this._ref === undefined)
            return;
        if (this._ref instanceof WeakRef) {
            try {
                Persistent._registry.unregister(this);
            }
            catch (_) { }
            this._param = undefined;
            this._callback = undefined;
            var value = this._ref.deref();
            if (value === undefined) {
                this._ref = value;
            }
            else {
                this._ref = new StrongRef(value);
            }
        }
    };
    Persistent.prototype.reset = function () {
        if (supportFinalizer) {
            try {
                Persistent._registry.unregister(this);
            }
            catch (_) { }
        }
        this._param = undefined;
        this._callback = undefined;
        if (this._ref instanceof StrongRef) {
            this._ref.dispose();
        }
        this._ref = undefined;
    };
    Persistent.prototype.isEmpty = function () {
        return this._ref === undefined;
    };
    Persistent.prototype.deref = function () {
        if (this._ref === undefined)
            return undefined;
        return this._ref.deref();
    };
    Persistent._registry = supportFinalizer
        ? new FinalizationRegistry(function (value) {
            value._ref = undefined;
            var callback = value._callback;
            var param = value._param;
            value._callback = undefined;
            value._param = undefined;
            if (typeof callback === 'function') {
                callback(param);
            }
        })
        : undefined;
    return Persistent;
}());

var ReferenceOwnership;
(function (ReferenceOwnership) {
    ReferenceOwnership[ReferenceOwnership["kRuntime"] = 0] = "kRuntime";
    ReferenceOwnership[ReferenceOwnership["kUserland"] = 1] = "kUserland";
})(ReferenceOwnership || (ReferenceOwnership = {}));
function canBeHeldWeakly(value) {
    return value.isObject() || value.isFunction() || value.isSymbol();
}
var Reference = /*#__PURE__*/ (function (_super) {
    __extends(Reference, _super);
    function Reference(envObject, handle_id, initialRefcount, ownership) {
        var _this = _super.call(this) || this;
        _this.envObject = envObject;
        _this._refcount = initialRefcount;
        _this._ownership = ownership;
        var handle = envObject.ctx.handleStore.get(handle_id);
        _this.canBeWeak = canBeHeldWeakly(handle);
        _this.persistent = new Persistent(handle.value);
        _this.id = 0;
        if (initialRefcount === 0) {
            _this._setWeak();
        }
        return _this;
    }
    Reference.weakCallback = function (ref) {
        ref.persistent.reset();
        ref.invokeFinalizerFromGC();
    };
    Reference.create = function (envObject, handle_id, initialRefcount, ownership, _unused1, _unused2, _unused3) {
        var ref = new Reference(envObject, handle_id, initialRefcount, ownership);
        envObject.ctx.refStore.add(ref);
        ref.link(envObject.reflist);
        return ref;
    };
    Reference.prototype.ref = function () {
        if (this.persistent.isEmpty()) {
            return 0;
        }
        if (++this._refcount === 1 && this.canBeWeak) {
            this.persistent.clearWeak();
        }
        return this._refcount;
    };
    Reference.prototype.unref = function () {
        if (this.persistent.isEmpty() || this._refcount === 0) {
            return 0;
        }
        if (--this._refcount === 0) {
            this._setWeak();
        }
        return this._refcount;
    };
    Reference.prototype.get = function (envObject) {
        if (envObject === void 0) { envObject = this.envObject; }
        if (this.persistent.isEmpty()) {
            return 0;
        }
        var obj = this.persistent.deref();
        var handle = envObject.ensureHandle(obj);
        return handle.id;
    };
    /** @virtual */
    Reference.prototype.resetFinalizer = function () { };
    /** @virtual */
    Reference.prototype.data = function () { return 0; };
    Reference.prototype.refcount = function () { return this._refcount; };
    Reference.prototype.ownership = function () { return this._ownership; };
    /** @virtual */
    Reference.prototype.callUserFinalizer = function () { };
    /** @virtual */
    Reference.prototype.invokeFinalizerFromGC = function () {
        this.finalize();
    };
    Reference.prototype._setWeak = function () {
        if (this.canBeWeak) {
            this.persistent.setWeak(this, Reference.weakCallback);
        }
        else {
            this.persistent.reset();
        }
    };
    Reference.prototype.finalize = function () {
        this.persistent.reset();
        var deleteMe = this._ownership === ReferenceOwnership.kRuntime;
        this.unlink();
        this.callUserFinalizer();
        if (deleteMe) {
            this.dispose();
        }
    };
    Reference.prototype.dispose = function () {
        if (this.id === 0)
            return;
        this.unlink();
        this.persistent.reset();
        this.envObject.ctx.refStore.remove(this.id);
        _super.prototype.dispose.call(this);
        this.envObject = undefined;
        this.id = 0;
    };
    return Reference;
}(RefTracker));
var ReferenceWithData = /*#__PURE__*/ (function (_super) {
    __extends(ReferenceWithData, _super);
    function ReferenceWithData(envObject, value, initialRefcount, ownership, _data) {
        var _this = _super.call(this, envObject, value, initialRefcount, ownership) || this;
        _this._data = _data;
        return _this;
    }
    ReferenceWithData.create = function (envObject, value, initialRefcount, ownership, data) {
        var reference = new ReferenceWithData(envObject, value, initialRefcount, ownership, data);
        envObject.ctx.refStore.add(reference);
        reference.link(envObject.reflist);
        return reference;
    };
    ReferenceWithData.prototype.data = function () {
        return this._data;
    };
    return ReferenceWithData;
}(Reference));
var ReferenceWithFinalizer = /*#__PURE__*/ (function (_super) {
    __extends(ReferenceWithFinalizer, _super);
    function ReferenceWithFinalizer(envObject, value, initialRefcount, ownership, finalize_callback, finalize_data, finalize_hint) {
        var _this = _super.call(this, envObject, value, initialRefcount, ownership) || this;
        _this._finalizer = new Finalizer(envObject, finalize_callback, finalize_data, finalize_hint);
        return _this;
    }
    ReferenceWithFinalizer.create = function (envObject, value, initialRefcount, ownership, finalize_callback, finalize_data, finalize_hint) {
        var reference = new ReferenceWithFinalizer(envObject, value, initialRefcount, ownership, finalize_callback, finalize_data, finalize_hint);
        envObject.ctx.refStore.add(reference);
        reference.link(envObject.finalizing_reflist);
        return reference;
    };
    ReferenceWithFinalizer.prototype.resetFinalizer = function () {
        this._finalizer.resetFinalizer();
    };
    ReferenceWithFinalizer.prototype.data = function () {
        return this._finalizer.data();
    };
    ReferenceWithFinalizer.prototype.callUserFinalizer = function () {
        this._finalizer.callFinalizer();
    };
    ReferenceWithFinalizer.prototype.invokeFinalizerFromGC = function () {
        this._finalizer.envObject.invokeFinalizerFromGC(this);
    };
    ReferenceWithFinalizer.prototype.dispose = function () {
        if (!this._finalizer)
            return;
        this._finalizer.envObject.dequeueFinalizer(this);
        this._finalizer.dispose();
        _super.prototype.dispose.call(this);
        this._finalizer = undefined;
    };
    return ReferenceWithFinalizer;
}(Reference));

var Deferred = /*#__PURE__*/ (function () {
    function Deferred(ctx, value) {
        this.id = 0;
        this.ctx = ctx;
        this.value = value;
    }
    Deferred.create = function (ctx, value) {
        var deferred = new Deferred(ctx, value);
        ctx.deferredStore.add(deferred);
        return deferred;
    };
    Deferred.prototype.resolve = function (value) {
        this.value.resolve(value);
        this.dispose();
    };
    Deferred.prototype.reject = function (reason) {
        this.value.reject(reason);
        this.dispose();
    };
    Deferred.prototype.dispose = function () {
        this.ctx.deferredStore.remove(this.id);
        this.id = 0;
        this.value = null;
        this.ctx = null;
    };
    return Deferred;
}());

var Store = /*#__PURE__*/ (function () {
    function Store() {
        this._values = [undefined];
        this._values.length = 4;
        this._size = 1;
        this._freeList = [];
    }
    Store.prototype.add = function (value) {
        var id;
        if (this._freeList.length) {
            id = this._freeList.shift();
        }
        else {
            id = this._size;
            this._size++;
            var capacity = this._values.length;
            if (id >= capacity) {
                this._values.length = capacity + (capacity >> 1) + 16;
            }
        }
        value.id = id;
        this._values[id] = value;
    };
    Store.prototype.get = function (id) {
        return this._values[id];
    };
    Store.prototype.has = function (id) {
        return this._values[id] !== undefined;
    };
    Store.prototype.remove = function (id) {
        var value = this._values[id];
        if (value) {
            value.id = 0;
            this._values[id] = undefined;
            this._freeList.push(Number(id));
        }
    };
    Store.prototype.dispose = function () {
        for (var i = 1; i < this._size; ++i) {
            var value = this._values[i];
            value === null || value === void 0 ? void 0 : value.dispose();
        }
        this._values = [undefined];
        this._size = 1;
        this._freeList = [];
    };
    return Store;
}());

var CleanupHookCallback = /*#__PURE__*/ (function () {
    function CleanupHookCallback(envObject, fn, arg, order) {
        this.envObject = envObject;
        this.fn = fn;
        this.arg = arg;
        this.order = order;
    }
    return CleanupHookCallback;
}());
var CleanupQueue = /*#__PURE__*/ (function () {
    function CleanupQueue() {
        this._cleanupHooks = [];
        this._cleanupHookCounter = 0;
    }
    CleanupQueue.prototype.empty = function () {
        return this._cleanupHooks.length === 0;
    };
    CleanupQueue.prototype.add = function (envObject, fn, arg) {
        if (this._cleanupHooks.filter(function (hook) { return (hook.envObject === envObject && hook.fn === fn && hook.arg === arg); }).length > 0) {
            throw new Error('Can not add same fn and arg twice');
        }
        this._cleanupHooks.push(new CleanupHookCallback(envObject, fn, arg, this._cleanupHookCounter++));
    };
    CleanupQueue.prototype.remove = function (envObject, fn, arg) {
        for (var i = 0; i < this._cleanupHooks.length; ++i) {
            var hook = this._cleanupHooks[i];
            if (hook.envObject === envObject && hook.fn === fn && hook.arg === arg) {
                this._cleanupHooks.splice(i, 1);
                return;
            }
        }
    };
    CleanupQueue.prototype.drain = function () {
        var hooks = this._cleanupHooks.slice();
        hooks.sort(function (a, b) { return (b.order - a.order); });
        for (var i = 0; i < hooks.length; ++i) {
            var cb = hooks[i];
            if (typeof cb.fn === 'number') {
                cb.envObject.makeDynCall_vp(cb.fn)(cb.arg);
            }
            else {
                cb.fn(cb.arg);
            }
            this._cleanupHooks.splice(this._cleanupHooks.indexOf(cb), 1);
        }
    };
    CleanupQueue.prototype.dispose = function () {
        this._cleanupHooks.length = 0;
        this._cleanupHookCounter = 0;
    };
    return CleanupQueue;
}());
var Context = /*#__PURE__*/ (function () {
    function Context() {
        this._isStopping = false;
        this._canCallIntoJs = true;
        this._suppressDestroy = false;
        this.envStore = new Store();
        this.scopeStore = new ScopeStore();
        this.refStore = new Store();
        this.deferredStore = new Store();
        this.handleStore = new HandleStore();
        this.feature = {
            supportReflect: supportReflect,
            supportFinalizer: supportFinalizer,
            supportWeakSymbol: supportWeakSymbol,
            supportBigInt: supportBigInt,
            supportNewFunction: supportNewFunction,
            canSetFunctionName: canSetFunctionName,
            setImmediate: _setImmediate,
            Buffer: _Buffer,
            MessageChannel: _MessageChannel
        };
        this.cleanupQueue = new CleanupQueue();
    }
    /**
     * Suppress the destroy on `beforeExit` event in Node.js.
     * Call this method if you want to keep the context and
     * all associated {@link Env | Env} alive,
     * this also means that cleanup hooks will not be called.
     * After call this method, you should call
     * {@link Context.destroy | `Context.prototype.destroy`} method manually.
     */
    Context.prototype.suppressDestroy = function () {
        this._suppressDestroy = true;
    };
    // eslint-disable-next-line @typescript-eslint/explicit-function-return-type
    Context.prototype.getRuntimeVersions = function () {
        return {
            version: version,
            NODE_API_SUPPORTED_VERSION_MAX: NODE_API_SUPPORTED_VERSION_MAX,
            NAPI_VERSION_EXPERIMENTAL: NAPI_VERSION_EXPERIMENTAL,
            NODE_API_DEFAULT_MODULE_API_VERSION: NODE_API_DEFAULT_MODULE_API_VERSION
        };
    };
    Context.prototype.createNotSupportWeakRefError = function (api, message) {
        return new NotSupportWeakRefError(api, message);
    };
    Context.prototype.createNotSupportBufferError = function (api, message) {
        return new NotSupportBufferError(api, message);
    };
    Context.prototype.createReference = function (envObject, handle_id, initialRefcount, ownership) {
        return Reference.create(envObject, handle_id, initialRefcount, ownership);
    };
    Context.prototype.createReferenceWithData = function (envObject, handle_id, initialRefcount, ownership, data) {
        return ReferenceWithData.create(envObject, handle_id, initialRefcount, ownership, data);
    };
    Context.prototype.createReferenceWithFinalizer = function (envObject, handle_id, initialRefcount, ownership, finalize_callback, finalize_data, finalize_hint) {
        if (finalize_callback === void 0) { finalize_callback = 0; }
        if (finalize_data === void 0) { finalize_data = 0; }
        if (finalize_hint === void 0) { finalize_hint = 0; }
        return ReferenceWithFinalizer.create(envObject, handle_id, initialRefcount, ownership, finalize_callback, finalize_data, finalize_hint);
    };
    Context.prototype.createDeferred = function (value) {
        return Deferred.create(this, value);
    };
    Context.prototype.createEnv = function (filename, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort, nodeBinding) {
        return newEnv(this, filename, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort, nodeBinding);
    };
    Context.prototype.createTrackedFinalizer = function (envObject, finalize_callback, finalize_data, finalize_hint) {
        return TrackedFinalizer.create(envObject, finalize_callback, finalize_data, finalize_hint);
    };
    Context.prototype.getCurrentScope = function () {
        return this.scopeStore.currentScope;
    };
    Context.prototype.addToCurrentScope = function (value) {
        return this.scopeStore.currentScope.add(value);
    };
    Context.prototype.openScope = function (envObject) {
        return this.scopeStore.openScope(envObject);
    };
    Context.prototype.closeScope = function (envObject, _scope) {
        this.scopeStore.closeScope(envObject);
    };
    Context.prototype.ensureHandle = function (value) {
        switch (value) {
            case undefined: return HandleStore.UNDEFINED;
            case null: return HandleStore.NULL;
            case true: return HandleStore.TRUE;
            case false: return HandleStore.FALSE;
            case _global: return HandleStore.GLOBAL;
        }
        return this.addToCurrentScope(value);
    };
    Context.prototype.addCleanupHook = function (envObject, fn, arg) {
        this.cleanupQueue.add(envObject, fn, arg);
    };
    Context.prototype.removeCleanupHook = function (envObject, fn, arg) {
        this.cleanupQueue.remove(envObject, fn, arg);
    };
    Context.prototype.runCleanup = function () {
        while (!this.cleanupQueue.empty()) {
            this.cleanupQueue.drain();
        }
    };
    Context.prototype.increaseWaitingRequestCounter = function () {
        var _a;
        (_a = this.refCounter) === null || _a === void 0 ? void 0 : _a.increase();
    };
    Context.prototype.decreaseWaitingRequestCounter = function () {
        var _a;
        (_a = this.refCounter) === null || _a === void 0 ? void 0 : _a.decrease();
    };
    Context.prototype.setCanCallIntoJs = function (value) {
        this._canCallIntoJs = value;
    };
    Context.prototype.setStopping = function (value) {
        this._isStopping = value;
    };
    Context.prototype.canCallIntoJs = function () {
        return this._canCallIntoJs && !this._isStopping;
    };
    /**
     * Destroy the context and call cleanup hooks.
     * Associated {@link Env | Env} will be destroyed.
     */
    Context.prototype.destroy = function () {
        this.setStopping(true);
        this.setCanCallIntoJs(false);
        this.runCleanup();
    };
    return Context;
}());
var defaultContext;
function createContext() {
    return new Context();
}
function getDefaultContext() {
    if (!defaultContext) {
        defaultContext = createContext();
    }
    return defaultContext;
}

const _WebAssembly = typeof WebAssembly !== 'undefined'
    ? WebAssembly
    : typeof WXWebAssembly !== 'undefined'
        ? WXWebAssembly
        : undefined;
if (!_WebAssembly) {
    throw new Error('WebAssembly is not supported in this environment');
}

/* eslint-disable spaced-comment */

function validateObject(value, name) {
    if (value === null || typeof value !== 'object') {
        throw new TypeError(`${name} must be an object. Received ${value === null ? 'null' : typeof value}`);
    }
}
function validateArray(value, name) {
    if (!Array.isArray(value)) {
        throw new TypeError(`${name} must be an array. Received ${value === null ? 'null' : typeof value}`);
    }
}
function validateBoolean(value, name) {
    if (typeof value !== 'boolean') {
        throw new TypeError(`${name} must be a boolean. Received ${value === null ? 'null' : typeof value}`);
    }
}
function validateString(value, name) {
    if (typeof value !== 'string') {
        throw new TypeError(`${name} must be a string. Received ${value === null ? 'null' : typeof value}`);
    }
}
function validateFunction(value, name) {
    if (typeof value !== 'function') {
        throw new TypeError(`${name} must be a function. Received ${value === null ? 'null' : typeof value}`);
    }
}
function validateUndefined(value, name) {
    if (value !== undefined) {
        throw new TypeError(`${name} must be undefined. Received ${value === null ? 'null' : typeof value}`);
    }
}
function isPromiseLike(obj) {
    return !!(obj && (typeof obj === 'object' || typeof obj === 'function') && typeof obj.then === 'function');
}
function unsharedSlice(view, start, end) {
    return ((typeof SharedArrayBuffer === 'function' && view.buffer instanceof SharedArrayBuffer) || (Object.prototype.toString.call(view.buffer.constructor) === '[object SharedArrayBuffer]'))
        ? view.slice(start, end)
        : view.subarray(start, end);
}

const CHAR_DOT = 46; /* . */
const CHAR_FORWARD_SLASH = 47; /* / */
function isPosixPathSeparator(code) {
    return code === CHAR_FORWARD_SLASH;
}
function normalizeString(path, allowAboveRoot, separator, isPathSeparator) {
    let res = '';
    let lastSegmentLength = 0;
    let lastSlash = -1;
    let dots = 0;
    let code = 0;
    for (let i = 0; i <= path.length; ++i) {
        if (i < path.length) {
            code = path.charCodeAt(i);
        }
        else if (isPathSeparator(code)) {
            break;
        }
        else {
            code = CHAR_FORWARD_SLASH;
        }
        if (isPathSeparator(code)) {
            if (lastSlash === i - 1 || dots === 1) ;
            else if (dots === 2) {
                if (res.length < 2 || lastSegmentLength !== 2 ||
                    res.charCodeAt(res.length - 1) !== CHAR_DOT ||
                    res.charCodeAt(res.length - 2) !== CHAR_DOT) {
                    if (res.length > 2) {
                        const lastSlashIndex = res.indexOf(separator);
                        if (lastSlashIndex === -1) {
                            res = '';
                            lastSegmentLength = 0;
                        }
                        else {
                            res = res.slice(0, lastSlashIndex);
                            lastSegmentLength =
                                res.length - 1 - res.indexOf(separator);
                        }
                        lastSlash = i;
                        dots = 0;
                        continue;
                    }
                    else if (res.length !== 0) {
                        res = '';
                        lastSegmentLength = 0;
                        lastSlash = i;
                        dots = 0;
                        continue;
                    }
                }
                if (allowAboveRoot) {
                    res += res.length > 0 ? `${separator}..` : '..';
                    lastSegmentLength = 2;
                }
            }
            else {
                if (res.length > 0) {
                    res += `${separator}${path.slice(lastSlash + 1, i)}`;
                }
                else {
                    res = path.slice(lastSlash + 1, i);
                }
                lastSegmentLength = i - lastSlash - 1;
            }
            lastSlash = i;
            dots = 0;
        }
        else if (code === CHAR_DOT && dots !== -1) {
            ++dots;
        }
        else {
            dots = -1;
        }
    }
    return res;
}
function resolve(...args) {
    let resolvedPath = '';
    let resolvedAbsolute = false;
    for (let i = args.length - 1; i >= -1 && !resolvedAbsolute; i--) {
        const path = i >= 0 ? args[i] : '/';
        validateString(path, 'path');
        // Skip empty entries
        if (path.length === 0) {
            continue;
        }
        resolvedPath = `${path}/${resolvedPath}`;
        resolvedAbsolute = path.charCodeAt(0) === CHAR_FORWARD_SLASH;
    }
    // At this point the path should be resolved to a full absolute path, but
    // handle relative paths to be safe (might happen when process.cwd() fails)
    // Normalize the path
    resolvedPath = normalizeString(resolvedPath, !resolvedAbsolute, '/', isPosixPathSeparator);
    if (resolvedAbsolute) {
        return `/${resolvedPath}`;
    }
    return resolvedPath.length > 0 ? resolvedPath : '.';
}

const FD_DATASYNC = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(0));
const FD_READ = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(1));
const FD_SEEK = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(2));
const FD_FDSTAT_SET_FLAGS = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(3));
const FD_SYNC = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(4));
const FD_TELL = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(5));
const FD_WRITE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(6));
const FD_ADVISE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(7));
const FD_ALLOCATE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(8));
const PATH_CREATE_DIRECTORY = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(9));
const PATH_CREATE_FILE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(10));
const PATH_LINK_SOURCE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(11));
const PATH_LINK_TARGET = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(12));
const PATH_OPEN = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(13));
const FD_READDIR = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(14));
const PATH_READLINK = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(15));
const PATH_RENAME_SOURCE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(16));
const PATH_RENAME_TARGET = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(17));
const PATH_FILESTAT_GET = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(18));
const PATH_FILESTAT_SET_SIZE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(19));
const PATH_FILESTAT_SET_TIMES = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(20));
const FD_FILESTAT_GET = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(21));
const FD_FILESTAT_SET_SIZE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(22));
const FD_FILESTAT_SET_TIMES = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(23));
const PATH_SYMLINK = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(24));
const PATH_REMOVE_DIRECTORY = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(25));
const PATH_UNLINK_FILE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(26));
const POLL_FD_READWRITE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(27));
const SOCK_SHUTDOWN = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(28));
const SOCK_ACCEPT = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(29));
const WasiRights = {
    FD_DATASYNC,
    FD_READ,
    FD_SEEK,
    FD_FDSTAT_SET_FLAGS,
    FD_SYNC,
    FD_TELL,
    FD_WRITE,
    FD_ADVISE,
    FD_ALLOCATE,
    PATH_CREATE_DIRECTORY,
    PATH_CREATE_FILE,
    PATH_LINK_SOURCE,
    PATH_LINK_TARGET,
    PATH_OPEN,
    FD_READDIR,
    PATH_READLINK,
    PATH_RENAME_SOURCE,
    PATH_RENAME_TARGET,
    PATH_FILESTAT_GET,
    PATH_FILESTAT_SET_SIZE,
    PATH_FILESTAT_SET_TIMES,
    FD_FILESTAT_GET,
    FD_FILESTAT_SET_SIZE,
    FD_FILESTAT_SET_TIMES,
    PATH_SYMLINK,
    PATH_REMOVE_DIRECTORY,
    PATH_UNLINK_FILE,
    POLL_FD_READWRITE,
    SOCK_SHUTDOWN,
    SOCK_ACCEPT
};

function strerror(errno) {
    switch (errno) {
        case 0 /* WasiErrno.ESUCCESS */: return 'Success';
        case 1 /* WasiErrno.E2BIG */: return 'Argument list too long';
        case 2 /* WasiErrno.EACCES */: return 'Permission denied';
        case 3 /* WasiErrno.EADDRINUSE */: return 'Address in use';
        case 4 /* WasiErrno.EADDRNOTAVAIL */: return 'Address not available';
        case 5 /* WasiErrno.EAFNOSUPPORT */: return 'Address family not supported by protocol';
        case 6 /* WasiErrno.EAGAIN */: return 'Resource temporarily unavailable';
        case 7 /* WasiErrno.EALREADY */: return 'Operation already in progress';
        case 8 /* WasiErrno.EBADF */: return 'Bad file descriptor';
        case 9 /* WasiErrno.EBADMSG */: return 'Bad message';
        case 10 /* WasiErrno.EBUSY */: return 'Resource busy';
        case 11 /* WasiErrno.ECANCELED */: return 'Operation canceled';
        case 12 /* WasiErrno.ECHILD */: return 'No child null';
        case 13 /* WasiErrno.ECONNABORTED */: return 'Connection aborted';
        case 14 /* WasiErrno.ECONNREFUSED */: return 'Connection refused';
        case 15 /* WasiErrno.ECONNRESET */: return 'Connection reset by peer';
        case 16 /* WasiErrno.EDEADLK */: return 'Resource deadlock would occur';
        case 17 /* WasiErrno.EDESTADDRREQ */: return 'Destination address required';
        case 18 /* WasiErrno.EDOM */: return 'Domain error';
        case 19 /* WasiErrno.EDQUOT */: return 'Quota exceeded';
        case 20 /* WasiErrno.EEXIST */: return 'File exists';
        case 21 /* WasiErrno.EFAULT */: return 'Bad address';
        case 22 /* WasiErrno.EFBIG */: return 'File too large';
        case 23 /* WasiErrno.EHOSTUNREACH */: return 'Host is unreachable';
        case 24 /* WasiErrno.EIDRM */: return 'Identifier removed';
        case 25 /* WasiErrno.EILSEQ */: return 'Illegal byte sequence';
        case 26 /* WasiErrno.EINPROGRESS */: return 'Operation in progress';
        case 27 /* WasiErrno.EINTR */: return 'Interrupted system call';
        case 28 /* WasiErrno.EINVAL */: return 'Invalid argument';
        case 29 /* WasiErrno.EIO */: return 'I/O error';
        case 30 /* WasiErrno.EISCONN */: return 'Socket is connected';
        case 31 /* WasiErrno.EISDIR */: return 'Is a directory';
        case 32 /* WasiErrno.ELOOP */: return 'Symbolic link loop';
        case 33 /* WasiErrno.EMFILE */: return 'No file descriptors available';
        case 34 /* WasiErrno.EMLINK */: return 'Too many links';
        case 35 /* WasiErrno.EMSGSIZE */: return 'Message too large';
        case 36 /* WasiErrno.EMULTIHOP */: return 'Multihop attempted';
        case 37 /* WasiErrno.ENAMETOOLONG */: return 'Filename too long';
        case 38 /* WasiErrno.ENETDOWN */: return 'Network is down';
        case 39 /* WasiErrno.ENETRESET */: return 'Connection reset by network';
        case 40 /* WasiErrno.ENETUNREACH */: return 'Network unreachable';
        case 41 /* WasiErrno.ENFILE */: return 'Too many files open in system';
        case 42 /* WasiErrno.ENOBUFS */: return 'No buffer space available';
        case 43 /* WasiErrno.ENODEV */: return 'No such device';
        case 44 /* WasiErrno.ENOENT */: return 'No such file or directory';
        case 45 /* WasiErrno.ENOEXEC */: return 'Exec format error';
        case 46 /* WasiErrno.ENOLCK */: return 'No locks available';
        case 47 /* WasiErrno.ENOLINK */: return 'Link has been severed';
        case 48 /* WasiErrno.ENOMEM */: return 'Out of memory';
        case 49 /* WasiErrno.ENOMSG */: return 'No message of the desired type';
        case 50 /* WasiErrno.ENOPROTOOPT */: return 'Protocol not available';
        case 51 /* WasiErrno.ENOSPC */: return 'No space left on device';
        case 52 /* WasiErrno.ENOSYS */: return 'Function not implemented';
        case 53 /* WasiErrno.ENOTCONN */: return 'Socket not connected';
        case 54 /* WasiErrno.ENOTDIR */: return 'Not a directory';
        case 55 /* WasiErrno.ENOTEMPTY */: return 'Directory not empty';
        case 56 /* WasiErrno.ENOTRECOVERABLE */: return 'State not recoverable';
        case 57 /* WasiErrno.ENOTSOCK */: return 'Not a socket';
        case 58 /* WasiErrno.ENOTSUP */: return 'Not supported';
        case 59 /* WasiErrno.ENOTTY */: return 'Not a tty';
        case 60 /* WasiErrno.ENXIO */: return 'No such device or address';
        case 61 /* WasiErrno.EOVERFLOW */: return 'Value too large for data type';
        case 62 /* WasiErrno.EOWNERDEAD */: return 'Previous owner died';
        case 63 /* WasiErrno.EPERM */: return 'Operation not permitted';
        case 64 /* WasiErrno.EPIPE */: return 'Broken pipe';
        case 65 /* WasiErrno.EPROTO */: return 'Protocol error';
        case 66 /* WasiErrno.EPROTONOSUPPORT */: return 'Protocol not supported';
        case 67 /* WasiErrno.EPROTOTYPE */: return 'Protocol wrong type for socket';
        case 68 /* WasiErrno.ERANGE */: return 'Result not representable';
        case 69 /* WasiErrno.EROFS */: return 'Read-only file system';
        case 70 /* WasiErrno.ESPIPE */: return 'Invalid seek';
        case 71 /* WasiErrno.ESRCH */: return 'No such null';
        case 72 /* WasiErrno.ESTALE */: return 'Stale file handle';
        case 73 /* WasiErrno.ETIMEDOUT */: return 'Operation timed out';
        case 74 /* WasiErrno.ETXTBSY */: return 'Text file busy';
        case 75 /* WasiErrno.EXDEV */: return 'Cross-device link';
        case 76 /* WasiErrno.ENOTCAPABLE */: return 'Capabilities insufficient';
        default: return 'Unknown error';
    }
}
class WasiError extends Error {
    constructor(message, errno) {
        super(message);
        this.errno = errno;
    }
    getErrorMessage() {
        return strerror(this.errno);
    }
}
Object.defineProperty(WasiError.prototype, 'name', {
    configurable: true,
    writable: true,
    value: 'WasiError'
});

const RIGHTS_ALL = WasiRights.FD_DATASYNC |
    WasiRights.FD_READ |
    WasiRights.FD_SEEK |
    WasiRights.FD_FDSTAT_SET_FLAGS |
    WasiRights.FD_SYNC |
    WasiRights.FD_TELL |
    WasiRights.FD_WRITE |
    WasiRights.FD_ADVISE |
    WasiRights.FD_ALLOCATE |
    WasiRights.PATH_CREATE_DIRECTORY |
    WasiRights.PATH_CREATE_FILE |
    WasiRights.PATH_LINK_SOURCE |
    WasiRights.PATH_LINK_TARGET |
    WasiRights.PATH_OPEN |
    WasiRights.FD_READDIR |
    WasiRights.PATH_READLINK |
    WasiRights.PATH_RENAME_SOURCE |
    WasiRights.PATH_RENAME_TARGET |
    WasiRights.PATH_FILESTAT_GET |
    WasiRights.PATH_FILESTAT_SET_SIZE |
    WasiRights.PATH_FILESTAT_SET_TIMES |
    WasiRights.FD_FILESTAT_GET |
    WasiRights.FD_FILESTAT_SET_TIMES |
    WasiRights.FD_FILESTAT_SET_SIZE |
    WasiRights.PATH_SYMLINK |
    WasiRights.PATH_UNLINK_FILE |
    WasiRights.PATH_REMOVE_DIRECTORY |
    WasiRights.POLL_FD_READWRITE |
    WasiRights.SOCK_SHUTDOWN |
    WasiRights.SOCK_ACCEPT;
const BLOCK_DEVICE_BASE = RIGHTS_ALL;
const BLOCK_DEVICE_INHERITING = RIGHTS_ALL;
const CHARACTER_DEVICE_BASE = RIGHTS_ALL;
const CHARACTER_DEVICE_INHERITING = RIGHTS_ALL;
const REGULAR_FILE_BASE = WasiRights.FD_DATASYNC |
    WasiRights.FD_READ |
    WasiRights.FD_SEEK |
    WasiRights.FD_FDSTAT_SET_FLAGS |
    WasiRights.FD_SYNC |
    WasiRights.FD_TELL |
    WasiRights.FD_WRITE |
    WasiRights.FD_ADVISE |
    WasiRights.FD_ALLOCATE |
    WasiRights.FD_FILESTAT_GET |
    WasiRights.FD_FILESTAT_SET_SIZE |
    WasiRights.FD_FILESTAT_SET_TIMES |
    WasiRights.POLL_FD_READWRITE;
const REGULAR_FILE_INHERITING = /*#__PURE__*/ BigInt(0);
const DIRECTORY_BASE = WasiRights.FD_FDSTAT_SET_FLAGS |
    WasiRights.FD_SYNC |
    WasiRights.FD_ADVISE |
    WasiRights.PATH_CREATE_DIRECTORY |
    WasiRights.PATH_CREATE_FILE |
    WasiRights.PATH_LINK_SOURCE |
    WasiRights.PATH_LINK_TARGET |
    WasiRights.PATH_OPEN |
    WasiRights.FD_READDIR |
    WasiRights.PATH_READLINK |
    WasiRights.PATH_RENAME_SOURCE |
    WasiRights.PATH_RENAME_TARGET |
    WasiRights.PATH_FILESTAT_GET |
    WasiRights.PATH_FILESTAT_SET_SIZE |
    WasiRights.PATH_FILESTAT_SET_TIMES |
    WasiRights.FD_FILESTAT_GET |
    WasiRights.FD_FILESTAT_SET_TIMES |
    WasiRights.PATH_SYMLINK |
    WasiRights.PATH_UNLINK_FILE |
    WasiRights.PATH_REMOVE_DIRECTORY |
    WasiRights.POLL_FD_READWRITE;
const DIRECTORY_INHERITING = DIRECTORY_BASE | REGULAR_FILE_BASE;
const SOCKET_BASE = (WasiRights.FD_READ |
    WasiRights.FD_FDSTAT_SET_FLAGS |
    WasiRights.FD_WRITE |
    WasiRights.FD_FILESTAT_GET |
    WasiRights.POLL_FD_READWRITE |
    WasiRights.SOCK_SHUTDOWN);
const SOCKET_INHERITING = RIGHTS_ALL;
const TTY_BASE = WasiRights.FD_READ |
    WasiRights.FD_FDSTAT_SET_FLAGS |
    WasiRights.FD_WRITE |
    WasiRights.FD_FILESTAT_GET |
    WasiRights.POLL_FD_READWRITE;
const TTY_INHERITING = /*#__PURE__*/ BigInt(0);
function getRights(stdio, fd, flags, type) {
    const ret = {
        base: BigInt(0),
        inheriting: BigInt(0)
    };
    if (type === 0 /* WasiFileType.UNKNOWN */) {
        throw new WasiError('Unknown file type', 28 /* WasiErrno.EINVAL */);
    }
    switch (type) {
        case 4 /* WasiFileType.REGULAR_FILE */:
            ret.base = REGULAR_FILE_BASE;
            ret.inheriting = REGULAR_FILE_INHERITING;
            break;
        case 3 /* WasiFileType.DIRECTORY */:
            ret.base = DIRECTORY_BASE;
            ret.inheriting = DIRECTORY_INHERITING;
            break;
        case 6 /* WasiFileType.SOCKET_STREAM */:
        case 5 /* WasiFileType.SOCKET_DGRAM */:
            ret.base = SOCKET_BASE;
            ret.inheriting = SOCKET_INHERITING;
            break;
        case 2 /* WasiFileType.CHARACTER_DEVICE */:
            if (stdio.indexOf(fd) !== -1) {
                ret.base = TTY_BASE;
                ret.inheriting = TTY_INHERITING;
            }
            else {
                ret.base = CHARACTER_DEVICE_BASE;
                ret.inheriting = CHARACTER_DEVICE_INHERITING;
            }
            break;
        case 1 /* WasiFileType.BLOCK_DEVICE */:
            ret.base = BLOCK_DEVICE_BASE;
            ret.inheriting = BLOCK_DEVICE_INHERITING;
            break;
        default:
            ret.base = BigInt(0);
            ret.inheriting = BigInt(0);
    }
    /* Disable read/write bits depending on access mode. */
    const read_or_write_only = flags & (0 | 1 | 2);
    if (read_or_write_only === 0) {
        ret.base &= ~WasiRights.FD_WRITE;
    }
    else if (read_or_write_only === 1) {
        ret.base &= ~WasiRights.FD_READ;
    }
    return ret;
}

function concatBuffer(buffers, size) {
    let total = 0;
    {
        for (let i = 0; i < buffers.length; i++) {
            const buffer = buffers[i];
            total += buffer.length;
        }
    }
    let pos = 0;
    const ret = new Uint8Array(total);
    for (let i = 0; i < buffers.length; i++) {
        const buffer = buffers[i];
        ret.set(buffer, pos);
        pos += buffer.length;
    }
    return ret;
}
class FileDescriptor {
    constructor(id, fd, path, realPath, type, rightsBase, rightsInheriting, preopen) {
        this.id = id;
        this.fd = fd;
        this.path = path;
        this.realPath = realPath;
        this.type = type;
        this.rightsBase = rightsBase;
        this.rightsInheriting = rightsInheriting;
        this.preopen = preopen;
        this.pos = BigInt(0);
        this.size = BigInt(0);
    }
    seek(offset, whence) {
        if (whence === 0 /* WasiWhence.SET */) {
            this.pos = BigInt(offset);
        }
        else if (whence === 1 /* WasiWhence.CUR */) {
            this.pos += BigInt(offset);
        }
        else if (whence === 2 /* WasiWhence.END */) {
            this.pos = BigInt(this.size) - BigInt(offset);
        }
        else {
            throw new WasiError('Unknown whence', 29 /* WasiErrno.EIO */);
        }
        return this.pos;
    }
}
class StandardOutput extends FileDescriptor {
    constructor(log, id, fd, path, realPath, type, rightsBase, rightsInheriting, preopen) {
        super(id, fd, path, realPath, type, rightsBase, rightsInheriting, preopen);
        this._log = log;
        this._buf = null;
    }
    write(buffer) {
        const originalBuffer = buffer;
        if (this._buf) {
            buffer = concatBuffer([this._buf, buffer]);
            this._buf = null;
        }
        if (buffer.indexOf(10) === -1) {
            this._buf = buffer;
            return originalBuffer.byteLength;
        }
        let written = 0;
        let lastBegin = 0;
        let index;
        while ((index = buffer.indexOf(10, written)) !== -1) {
            const str = new TextDecoder().decode(buffer.subarray(lastBegin, index));
            this._log(str);
            written += index - lastBegin + 1;
            lastBegin = index + 1;
        }
        if (written < buffer.length) {
            this._buf = buffer.slice(written);
        }
        return originalBuffer.byteLength;
    }
}
function toFileType(stat) {
    if (stat.isBlockDevice())
        return 1 /* WasiFileType.BLOCK_DEVICE */;
    if (stat.isCharacterDevice())
        return 2 /* WasiFileType.CHARACTER_DEVICE */;
    if (stat.isDirectory())
        return 3 /* WasiFileType.DIRECTORY */;
    if (stat.isSocket())
        return 6 /* WasiFileType.SOCKET_STREAM */;
    if (stat.isFile())
        return 4 /* WasiFileType.REGULAR_FILE */;
    if (stat.isSymbolicLink())
        return 7 /* WasiFileType.SYMBOLIC_LINK */;
    return 0 /* WasiFileType.UNKNOWN */;
}
function toFileStat(view, buf, stat) {
    view.setBigUint64(buf, stat.dev, true);
    view.setBigUint64(buf + 8, stat.ino, true);
    view.setBigUint64(buf + 16, BigInt(toFileType(stat)), true);
    view.setBigUint64(buf + 24, stat.nlink, true);
    view.setBigUint64(buf + 32, stat.size, true);
    view.setBigUint64(buf + 40, stat.atimeMs * BigInt(1000000), true);
    view.setBigUint64(buf + 48, stat.mtimeMs * BigInt(1000000), true);
    view.setBigUint64(buf + 56, stat.ctimeMs * BigInt(1000000), true);
}
class FileDescriptorTable {
    constructor(options) {
        this.used = 0;
        this.size = options.size;
        this.fds = Array(options.size);
        this.stdio = [options.in, options.out, options.err];
        this.print = options.print;
        this.printErr = options.printErr;
        this.insertStdio(options.in, 0, '<stdin>');
        this.insertStdio(options.out, 1, '<stdout>');
        this.insertStdio(options.err, 2, '<stderr>');
    }
    insertStdio(fd, expected, name) {
        const type = 2 /* WasiFileType.CHARACTER_DEVICE */;
        const { base, inheriting } = getRights(this.stdio, fd, 2 /* FileControlFlag.O_RDWR */, type);
        const wrap = this.insert(fd, name, name, type, base, inheriting, 0);
        if (wrap.id !== expected) {
            throw new WasiError(`id: ${wrap.id} !== expected: ${expected}`, 8 /* WasiErrno.EBADF */);
        }
        return wrap;
    }
    insert(fd, mappedPath, realPath, type, rightsBase, rightsInheriting, preopen) {
        var _a, _b;
        let index = -1;
        if (this.used >= this.size) {
            const newSize = this.size * 2;
            this.fds.length = newSize;
            index = this.size;
            this.size = newSize;
        }
        else {
            for (let i = 0; i < this.size; ++i) {
                if (this.fds[i] == null) {
                    index = i;
                    break;
                }
            }
        }
        let entry;
        if (mappedPath === '<stdout>') {
            entry = new StandardOutput((_a = this.print) !== null && _a !== void 0 ? _a : console.log, index, fd, mappedPath, realPath, type, rightsBase, rightsInheriting, preopen);
        }
        else if (mappedPath === '<stderr>') {
            entry = new StandardOutput((_b = this.printErr) !== null && _b !== void 0 ? _b : console.error, index, fd, mappedPath, realPath, type, rightsBase, rightsInheriting, preopen);
        }
        else {
            entry = new FileDescriptor(index, fd, mappedPath, realPath, type, rightsBase, rightsInheriting, preopen);
        }
        this.fds[index] = entry;
        this.used++;
        return entry;
    }
    get(id, base, inheriting) {
        if (id >= this.size) {
            throw new WasiError('Invalid fd', 8 /* WasiErrno.EBADF */);
        }
        const entry = this.fds[id];
        if (!entry || entry.id !== id) {
            throw new WasiError('Bad file descriptor', 8 /* WasiErrno.EBADF */);
        }
        /* Validate that the fd has the necessary rights. */
        if ((~entry.rightsBase & base) !== BigInt(0) || (~entry.rightsInheriting & inheriting) !== BigInt(0)) {
            throw new WasiError('Capabilities insufficient', 76 /* WasiErrno.ENOTCAPABLE */);
        }
        return entry;
    }
    remove(id) {
        if (id >= this.size) {
            throw new WasiError('Invalid fd', 8 /* WasiErrno.EBADF */);
        }
        const entry = this.fds[id];
        if (!entry || entry.id !== id) {
            throw new WasiError('Bad file descriptor', 8 /* WasiErrno.EBADF */);
        }
        this.fds[id] = undefined;
        this.used--;
    }
}
class SyncTable extends FileDescriptorTable {
    constructor(options) {
        super(options);
        this.fs = options.fs;
    }
    getFileTypeByFd(fd) {
        const stats = this.fs.fstatSync(fd, { bigint: true });
        return toFileType(stats);
    }
    insertPreopen(fd, mappedPath, realPath) {
        const type = this.getFileTypeByFd(fd);
        if (type !== 3 /* WasiFileType.DIRECTORY */) {
            throw new WasiError(`Preopen not dir: ["${mappedPath}", "${realPath}"]`, 54 /* WasiErrno.ENOTDIR */);
        }
        const result = getRights(this.stdio, fd, 0, type);
        return this.insert(fd, mappedPath, realPath, type, result.base, result.inheriting, 1);
    }
    renumber(dst, src) {
        if (dst === src)
            return;
        if (dst >= this.size || src >= this.size) {
            throw new WasiError('Invalid fd', 8 /* WasiErrno.EBADF */);
        }
        const dstEntry = this.fds[dst];
        const srcEntry = this.fds[src];
        if (!dstEntry || !srcEntry || dstEntry.id !== dst || srcEntry.id !== src) {
            throw new WasiError('Invalid fd', 8 /* WasiErrno.EBADF */);
        }
        this.fs.closeSync(dstEntry.fd);
        this.fds[dst] = this.fds[src];
        this.fds[dst].id = dst;
        this.fds[src] = undefined;
        this.used--;
    }
}
class AsyncTable extends FileDescriptorTable {
    // eslint-disable-next-line @typescript-eslint/no-useless-constructor
    constructor(options) {
        super(options);
    }
    async getFileTypeByFd(fd) {
        const stats = await fd.stat({ bigint: true });
        return toFileType(stats);
    }
    async insertPreopen(fd, mappedPath, realPath) {
        const type = await this.getFileTypeByFd(fd);
        if (type !== 3 /* WasiFileType.DIRECTORY */) {
            throw new WasiError(`Preopen not dir: ["${mappedPath}", "${realPath}"]`, 54 /* WasiErrno.ENOTDIR */);
        }
        const result = getRights(this.stdio, fd.fd, 0, type);
        return this.insert(fd, mappedPath, realPath, type, result.base, result.inheriting, 1);
    }
    async renumber(dst, src) {
        if (dst === src)
            return;
        if (dst >= this.size || src >= this.size) {
            throw new WasiError('Invalid fd', 8 /* WasiErrno.EBADF */);
        }
        const dstEntry = this.fds[dst];
        const srcEntry = this.fds[src];
        if (!dstEntry || !srcEntry || dstEntry.id !== dst || srcEntry.id !== src) {
            throw new WasiError('Invalid fd', 8 /* WasiErrno.EBADF */);
        }
        await dstEntry.fd.close();
        this.fds[dst] = this.fds[src];
        this.fds[dst].id = dst;
        this.fds[src] = undefined;
        this.used--;
    }
}

/** @public */
const WebAssemblyMemory = /*#__PURE__*/ (function () { return _WebAssembly.Memory; })();
/** @public */
class Memory extends WebAssemblyMemory {
    // eslint-disable-next-line @typescript-eslint/no-useless-constructor
    constructor(descriptor) {
        super(descriptor);
    }
    get HEAP8() { return new Int8Array(super.buffer); }
    get HEAPU8() { return new Uint8Array(super.buffer); }
    get HEAP16() { return new Int16Array(super.buffer); }
    get HEAPU16() { return new Uint16Array(super.buffer); }
    get HEAP32() { return new Int32Array(super.buffer); }
    get HEAPU32() { return new Uint32Array(super.buffer); }
    get HEAP64() { return new BigInt64Array(super.buffer); }
    get HEAPU64() { return new BigUint64Array(super.buffer); }
    get HEAPF32() { return new Float32Array(super.buffer); }
    get HEAPF64() { return new Float64Array(super.buffer); }
    get view() { return new DataView(super.buffer); }
}
/** @public */
function extendMemory(memory) {
    if (Object.getPrototypeOf(memory) === _WebAssembly.Memory.prototype) {
        Object.setPrototypeOf(memory, Memory.prototype);
    }
    return memory;
}

function checkWebAssemblyFunction() {
    const WebAssemblyFunction = _WebAssembly.Function;
    if (typeof WebAssemblyFunction !== 'function') {
        throw new Error('WebAssembly.Function is not supported in this environment.' +
            ' If you are using V8 based browser like Chrome, try to specify' +
            ' --js-flags="--wasm-staging --experimental-wasm-stack-switching"');
    }
    return WebAssemblyFunction;
}
/** @public */
function wrapAsyncImport(f, parameterType, returnType) {
    const WebAssemblyFunction = checkWebAssemblyFunction();
    if (typeof f !== 'function') {
        throw new TypeError('Function required');
    }
    const parameters = parameterType.slice(0);
    parameters.unshift('externref');
    return new WebAssemblyFunction({ parameters, results: returnType }, f, { suspending: 'first' });
}

function copyMemory(targets, src) {
    if (targets.length === 0 || src.length === 0)
        return 0;
    let copied = 0;
    let left = src.length - copied;
    for (let i = 0; i < targets.length; ++i) {
        const target = targets[i];
        if (left < target.length) {
            target.set(src.subarray(copied, copied + left), 0);
            copied += left;
            left = 0;
            return copied;
        }
        target.set(src.subarray(copied, copied + target.length), 0);
        copied += target.length;
        left -= target.length;
    }
    return copied;
}
const _memory = new WeakMap();
const _wasi = new WeakMap();
const _fs = new WeakMap();
function getMemory(wasi) {
    return _memory.get(wasi);
}
function getFs(wasi) {
    const fs = _fs.get(wasi);
    if (!fs)
        throw new Error('filesystem is unavailable');
    return fs;
}
function handleError(err) {
    if (err instanceof WasiError) {
        return err.errno;
    }
    switch (err.code) {
        case 'ENOENT': return 44 /* WasiErrno.ENOENT */;
        case 'EBADF': return 8 /* WasiErrno.EBADF */;
        case 'EINVAL': return 28 /* WasiErrno.EINVAL */;
        case 'EPERM': return 63 /* WasiErrno.EPERM */;
        case 'EPROTO': return 65 /* WasiErrno.EPROTO */;
        case 'EEXIST': return 20 /* WasiErrno.EEXIST */;
        case 'ENOTDIR': return 54 /* WasiErrno.ENOTDIR */;
        case 'EMFILE': return 33 /* WasiErrno.EMFILE */;
        case 'EACCES': return 2 /* WasiErrno.EACCES */;
        case 'EISDIR': return 31 /* WasiErrno.EISDIR */;
        case 'ENOTEMPTY': return 55 /* WasiErrno.ENOTEMPTY */;
        case 'ENOSYS': return 52 /* WasiErrno.ENOSYS */;
    }
    throw err;
}
function defineName(name, f) {
    Object.defineProperty(f, 'name', { value: name });
    return f;
}
function syscallWrap(self, name, f) {
    return defineName(name, function () {
        let r;
        try {
            r = f.apply(self, arguments);
        }
        catch (err) {
            return handleError(err);
        }
        if (isPromiseLike(r)) {
            return r.then(_ => _, handleError);
        }
        return r;
    });
}
function resolvePathSync(fs, fileDescriptor, path, flags) {
    let resolvedPath = resolve(fileDescriptor.realPath, path);
    if ((flags & 1) === 1) {
        try {
            resolvedPath = fs.readlinkSync(resolvedPath);
        }
        catch (err) {
            if (err.code !== 'EINVAL' && err.code !== 'ENOENT') {
                throw err;
            }
        }
    }
    return resolvedPath;
}
async function resolvePathAsync(fs, fileDescriptor, path, flags) {
    let resolvedPath = resolve(fileDescriptor.realPath, path);
    if ((flags & 1) === 1) {
        try {
            resolvedPath = await fs.promises.readlink(resolvedPath);
        }
        catch (err) {
            if (err.code !== 'EINVAL' && err.code !== 'ENOENT') {
                throw err;
            }
        }
    }
    return resolvedPath;
}
// eslint-disable-next-line spaced-comment
const encoder = /*#__PURE__*/ new TextEncoder();
// eslint-disable-next-line spaced-comment
const decoder = /*#__PURE__*/ new TextDecoder();
const INT64_MAX = (BigInt(1) << BigInt(63)) - BigInt(1);
function readStdin() {
    const value = window.prompt();
    if (value === null)
        return new Uint8Array();
    const buffer = new TextEncoder().encode(value + '\n');
    return buffer;
}
function validateFstFlagsOrReturn(flags) {
    return (Boolean((flags) & -16) ||
        ((flags) & (1 /* WasiFstFlag.SET_ATIM */ | 2 /* WasiFstFlag.SET_ATIM_NOW */)) ===
            (1 /* WasiFstFlag.SET_ATIM */ | 2 /* WasiFstFlag.SET_ATIM_NOW */) ||
        ((flags) & (4 /* WasiFstFlag.SET_MTIM */ | 8 /* WasiFstFlag.SET_MTIM_NOW */)) ===
            (4 /* WasiFstFlag.SET_MTIM */ | 8 /* WasiFstFlag.SET_MTIM_NOW */));
}
class WASI$1 {
    constructor(args, env, fds, asyncFs, fs, asyncify) {
        this.args_get = syscallWrap(this, 'args_get', function (argv, argv_buf) {
            argv = Number(argv);
            argv_buf = Number(argv_buf);
            if (argv === 0 || argv_buf === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const args = wasi.args;
            for (let i = 0; i < args.length; ++i) {
                const arg = args[i];
                view.setInt32(argv, argv_buf, true);
                argv += 4;
                const data = encoder.encode(arg + '\0');
                HEAPU8.set(data, argv_buf);
                argv_buf += data.length;
            }
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.args_sizes_get = syscallWrap(this, 'args_sizes_get', function (argc, argv_buf_size) {
            argc = Number(argc);
            argv_buf_size = Number(argv_buf_size);
            if (argc === 0 || argv_buf_size === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { view } = getMemory(this);
            const wasi = _wasi.get(this);
            const args = wasi.args;
            view.setUint32(argc, args.length, true);
            view.setUint32(argv_buf_size, encoder.encode(args.join('\0') + '\0').length, true);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.environ_get = syscallWrap(this, 'environ_get', function (environ, environ_buf) {
            environ = Number(environ);
            environ_buf = Number(environ_buf);
            if (environ === 0 || environ_buf === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const env = wasi.env;
            for (let i = 0; i < env.length; ++i) {
                const pair = env[i];
                view.setInt32(environ, environ_buf, true);
                environ += 4;
                const data = encoder.encode(pair + '\0');
                HEAPU8.set(data, environ_buf);
                environ_buf += data.length;
            }
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.environ_sizes_get = syscallWrap(this, 'environ_sizes_get', function (len, buflen) {
            len = Number(len);
            buflen = Number(buflen);
            if (len === 0 || buflen === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { view } = getMemory(this);
            const wasi = _wasi.get(this);
            view.setUint32(len, wasi.env.length, true);
            view.setUint32(buflen, encoder.encode(wasi.env.join('\0') + '\0').length, true);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.clock_res_get = syscallWrap(this, 'clock_res_get', function (id, resolution) {
            resolution = Number(resolution);
            if (resolution === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { view } = getMemory(this);
            switch (id) {
                case 0 /* WasiClockid.REALTIME */:
                    view.setBigUint64(resolution, BigInt(1000000), true);
                    return 0 /* WasiErrno.ESUCCESS */;
                case 1 /* WasiClockid.MONOTONIC */:
                case 2 /* WasiClockid.PROCESS_CPUTIME_ID */:
                case 3 /* WasiClockid.THREAD_CPUTIME_ID */:
                    view.setBigUint64(resolution, BigInt(1000), true);
                    return 0 /* WasiErrno.ESUCCESS */;
                default: return 28 /* WasiErrno.EINVAL */;
            }
        });
        this.clock_time_get = syscallWrap(this, 'clock_time_get', function (id, _percision, time) {
            time = Number(time);
            if (time === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { view } = getMemory(this);
            switch (id) {
                case 0 /* WasiClockid.REALTIME */:
                    view.setBigUint64(time, BigInt(Date.now()) * BigInt(1000000), true);
                    return 0 /* WasiErrno.ESUCCESS */;
                case 1 /* WasiClockid.MONOTONIC */:
                case 2 /* WasiClockid.PROCESS_CPUTIME_ID */:
                case 3 /* WasiClockid.THREAD_CPUTIME_ID */: {
                    const t = performance.now();
                    const s = Math.trunc(t);
                    const ms = Math.floor((t - s) * 1000);
                    const result = BigInt(s) * BigInt(1000000000) + BigInt(ms) * BigInt(1000000);
                    view.setBigUint64(time, result, true);
                    return 0 /* WasiErrno.ESUCCESS */;
                }
                default: return 28 /* WasiErrno.EINVAL */;
            }
        });
        this.fd_advise = syscallWrap(this, 'fd_advise', function (_fd, _offset, _len, _advice) {
            return 52 /* WasiErrno.ENOSYS */;
        });
        this.fd_fdstat_get = syscallWrap(this, 'fd_fdstat_get', function (fd, fdstat) {
            fdstat = Number(fdstat);
            if (fdstat === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, BigInt(0), BigInt(0));
            const { view } = getMemory(this);
            view.setUint16(fdstat, fileDescriptor.type, true);
            view.setUint16(fdstat + 2, 0, true);
            view.setBigUint64(fdstat + 8, fileDescriptor.rightsBase, true);
            view.setBigUint64(fdstat + 16, fileDescriptor.rightsInheriting, true);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.fd_fdstat_set_flags = syscallWrap(this, 'fd_fdstat_set_flags', function (_fd, _flags) {
            return 52 /* WasiErrno.ENOSYS */;
        });
        this.fd_fdstat_set_rights = syscallWrap(this, 'fd_fdstat_set_rights', function (fd, rightsBase, rightsInheriting) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, BigInt(0), BigInt(0));
            if ((rightsBase | fileDescriptor.rightsBase) > fileDescriptor.rightsBase) {
                return 76 /* WasiErrno.ENOTCAPABLE */;
            }
            if ((rightsInheriting | fileDescriptor.rightsInheriting) >
                fileDescriptor.rightsInheriting) {
                return 76 /* WasiErrno.ENOTCAPABLE */;
            }
            fileDescriptor.rightsBase = rightsBase;
            fileDescriptor.rightsInheriting = rightsInheriting;
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.fd_prestat_get = syscallWrap(this, 'fd_prestat_get', function (fd, prestat) {
            prestat = Number(prestat);
            if (prestat === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            let fileDescriptor;
            try {
                fileDescriptor = wasi.fds.get(fd, BigInt(0), BigInt(0));
            }
            catch (err) {
                if (err instanceof WasiError)
                    return err.errno;
                throw err;
            }
            if (fileDescriptor.preopen !== 1)
                return 28 /* WasiErrno.EINVAL */;
            const { view } = getMemory(this);
            // preopen type is dir(0)
            view.setUint32(prestat, 0, true);
            view.setUint32(prestat + 4, encoder.encode(fileDescriptor.path).length, true);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.fd_prestat_dir_name = syscallWrap(this, 'fd_prestat_dir_name', function (fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, BigInt(0), BigInt(0));
            if (fileDescriptor.preopen !== 1)
                return 8 /* WasiErrno.EBADF */;
            const buffer = encoder.encode(fileDescriptor.path);
            const size = buffer.length;
            if (size > path_len)
                return 42 /* WasiErrno.ENOBUFS */;
            const { HEAPU8 } = getMemory(this);
            HEAPU8.set(buffer, path);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.fd_seek = syscallWrap(this, 'fd_seek', function (fd, offset, whence, newOffset) {
            newOffset = Number(newOffset);
            if (newOffset === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            if (fd === 0 || fd === 1 || fd === 2)
                return 0 /* WasiErrno.ESUCCESS */;
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_SEEK, BigInt(0));
            const r = fileDescriptor.seek(offset, whence);
            const { view } = getMemory(this);
            view.setBigUint64(newOffset, r, true);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.fd_tell = syscallWrap(this, 'fd_tell', function (fd, offset) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_TELL, BigInt(0));
            const pos = BigInt(fileDescriptor.pos);
            const { view } = getMemory(this);
            view.setBigUint64(Number(offset), pos, true);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.poll_oneoff = syscallWrap(this, 'poll_oneoff', function (in_ptr, out_ptr, nsubscriptions, nevents) {
            in_ptr = Number(in_ptr);
            out_ptr = Number(out_ptr);
            nevents = Number(nevents);
            nsubscriptions = Number(nsubscriptions);
            nsubscriptions = nsubscriptions >>> 0;
            if (in_ptr === 0 || out_ptr === 0 || nsubscriptions === 0 || nevents === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { view } = getMemory(this);
            view.setUint32(nevents, 0, true);
            let i = 0;
            let timer_userdata = BigInt(0);
            let cur_timeout = BigInt(0);
            let has_timeout = 0;
            let min_timeout = BigInt(0);
            let sub;
            const subscriptions = Array(nsubscriptions);
            for (i = 0; i < nsubscriptions; i++) {
                sub = in_ptr + i * 48;
                const userdata = view.getBigUint64(sub, true);
                const type = view.getUint8(sub + 8);
                const clockIdOrFd = view.getUint32(sub + 16, true);
                const timeout = view.getBigUint64(sub + 24, true);
                const precision = view.getBigUint64(sub + 32, true);
                const flags = view.getUint16(sub + 40, true);
                subscriptions[i] = {
                    userdata,
                    type,
                    u: {
                        clock: {
                            clock_id: clockIdOrFd,
                            timeout,
                            precision,
                            flags
                        },
                        fd_readwrite: {
                            fd: clockIdOrFd
                        }
                    }
                };
            }
            const fdevents = [];
            for (i = 0; i < nsubscriptions; i++) {
                sub = subscriptions[i];
                switch (sub.type) {
                    case 0 /* WasiEventType.CLOCK */: {
                        if (sub.u.clock.flags === 1 /* WasiSubclockflags.ABSTIME */) {
                            /* Convert absolute time to relative delay. */
                            const now = BigInt(Date.now()) * BigInt(1000000);
                            cur_timeout = sub.u.clock.timeout - now;
                        }
                        else {
                            cur_timeout = sub.u.clock.timeout;
                        }
                        if (has_timeout === 0 || cur_timeout < min_timeout) {
                            min_timeout = cur_timeout;
                            timer_userdata = sub.userdata;
                            has_timeout = 1;
                        }
                        break;
                    }
                    case 1 /* WasiEventType.FD_READ */:
                    case 2 /* WasiEventType.FD_WRITE */:
                        fdevents.push(sub);
                        break;
                    default: return 28 /* WasiErrno.EINVAL */;
                }
            }
            if (fdevents.length > 0) {
                for (i = 0; i < fdevents.length; i++) {
                    const fdevent = fdevents[i];
                    const event = out_ptr + 32 * i;
                    view.setBigUint64(event, fdevent.userdata, true);
                    view.setUint32(event + 8, 52 /* WasiErrno.ENOSYS */, true);
                    view.setUint32(event + 12, fdevent.type, true);
                    view.setBigUint64(event + 16, BigInt(0), true);
                    view.setUint16(event + 24, 0, true);
                    view.setUint32(nevents, 1, true);
                }
                view.setUint32(nevents, fdevents.length, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            if (has_timeout) {
                Number(min_timeout / BigInt(1000000));
                // } else {
                //   const buf = new SharedArrayBuffer(4)
                //   const arr = new Int32Array(buf)
                //   postMsg({
                //     __tybys_wasm_util_wasi__: {
                //       type: 'set-timeout',
                //       payload: {
                //         buffer: buf,
                //         delay
                //       }
                //     }
                //   })
                //   Atomics.wait(arr, 0, 0)
                // }
                const event = out_ptr;
                view.setBigUint64(event, timer_userdata, true);
                view.setUint32(event + 8, 0 /* WasiErrno.ESUCCESS */, true);
                view.setUint32(event + 12, 0 /* WasiEventType.CLOCK */, true);
                view.setUint32(nevents, 1, true);
            }
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.proc_exit = syscallWrap(this, 'proc_exit', function (rval) {
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.proc_raise = syscallWrap(this, 'proc_raise', function (_sig) {
            return 52 /* WasiErrno.ENOSYS */;
        });
        this.sched_yield = syscallWrap(this, 'sched_yield', function () {
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.random_get = typeof crypto !== 'undefined' && typeof crypto.getRandomValues === 'function'
            ? syscallWrap(this, 'random_get', function (buf, buf_len) {
                buf = Number(buf);
                if (buf === 0) {
                    return 28 /* WasiErrno.EINVAL */;
                }
                buf_len = Number(buf_len);
                const { HEAPU8, view } = getMemory(this);
                if ((typeof SharedArrayBuffer === 'function' && HEAPU8.buffer instanceof SharedArrayBuffer) ||
                    (Object.prototype.toString.call(HEAPU8.buffer) === '[object SharedArrayBuffer]')) {
                    for (let i = buf; i < buf + buf_len; ++i) {
                        view.setUint8(i, Math.floor(Math.random() * 256));
                    }
                    return 0 /* WasiErrno.ESUCCESS */;
                }
                let pos;
                const stride = 65536;
                for (pos = 0; pos + stride < buf_len; pos += stride) {
                    crypto.getRandomValues(HEAPU8.subarray(buf + pos, buf + pos + stride));
                }
                crypto.getRandomValues(HEAPU8.subarray(buf + pos, buf + buf_len));
                return 0 /* WasiErrno.ESUCCESS */;
            })
            : syscallWrap(this, 'random_get', function (buf, buf_len) {
                buf = Number(buf);
                if (buf === 0) {
                    return 28 /* WasiErrno.EINVAL */;
                }
                buf_len = Number(buf_len);
                const { view } = getMemory(this);
                for (let i = buf; i < buf + buf_len; ++i) {
                    view.setUint8(i, Math.floor(Math.random() * 256));
                }
                return 0 /* WasiErrno.ESUCCESS */;
            });
        this.sock_recv = syscallWrap(this, 'sock_recv', function () {
            return 58 /* WasiErrno.ENOTSUP */;
        });
        this.sock_send = syscallWrap(this, 'sock_send', function () {
            return 58 /* WasiErrno.ENOTSUP */;
        });
        this.sock_shutdown = syscallWrap(this, 'sock_shutdown', function () {
            return 58 /* WasiErrno.ENOTSUP */;
        });
        this.sock_accept = syscallWrap(this, 'sock_accept', function () {
            return 58 /* WasiErrno.ENOTSUP */;
        });
        _wasi.set(this, {
            fds,
            args,
            env
        });
        if (fs)
            _fs.set(this, fs);
        // eslint-disable-next-line @typescript-eslint/no-this-alias
        const _this = this;
        function defineImport(name, syncVersion, asyncVersion, parameterType, returnType) {
            if (asyncFs) {
                if (asyncify) {
                    _this[name] = asyncify.wrapImportFunction(syscallWrap(_this, name, asyncVersion));
                }
                else {
                    _this[name] = wrapAsyncImport(syscallWrap(_this, name, asyncVersion), parameterType, returnType);
                }
            }
            else {
                _this[name] = syscallWrap(_this, name, syncVersion);
            }
        }
        defineImport('fd_allocate', function fd_allocate(fd, offset, len) {
            const wasi = _wasi.get(this);
            const fs = getFs(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_ALLOCATE, BigInt(0));
            const stat = fs.fstatSync(fileDescriptor.fd, { bigint: true });
            if (stat.size < offset + len) {
                fs.ftruncateSync(fileDescriptor.fd, Number(offset + len));
            }
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_allocate(fd, offset, len) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_ALLOCATE, BigInt(0));
            const h = fileDescriptor.fd;
            const stat = await h.stat({ bigint: true });
            if (stat.size < offset + len) {
                await h.truncate(Number(offset + len));
            }
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i64', 'f64'], ['i32']);
        defineImport('fd_close', function fd_close(fd) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, BigInt(0), BigInt(0));
            const fs = getFs(this);
            fs.closeSync(fileDescriptor.fd);
            wasi.fds.remove(fd);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_close(fd) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, BigInt(0), BigInt(0));
            await fileDescriptor.fd.close();
            wasi.fds.remove(fd);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32'], ['i32']);
        defineImport('fd_datasync', function fd_datasync(fd) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_DATASYNC, BigInt(0));
            const fs = getFs(this);
            fs.fdatasyncSync(fileDescriptor.fd);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_datasync(fd) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_DATASYNC, BigInt(0));
            await fileDescriptor.fd.datasync();
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32'], ['i32']);
        defineImport('fd_filestat_get', function fd_filestat_get(fd, buf) {
            buf = Number(buf);
            if (buf === 0)
                return 28 /* WasiErrno.EINVAL */;
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_FILESTAT_GET, BigInt(0));
            const fs = getFs(this);
            const stat = fs.fstatSync(fileDescriptor.fd, { bigint: true });
            const { view } = getMemory(this);
            toFileStat(view, buf, stat);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_filestat_get(fd, buf) {
            buf = Number(buf);
            if (buf === 0)
                return 28 /* WasiErrno.EINVAL */;
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_FILESTAT_GET, BigInt(0));
            const h = fileDescriptor.fd;
            const stat = await h.stat({ bigint: true });
            const { view } = getMemory(this);
            toFileStat(view, buf, stat);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32'], ['i32']);
        defineImport('fd_filestat_set_size', function fd_filestat_set_size(fd, size) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_FILESTAT_SET_SIZE, BigInt(0));
            const fs = getFs(this);
            fs.ftruncateSync(fileDescriptor.fd, Number(size));
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_filestat_set_size(fd, size) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_FILESTAT_SET_SIZE, BigInt(0));
            const h = fileDescriptor.fd;
            await h.truncate(Number(size));
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i64'], ['i32']);
        function fdFilestatGetTimes(fd, atim, mtim, flags) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_FILESTAT_SET_TIMES, BigInt(0));
            if ((flags & 2 /* WasiFstFlag.SET_ATIM_NOW */) === 2 /* WasiFstFlag.SET_ATIM_NOW */) {
                atim = BigInt(Date.now() * 1000000);
            }
            if ((flags & 8 /* WasiFstFlag.SET_MTIM_NOW */) === 8 /* WasiFstFlag.SET_MTIM_NOW */) {
                mtim = BigInt(Date.now() * 1000000);
            }
            return { fileDescriptor, atim, mtim };
        }
        defineImport('fd_filestat_set_times', function fd_filestat_set_times(fd, atim, mtim, flags) {
            if (validateFstFlagsOrReturn(flags)) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { fileDescriptor, atim: atimRes, mtim: mtimRes } = fdFilestatGetTimes.call(this, fd, atim, mtim, flags);
            const fs = getFs(this);
            fs.futimesSync(fileDescriptor.fd, Number(atimRes), Number(mtimRes));
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_filestat_set_times(fd, atim, mtim, flags) {
            if (validateFstFlagsOrReturn(flags)) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { fileDescriptor, atim: atimRes, mtim: mtimRes } = fdFilestatGetTimes.call(this, fd, atim, mtim, flags);
            const h = fileDescriptor.fd;
            await h.utimes(Number(atimRes), Number(mtimRes));
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i64', 'i64', 'i32'], ['i32']);
        defineImport('fd_pread', function fd_pread(fd, iovs, iovslen, offset, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0 || offset > INT64_MAX) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_READ | WasiRights.FD_SEEK, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            let totalSize = 0;
            const ioVecs = Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                totalSize += bufLen;
                return HEAPU8.subarray(buf, buf + bufLen);
            });
            let nread = 0;
            const buffer = (() => {
                try {
                    return new Uint8Array(new SharedArrayBuffer(totalSize));
                }
                catch (_) {
                    return new Uint8Array(totalSize);
                }
            })();
            buffer._isBuffer = true;
            const fs = getFs(this);
            const bytesRead = fs.readSync(fileDescriptor.fd, buffer, 0, buffer.length, Number(offset));
            nread = buffer ? copyMemory(ioVecs, buffer.subarray(0, bytesRead)) : 0;
            view.setUint32(size, nread, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function (fd, iovs, iovslen, offset, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0 || offset > INT64_MAX) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_READ | WasiRights.FD_SEEK, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            let totalSize = 0;
            const ioVecs = Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                totalSize += bufLen;
                return HEAPU8.subarray(buf, buf + bufLen);
            });
            let nread = 0;
            const buffer = new Uint8Array(totalSize);
            buffer._isBuffer = true;
            const { bytesRead } = await fileDescriptor.fd.read(buffer, 0, buffer.length, Number(offset));
            nread = buffer ? copyMemory(ioVecs, buffer.subarray(0, bytesRead)) : 0;
            view.setUint32(size, nread, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i64', 'i32'], ['i32']);
        defineImport('fd_pwrite', function fd_pwrite(fd, iovs, iovslen, offset, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0 || offset > INT64_MAX) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_WRITE | WasiRights.FD_SEEK, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            const buffer = concatBuffer(Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                return HEAPU8.subarray(buf, buf + bufLen);
            }));
            const fs = getFs(this);
            const nwritten = fs.writeSync(fileDescriptor.fd, buffer, 0, buffer.length, Number(offset));
            view.setUint32(size, nwritten, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_pwrite(fd, iovs, iovslen, offset, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0 || offset > INT64_MAX) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_WRITE | WasiRights.FD_SEEK, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            const buffer = concatBuffer(Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                return HEAPU8.subarray(buf, buf + bufLen);
            }));
            const { bytesWritten } = await fileDescriptor.fd.write(buffer, 0, buffer.length, Number(offset));
            view.setUint32(size, bytesWritten, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i64', 'i32'], ['i32']);
        defineImport('fd_read', function fd_read(fd, iovs, iovslen, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_READ, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            let totalSize = 0;
            const ioVecs = Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                totalSize += bufLen;
                return HEAPU8.subarray(buf, buf + bufLen);
            });
            let buffer;
            let nread = 0;
            if (fd === 0) {
                if (typeof window === 'undefined' || typeof window.prompt !== 'function') {
                    return 58 /* WasiErrno.ENOTSUP */;
                }
                buffer = readStdin();
                nread = buffer ? copyMemory(ioVecs, buffer) : 0;
            }
            else {
                buffer = (() => {
                    try {
                        return new Uint8Array(new SharedArrayBuffer(totalSize));
                    }
                    catch (_) {
                        return new Uint8Array(totalSize);
                    }
                })();
                buffer._isBuffer = true;
                const fs = getFs(this);
                const bytesRead = fs.readSync(fileDescriptor.fd, buffer, 0, buffer.length, Number(fileDescriptor.pos));
                nread = buffer ? copyMemory(ioVecs, buffer.subarray(0, bytesRead)) : 0;
                fileDescriptor.pos += BigInt(nread);
            }
            view.setUint32(size, nread, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_read(fd, iovs, iovslen, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_READ, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            let totalSize = 0;
            const ioVecs = Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                totalSize += bufLen;
                return HEAPU8.subarray(buf, buf + bufLen);
            });
            let buffer;
            let nread = 0;
            if (fd === 0) {
                if (typeof window === 'undefined' || typeof window.prompt !== 'function') {
                    return 58 /* WasiErrno.ENOTSUP */;
                }
                buffer = readStdin();
                nread = buffer ? copyMemory(ioVecs, buffer) : 0;
            }
            else {
                buffer = new Uint8Array(totalSize);
                buffer._isBuffer = true;
                const { bytesRead } = await fileDescriptor.fd.read(buffer, 0, buffer.length, Number(fileDescriptor.pos));
                nread = buffer ? copyMemory(ioVecs, buffer.subarray(0, bytesRead)) : 0;
                fileDescriptor.pos += BigInt(nread);
            }
            view.setUint32(size, nread, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32'], ['i32']);
        defineImport('fd_readdir', function fd_readdir(fd, buf, buf_len, cookie, bufused) {
            buf = Number(buf);
            buf_len = Number(buf_len);
            bufused = Number(bufused);
            if (buf === 0 || bufused === 0)
                return 0 /* WasiErrno.ESUCCESS */;
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_READDIR, BigInt(0));
            const fs = getFs(this);
            const entries = fs.readdirSync(fileDescriptor.realPath, { withFileTypes: true });
            const { HEAPU8, view } = getMemory(this);
            let bufferUsed = 0;
            for (let i = Number(cookie); i < entries.length; i++) {
                const nameData = encoder.encode(entries[i].name);
                const entryInfo = fs.statSync(resolve(fileDescriptor.realPath, entries[i].name), { bigint: true });
                const entryData = new Uint8Array(24 + nameData.byteLength);
                const entryView = new DataView(entryData.buffer);
                entryView.setBigUint64(0, BigInt(i + 1), true);
                entryView.setBigUint64(8, BigInt(entryInfo.ino ? entryInfo.ino : 0), true);
                entryView.setUint32(16, nameData.byteLength, true);
                let type;
                if (entries[i].isFile()) {
                    type = 4 /* WasiFileType.REGULAR_FILE */;
                }
                else if (entries[i].isDirectory()) {
                    type = 3 /* WasiFileType.DIRECTORY */;
                }
                else if (entries[i].isSymbolicLink()) {
                    type = 7 /* WasiFileType.SYMBOLIC_LINK */;
                }
                else if (entries[i].isCharacterDevice()) {
                    type = 2 /* WasiFileType.CHARACTER_DEVICE */;
                }
                else if (entries[i].isBlockDevice()) {
                    type = 1 /* WasiFileType.BLOCK_DEVICE */;
                }
                else if (entries[i].isSocket()) {
                    type = 6 /* WasiFileType.SOCKET_STREAM */;
                }
                else {
                    type = 0 /* WasiFileType.UNKNOWN */;
                }
                entryView.setUint8(20, type);
                entryData.set(nameData, 24);
                const data = entryData.slice(0, Math.min(entryData.length, buf_len - bufferUsed));
                HEAPU8.set(data, buf + bufferUsed);
                bufferUsed += data.byteLength;
            }
            view.setUint32(bufused, bufferUsed, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_readdir(fd, buf, buf_len, cookie, bufused) {
            buf = Number(buf);
            buf_len = Number(buf_len);
            bufused = Number(bufused);
            if (buf === 0 || bufused === 0)
                return 0 /* WasiErrno.ESUCCESS */;
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_READDIR, BigInt(0));
            const fs = getFs(this);
            const entries = await fs.promises.readdir(fileDescriptor.realPath, { withFileTypes: true });
            const { HEAPU8, view } = getMemory(this);
            let bufferUsed = 0;
            for (let i = Number(cookie); i < entries.length; i++) {
                const nameData = encoder.encode(entries[i].name);
                const entryInfo = await fs.promises.stat(resolve(fileDescriptor.realPath, entries[i].name), { bigint: true });
                const entryData = new Uint8Array(24 + nameData.byteLength);
                const entryView = new DataView(entryData.buffer);
                entryView.setBigUint64(0, BigInt(i + 1), true);
                entryView.setBigUint64(8, BigInt(entryInfo.ino ? entryInfo.ino : 0), true);
                entryView.setUint32(16, nameData.byteLength, true);
                let type;
                if (entries[i].isFile()) {
                    type = 4 /* WasiFileType.REGULAR_FILE */;
                }
                else if (entries[i].isDirectory()) {
                    type = 3 /* WasiFileType.DIRECTORY */;
                }
                else if (entries[i].isSymbolicLink()) {
                    type = 7 /* WasiFileType.SYMBOLIC_LINK */;
                }
                else if (entries[i].isCharacterDevice()) {
                    type = 2 /* WasiFileType.CHARACTER_DEVICE */;
                }
                else if (entries[i].isBlockDevice()) {
                    type = 1 /* WasiFileType.BLOCK_DEVICE */;
                }
                else if (entries[i].isSocket()) {
                    type = 6 /* WasiFileType.SOCKET_STREAM */;
                }
                else {
                    type = 0 /* WasiFileType.UNKNOWN */;
                }
                entryView.setUint8(20, type);
                entryData.set(nameData, 24);
                const data = entryData.slice(0, Math.min(entryData.length, buf_len - bufferUsed));
                HEAPU8.set(data, buf + bufferUsed);
                bufferUsed += data.byteLength;
            }
            view.setUint32(bufused, bufferUsed, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i64', 'i32'], ['i32']);
        defineImport('fd_renumber', function fd_renumber(from, to) {
            const wasi = _wasi.get(this);
            wasi.fds.renumber(to, from);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_renumber(from, to) {
            const wasi = _wasi.get(this);
            await wasi.fds.renumber(to, from);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32'], ['i32']);
        defineImport('fd_sync', function fd_sync(fd) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_SYNC, BigInt(0));
            const fs = getFs(this);
            fs.fsyncSync(fileDescriptor.fd);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_sync(fd) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_SYNC, BigInt(0));
            await fileDescriptor.fd.sync();
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32'], ['i32']);
        defineImport('fd_write', function fd_write(fd, iovs, iovslen, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_WRITE, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            const buffer = concatBuffer(Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                return HEAPU8.subarray(buf, buf + bufLen);
            }));
            let nwritten;
            if (fd === 1 || fd === 2) {
                nwritten = fileDescriptor.write(buffer);
            }
            else {
                const fs = getFs(this);
                nwritten = fs.writeSync(fileDescriptor.fd, buffer, 0, buffer.length, Number(fileDescriptor.pos));
                fileDescriptor.pos += BigInt(nwritten);
            }
            view.setUint32(size, nwritten, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_write(fd, iovs, iovslen, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_WRITE, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            const buffer = concatBuffer(Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                return HEAPU8.subarray(buf, buf + bufLen);
            }));
            let nwritten;
            if (fd === 1 || fd === 2) {
                nwritten = fileDescriptor.write(buffer);
            }
            else {
                nwritten = await (await (fileDescriptor.fd.write(buffer, 0, buffer.length, Number(fileDescriptor.pos)))).bytesWritten;
                fileDescriptor.pos += BigInt(nwritten);
            }
            view.setUint32(size, nwritten, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32'], ['i32']);
        defineImport('path_create_directory', function path_create_directory(fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_CREATE_DIRECTORY, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            fs.mkdirSync(pathString);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_create_directory(fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_CREATE_DIRECTORY, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            await fs.promises.mkdir(pathString);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32'], ['i32']);
        defineImport('path_filestat_get', function path_filestat_get(fd, flags, path, path_len, filestat) {
            path = Number(path);
            path_len = Number(path_len);
            filestat = Number(filestat);
            if (path === 0 || filestat === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_FILESTAT_GET, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            const fs = getFs(this);
            pathString = resolve(fileDescriptor.realPath, pathString);
            let stat;
            if ((flags & 1) === 1) {
                stat = fs.statSync(pathString, { bigint: true });
            }
            else {
                stat = fs.lstatSync(pathString, { bigint: true });
            }
            toFileStat(view, filestat, stat);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_filestat_get(fd, flags, path, path_len, filestat) {
            path = Number(path);
            path_len = Number(path_len);
            filestat = Number(filestat);
            if (path === 0 || filestat === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_FILESTAT_GET, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            const fs = getFs(this);
            pathString = resolve(fileDescriptor.realPath, pathString);
            let stat;
            if ((flags & 1) === 1) {
                stat = await fs.promises.stat(pathString, { bigint: true });
            }
            else {
                stat = await fs.promises.lstat(pathString, { bigint: true });
            }
            toFileStat(view, filestat, stat);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i32'], ['i32']);
        defineImport('path_filestat_set_times', function path_filestat_set_times(fd, flags, path, path_len, atim, mtim, fst_flags) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0)
                return 28 /* WasiErrno.EINVAL */;
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_FILESTAT_SET_TIMES, BigInt(0));
            if (validateFstFlagsOrReturn(fst_flags)) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const fs = getFs(this);
            const resolvedPath = resolvePathSync(fs, fileDescriptor, decoder.decode(unsharedSlice(HEAPU8, path, path + path_len)), flags);
            if ((fst_flags & 2 /* WasiFstFlag.SET_ATIM_NOW */) === 2 /* WasiFstFlag.SET_ATIM_NOW */) {
                atim = BigInt(Date.now() * 1000000);
            }
            if ((fst_flags & 8 /* WasiFstFlag.SET_MTIM_NOW */) === 8 /* WasiFstFlag.SET_MTIM_NOW */) {
                mtim = BigInt(Date.now() * 1000000);
            }
            fs.utimesSync(resolvedPath, Number(atim), Number(mtim));
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_filestat_set_times(fd, flags, path, path_len, atim, mtim, fst_flags) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0)
                return 28 /* WasiErrno.EINVAL */;
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_FILESTAT_SET_TIMES, BigInt(0));
            if (validateFstFlagsOrReturn(fst_flags)) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const fs = getFs(this);
            const resolvedPath = await resolvePathAsync(fs, fileDescriptor, decoder.decode(unsharedSlice(HEAPU8, path, path + path_len)), flags);
            if ((fst_flags & 2 /* WasiFstFlag.SET_ATIM_NOW */) === 2 /* WasiFstFlag.SET_ATIM_NOW */) {
                atim = BigInt(Date.now() * 1000000);
            }
            if ((fst_flags & 8 /* WasiFstFlag.SET_MTIM_NOW */) === 8 /* WasiFstFlag.SET_MTIM_NOW */) {
                mtim = BigInt(Date.now() * 1000000);
            }
            await fs.promises.utimes(resolvedPath, Number(atim), Number(mtim));
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i64', 'i64', 'i32'], ['i32']);
        defineImport('path_link', function path_link(old_fd, old_flags, old_path, old_path_len, new_fd, new_path, new_path_len) {
            old_path = Number(old_path);
            old_path_len = Number(old_path_len);
            new_path = Number(new_path);
            new_path_len = Number(new_path_len);
            if (old_path === 0 || new_path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            let oldWrap;
            let newWrap;
            if (old_fd === new_fd) {
                oldWrap = newWrap = wasi.fds.get(old_fd, WasiRights.PATH_LINK_SOURCE | WasiRights.PATH_LINK_TARGET, BigInt(0));
            }
            else {
                oldWrap = wasi.fds.get(old_fd, WasiRights.PATH_LINK_SOURCE, BigInt(0));
                newWrap = wasi.fds.get(new_fd, WasiRights.PATH_LINK_TARGET, BigInt(0));
            }
            const { HEAPU8 } = getMemory(this);
            const fs = getFs(this);
            const resolvedOldPath = resolvePathSync(fs, oldWrap, decoder.decode(unsharedSlice(HEAPU8, old_path, old_path + old_path_len)), old_flags);
            const resolvedNewPath = resolve(newWrap.realPath, decoder.decode(unsharedSlice(HEAPU8, new_path, new_path + new_path_len)));
            fs.linkSync(resolvedOldPath, resolvedNewPath);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_link(old_fd, old_flags, old_path, old_path_len, new_fd, new_path, new_path_len) {
            old_path = Number(old_path);
            old_path_len = Number(old_path_len);
            new_path = Number(new_path);
            new_path_len = Number(new_path_len);
            if (old_path === 0 || new_path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            let oldWrap;
            let newWrap;
            if (old_fd === new_fd) {
                oldWrap = newWrap = wasi.fds.get(old_fd, WasiRights.PATH_LINK_SOURCE | WasiRights.PATH_LINK_TARGET, BigInt(0));
            }
            else {
                oldWrap = wasi.fds.get(old_fd, WasiRights.PATH_LINK_SOURCE, BigInt(0));
                newWrap = wasi.fds.get(new_fd, WasiRights.PATH_LINK_TARGET, BigInt(0));
            }
            const { HEAPU8 } = getMemory(this);
            const fs = getFs(this);
            const resolvedOldPath = await resolvePathAsync(fs, oldWrap, decoder.decode(unsharedSlice(HEAPU8, old_path, old_path + old_path_len)), old_flags);
            const resolvedNewPath = resolve(newWrap.realPath, decoder.decode(unsharedSlice(HEAPU8, new_path, new_path + new_path_len)));
            await fs.promises.link(resolvedOldPath, resolvedNewPath);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i32', 'i32', 'i32'], ['i32']);
        function pathOpen(o_flags, fs_rights_base, fs_rights_inheriting, fs_flags) {
            const read = (fs_rights_base & (WasiRights.FD_READ |
                WasiRights.FD_READDIR)) !== BigInt(0);
            const write = (fs_rights_base & (WasiRights.FD_DATASYNC |
                WasiRights.FD_WRITE |
                WasiRights.FD_ALLOCATE |
                WasiRights.FD_FILESTAT_SET_SIZE)) !== BigInt(0);
            let flags = write ? read ? 2 /* FileControlFlag.O_RDWR */ : 1 /* FileControlFlag.O_WRONLY */ : 0 /* FileControlFlag.O_RDONLY */;
            let needed_base = WasiRights.PATH_OPEN;
            let needed_inheriting = fs_rights_base | fs_rights_inheriting;
            if ((o_flags & 1 /* WasiFileControlFlag.O_CREAT */) !== 0) {
                flags |= 64 /* FileControlFlag.O_CREAT */;
                needed_base |= WasiRights.PATH_CREATE_FILE;
            }
            if ((o_flags & 2 /* WasiFileControlFlag.O_DIRECTORY */) !== 0) {
                flags |= 65536 /* FileControlFlag.O_DIRECTORY */;
            }
            if ((o_flags & 4 /* WasiFileControlFlag.O_EXCL */) !== 0) {
                flags |= 128 /* FileControlFlag.O_EXCL */;
            }
            if ((o_flags & 8 /* WasiFileControlFlag.O_TRUNC */) !== 0) {
                flags |= 512 /* FileControlFlag.O_TRUNC */;
                needed_base |= WasiRights.PATH_FILESTAT_SET_SIZE;
            }
            if ((fs_flags & 1 /* WasiFdFlag.APPEND */) !== 0) {
                flags |= 1024 /* FileControlFlag.O_APPEND */;
            }
            if ((fs_flags & 2 /* WasiFdFlag.DSYNC */) !== 0) {
                // flags |= FileControlFlag.O_DSYNC;
                needed_inheriting |= WasiRights.FD_DATASYNC;
            }
            if ((fs_flags & 4 /* WasiFdFlag.NONBLOCK */) !== 0) {
                flags |= 2048 /* FileControlFlag.O_NONBLOCK */;
            }
            if ((fs_flags & 8 /* WasiFdFlag.RSYNC */) !== 0) {
                flags |= 1052672 /* FileControlFlag.O_SYNC */;
                needed_inheriting |= WasiRights.FD_SYNC;
            }
            if ((fs_flags & 16 /* WasiFdFlag.SYNC */) !== 0) {
                flags |= 1052672 /* FileControlFlag.O_SYNC */;
                needed_inheriting |= WasiRights.FD_SYNC;
            }
            if (write && (flags & (1024 /* FileControlFlag.O_APPEND */ | 512 /* FileControlFlag.O_TRUNC */)) === 0) {
                needed_inheriting |= WasiRights.FD_SEEK;
            }
            return { flags, needed_base, needed_inheriting };
        }
        defineImport('path_open', function path_open(dirfd, dirflags, path, path_len, o_flags, fs_rights_base, fs_rights_inheriting, fs_flags, fd) {
            path = Number(path);
            fd = Number(fd);
            if (path === 0 || fd === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            path_len = Number(path_len);
            fs_rights_base = BigInt(fs_rights_base);
            fs_rights_inheriting = BigInt(fs_rights_inheriting);
            const { flags: flagsRes, needed_base: neededBase, needed_inheriting: neededInheriting } = pathOpen(o_flags, fs_rights_base, fs_rights_inheriting, fs_flags);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(dirfd, neededBase, neededInheriting);
            const memory = getMemory(this);
            const HEAPU8 = memory.HEAPU8;
            const pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            const fs = getFs(this);
            const resolved_path = resolvePathSync(fs, fileDescriptor, pathString, dirflags);
            const r = fs.openSync(resolved_path, flagsRes, 0o666);
            const filetype = wasi.fds.getFileTypeByFd(r);
            if ((o_flags & 2 /* WasiFileControlFlag.O_DIRECTORY */) !== 0 && filetype !== 3 /* WasiFileType.DIRECTORY */) {
                return 54 /* WasiErrno.ENOTDIR */;
            }
            const { base: max_base, inheriting: max_inheriting } = getRights(wasi.fds.stdio, r, flagsRes, filetype);
            const wrap = wasi.fds.insert(r, resolved_path, resolved_path, filetype, fs_rights_base & max_base, fs_rights_inheriting & max_inheriting, 0);
            const stat = fs.fstatSync(r, { bigint: true });
            if (stat.isFile()) {
                wrap.size = stat.size;
                if ((flagsRes & 1024 /* FileControlFlag.O_APPEND */) !== 0) {
                    wrap.pos = stat.size;
                }
            }
            const view = memory.view;
            view.setInt32(fd, wrap.id, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_open(dirfd, dirflags, path, path_len, o_flags, fs_rights_base, fs_rights_inheriting, fs_flags, fd) {
            path = Number(path);
            fd = Number(fd);
            if (path === 0 || fd === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            path_len = Number(path_len);
            fs_rights_base = BigInt(fs_rights_base);
            fs_rights_inheriting = BigInt(fs_rights_inheriting);
            const { flags: flagsRes, needed_base: neededBase, needed_inheriting: neededInheriting } = pathOpen(o_flags, fs_rights_base, fs_rights_inheriting, fs_flags);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(dirfd, neededBase, neededInheriting);
            const memory = getMemory(this);
            const HEAPU8 = memory.HEAPU8;
            const pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            const fs = getFs(this);
            const resolved_path = await resolvePathAsync(fs, fileDescriptor, pathString, dirflags);
            const r = await fs.promises.open(resolved_path, flagsRes, 0o666);
            const filetype = await wasi.fds.getFileTypeByFd(r);
            if ((o_flags & 2 /* WasiFileControlFlag.O_DIRECTORY */) !== 0 && filetype !== 3 /* WasiFileType.DIRECTORY */) {
                return 54 /* WasiErrno.ENOTDIR */;
            }
            const { base: max_base, inheriting: max_inheriting } = getRights(wasi.fds.stdio, r.fd, flagsRes, filetype);
            const wrap = wasi.fds.insert(r, resolved_path, resolved_path, filetype, fs_rights_base & max_base, fs_rights_inheriting & max_inheriting, 0);
            const stat = await r.stat({ bigint: true });
            if (stat.isFile()) {
                wrap.size = stat.size;
                if ((flagsRes & 1024 /* FileControlFlag.O_APPEND */) !== 0) {
                    wrap.pos = stat.size;
                }
            }
            const view = memory.view;
            view.setInt32(fd, wrap.id, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i32', 'i64', 'i64', 'i32', 'i32'], ['i32']);
        defineImport('path_readlink', function path_readlink(fd, path, path_len, buf, buf_len, bufused) {
            path = Number(path);
            path_len = Number(path_len);
            buf = Number(buf);
            buf_len = Number(buf_len);
            bufused = Number(bufused);
            if (path === 0 || buf === 0 || bufused === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_READLINK, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            const link = fs.readlinkSync(pathString);
            const linkData = encoder.encode(link);
            const len = Math.min(linkData.length, buf_len);
            if (len >= buf_len)
                return 42 /* WasiErrno.ENOBUFS */;
            HEAPU8.set(linkData.subarray(0, len), buf);
            HEAPU8[buf + len] = 0;
            view.setUint32(bufused, len, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_readlink(fd, path, path_len, buf, buf_len, bufused) {
            path = Number(path);
            path_len = Number(path_len);
            buf = Number(buf);
            buf_len = Number(buf_len);
            bufused = Number(bufused);
            if (path === 0 || buf === 0 || bufused === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_READLINK, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            const link = await fs.promises.readlink(pathString);
            const linkData = encoder.encode(link);
            const len = Math.min(linkData.length, buf_len);
            if (len >= buf_len)
                return 42 /* WasiErrno.ENOBUFS */;
            HEAPU8.set(linkData.subarray(0, len), buf);
            HEAPU8[buf + len] = 0;
            view.setUint32(bufused, len, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i32', 'i32'], ['i32']);
        defineImport('path_remove_directory', function path_remove_directory(fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_REMOVE_DIRECTORY, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            fs.rmdirSync(pathString);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_remove_directory(fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_REMOVE_DIRECTORY, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            await fs.promises.rmdir(pathString);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32'], ['i32']);
        defineImport('path_rename', function path_rename(old_fd, old_path, old_path_len, new_fd, new_path, new_path_len) {
            old_path = Number(old_path);
            old_path_len = Number(old_path_len);
            new_path = Number(new_path);
            new_path_len = Number(new_path_len);
            if (old_path === 0 || new_path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            let oldWrap;
            let newWrap;
            if (old_fd === new_fd) {
                oldWrap = newWrap = wasi.fds.get(old_fd, WasiRights.PATH_RENAME_SOURCE | WasiRights.PATH_RENAME_TARGET, BigInt(0));
            }
            else {
                oldWrap = wasi.fds.get(old_fd, WasiRights.PATH_RENAME_SOURCE, BigInt(0));
                newWrap = wasi.fds.get(new_fd, WasiRights.PATH_RENAME_TARGET, BigInt(0));
            }
            const { HEAPU8 } = getMemory(this);
            const resolvedOldPath = resolve(oldWrap.realPath, decoder.decode(unsharedSlice(HEAPU8, old_path, old_path + old_path_len)));
            const resolvedNewPath = resolve(newWrap.realPath, decoder.decode(unsharedSlice(HEAPU8, new_path, new_path + new_path_len)));
            const fs = getFs(this);
            fs.renameSync(resolvedOldPath, resolvedNewPath);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_rename(old_fd, old_path, old_path_len, new_fd, new_path, new_path_len) {
            old_path = Number(old_path);
            old_path_len = Number(old_path_len);
            new_path = Number(new_path);
            new_path_len = Number(new_path_len);
            if (old_path === 0 || new_path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            let oldWrap;
            let newWrap;
            if (old_fd === new_fd) {
                oldWrap = newWrap = wasi.fds.get(old_fd, WasiRights.PATH_RENAME_SOURCE | WasiRights.PATH_RENAME_TARGET, BigInt(0));
            }
            else {
                oldWrap = wasi.fds.get(old_fd, WasiRights.PATH_RENAME_SOURCE, BigInt(0));
                newWrap = wasi.fds.get(new_fd, WasiRights.PATH_RENAME_TARGET, BigInt(0));
            }
            const { HEAPU8 } = getMemory(this);
            const resolvedOldPath = resolve(oldWrap.realPath, decoder.decode(unsharedSlice(HEAPU8, old_path, old_path + old_path_len)));
            const resolvedNewPath = resolve(newWrap.realPath, decoder.decode(unsharedSlice(HEAPU8, new_path, new_path + new_path_len)));
            const fs = getFs(this);
            await fs.promises.rename(resolvedOldPath, resolvedNewPath);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i32', 'i32'], ['i32']);
        defineImport('path_symlink', function path_symlink(old_path, old_path_len, fd, new_path, new_path_len) {
            old_path = Number(old_path);
            old_path_len = Number(old_path_len);
            new_path = Number(new_path);
            new_path_len = Number(new_path_len);
            if (old_path === 0 || new_path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_SYMLINK, BigInt(0));
            const oldPath = decoder.decode(unsharedSlice(HEAPU8, old_path, old_path + old_path_len));
            let newPath = decoder.decode(unsharedSlice(HEAPU8, new_path, new_path + new_path_len));
            newPath = resolve(fileDescriptor.realPath, newPath);
            const fs = getFs(this);
            fs.symlinkSync(oldPath, newPath);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_symlink(old_path, old_path_len, fd, new_path, new_path_len) {
            old_path = Number(old_path);
            old_path_len = Number(old_path_len);
            new_path = Number(new_path);
            new_path_len = Number(new_path_len);
            if (old_path === 0 || new_path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_SYMLINK, BigInt(0));
            const oldPath = decoder.decode(unsharedSlice(HEAPU8, old_path, old_path + old_path_len));
            let newPath = decoder.decode(unsharedSlice(HEAPU8, new_path, new_path + new_path_len));
            newPath = resolve(fileDescriptor.realPath, newPath);
            const fs = getFs(this);
            await fs.promises.symlink(oldPath, newPath);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i32'], ['i32']);
        defineImport('path_unlink_file', function path_unlink_file(fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_UNLINK_FILE, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            fs.unlinkSync(pathString);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_unlink_file(fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_UNLINK_FILE, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            await fs.promises.unlink(pathString);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32'], ['i32']);
        this._setMemory = function setMemory(m) {
            if (!(m instanceof _WebAssembly.Memory)) {
                throw new TypeError('"instance.exports.memory" property must be a WebAssembly.Memory');
            }
            _memory.set(_this, extendMemory(m));
        };
    }
    static createSync(args, env, preopens, stdio, fs, print, printErr) {
        const fds = new SyncTable({
            size: 3,
            in: stdio[0],
            out: stdio[1],
            err: stdio[2],
            fs,
            print,
            printErr
        });
        const _this = new WASI$1(args, env, fds, false, fs);
        if (preopens.length > 0) {
            for (let i = 0; i < preopens.length; ++i) {
                const realPath = fs.realpathSync(preopens[i].realPath, 'utf8');
                const fd = fs.openSync(realPath, 'r', 0o666);
                fds.insertPreopen(fd, preopens[i].mappedPath, realPath);
            }
        }
        return _this;
    }
    static async createAsync(args, env, preopens, stdio, fs, print, printErr, asyncify) {
        const fds = new AsyncTable({
            size: 3,
            in: stdio[0],
            out: stdio[1],
            err: stdio[2],
            print,
            printErr
        });
        const _this = new WASI$1(args, env, fds, true, fs, asyncify);
        if (preopens.length > 0) {
            for (let i = 0; i < preopens.length; ++i) {
                const entry = preopens[i];
                const realPath = await fs.promises.realpath(entry.realPath);
                const fd = await fs.promises.open(realPath, 'r', 0o666);
                await fds.insertPreopen(fd, entry.mappedPath, realPath);
            }
        }
        return _this;
    }
}

// eslint-disable-next-line spaced-comment
const kEmptyObject = /*#__PURE__*/ Object.freeze(/*#__PURE__*/ Object.create(null));
const kExitCode = Symbol('kExitCode');
const kSetMemory = Symbol('kSetMemory');
const kStarted = Symbol('kStarted');
const kInstance = Symbol('kInstance');
const kBindingName = Symbol('kBindingName');
function setupInstance(self, instance) {
    validateObject(instance, 'instance');
    validateObject(instance.exports, 'instance.exports');
    self[kInstance] = instance;
    self[kSetMemory](instance.exports.memory);
}
function validateOptions(options) {
    var _a;
    validateObject(options, 'options');
    let _WASI;
    if (options.version !== undefined) {
        validateString(options.version, 'options.version');
        switch (options.version) {
            case 'unstable':
                _WASI = WASI$1;
                this[kBindingName] = 'wasi_unstable';
                break;
            case 'preview1':
                _WASI = WASI$1;
                this[kBindingName] = 'wasi_snapshot_preview1';
                break;
            default:
                throw new TypeError(`unsupported WASI version "${options.version}"`);
        }
    }
    else {
        _WASI = WASI$1;
        this[kBindingName] = 'wasi_snapshot_preview1';
    }
    if (options.args !== undefined) {
        validateArray(options.args, 'options.args');
    }
    const args = ((_a = options.args) !== null && _a !== void 0 ? _a : []).map(String);
    const env = [];
    if (options.env !== undefined) {
        validateObject(options.env, 'options.env');
        Object.entries(options.env).forEach(({ 0: key, 1: value }) => {
            if (value !== undefined) {
                env.push(`${key}=${value}`);
            }
        });
    }
    const preopens = [];
    if (options.preopens !== undefined) {
        validateObject(options.preopens, 'options.preopens');
        Object.entries(options.preopens).forEach(({ 0: key, 1: value }) => preopens.push({ mappedPath: String(key), realPath: String(value) }));
    }
    if (preopens.length > 0) {
        if (options.fs === undefined) {
            throw new Error('filesystem is disabled, can not preopen directory');
        }
        try {
            validateObject(options.fs, 'options.fs');
        }
        catch (_) {
            throw new TypeError('Node.js fs like implementation is not provided');
        }
    }
    // if (options.filesystem !== undefined) {
    //   validateObject(options.filesystem, 'options.filesystem')
    //   validateString(options.filesystem.type, 'options.filesystem.type')
    //   if (options.filesystem.type !== 'memfs' && options.filesystem.type !== 'file-system-access-api') {
    //     throw new Error(`Filesystem type ${(options.filesystem as any).type as string} is not supported, only "memfs" and "file-system-access-api" is supported currently`)
    //   }
    //   try {
    //     validateObject(options.filesystem.fs, 'options.filesystem.fs')
    //   } catch (_) {
    //     throw new Error('Node.js fs like implementation is not provided')
    //   }
    // }
    if (options.print !== undefined)
        validateFunction(options.print, 'options.print');
    if (options.printErr !== undefined)
        validateFunction(options.printErr, 'options.printErr');
    if (options.returnOnExit !== undefined) {
        validateBoolean(options.returnOnExit, 'options.returnOnExit');
    }
    // const { stdin = 0, stdout = 1, stderr = 2 } = options
    // validateInt32(stdin, 'options.stdin', 0)
    // validateInt32(stdout, 'options.stdout', 0)
    // validateInt32(stderr, 'options.stderr', 0)
    // const stdio = [stdin, stdout, stderr] as const
    const stdio = [0, 1, 2];
    return {
        args,
        env,
        preopens,
        stdio,
        _WASI
    };
}
function initWASI(setMemory, wrap) {
    this[kSetMemory] = setMemory;
    this.wasiImport = wrap;
    this[kStarted] = false;
    this[kExitCode] = 0;
    this[kInstance] = undefined;
}
/** @public */
class WASI {
    constructor(options = kEmptyObject) {
        const { args, env, preopens, stdio, _WASI } = validateOptions.call(this, options);
        const wrap = _WASI.createSync(args, env, preopens, stdio, options.fs, options.print, options.printErr);
        const setMemory = wrap._setMemory;
        delete wrap._setMemory;
        initWASI.call(this, setMemory, wrap);
        if (options.returnOnExit) {
            wrap.proc_exit = wasiReturnOnProcExit.bind(this);
        }
    }
    // Must not export _initialize, must export _start
    start(instance) {
        if (this[kStarted]) {
            throw new Error('WASI instance has already started');
        }
        this[kStarted] = true;
        setupInstance(this, instance);
        const { _start, _initialize } = this[kInstance].exports;
        validateFunction(_start, 'instance.exports._start');
        validateUndefined(_initialize, 'instance.exports._initialize');
        let ret;
        try {
            ret = _start();
        }
        catch (err) {
            if (err !== kExitCode) {
                throw err;
            }
        }
        if (ret instanceof Promise) {
            return ret.then(() => this[kExitCode], (err) => {
                if (err !== kExitCode) {
                    throw err;
                }
                return this[kExitCode];
            });
        }
        return this[kExitCode];
    }
    // Must not export _start, may optionally export _initialize
    initialize(instance) {
        if (this[kStarted]) {
            throw new Error('WASI instance has already started');
        }
        this[kStarted] = true;
        setupInstance(this, instance);
        const { _start, _initialize } = this[kInstance].exports;
        validateUndefined(_start, 'instance.exports._start');
        if (_initialize !== undefined) {
            validateFunction(_initialize, 'instance.exports._initialize');
            return _initialize();
        }
    }
    getImportObject() {
        return { [this[kBindingName]]: this.wasiImport };
    }
}
function wasiReturnOnProcExit(rval) {
    this[kExitCode] = rval;
    // eslint-disable-next-line @typescript-eslint/no-throw-literal
    throw kExitCode;
}

var fsProxy = {};

var hasRequiredFsProxy;

function requireFsProxy () {
	if (hasRequiredFsProxy) return fsProxy;
	hasRequiredFsProxy = 1;
	// @ts-check

	/**
	 * @param {unknown} value
	 */
	const getType = (value) => {
	  if (value === undefined) return 0
	  if (value === null) return 1
	  const t = typeof value;
	  if (t === 'boolean') return 2
	  if (t === 'number') return 3
	  if (t === 'string') return 4
	  if (t === 'object') return 6
	  if (t === 'bigint') return 9
	  return -1
	};

	/**
	 * @param {import('memfs').IFs} memfs
	 * @param {any} value
	 * @param {ReturnType<typeof getType>} type
	 * @returns {Uint8Array}
	 */
	const encodeValue = (memfs, value, type) => {
	  switch (type) {
	    case 0:
	    case 1:
	      return new Uint8Array(0)
	    case 2: {
	      const view = new Int32Array(1);
	      view[0] = value ? 1 : 0;
	      return new Uint8Array(view.buffer)
	    }
	    case 3: {
	      const view = new Float64Array(1);
	      view[0] = value;
	      return new Uint8Array(view.buffer)
	    }
	    case 4: {
	      const view = new TextEncoder().encode(value);
	      return view
	    }
	    case 6: {
	      const [entry] = Object.entries(memfs).filter(([_, v]) => v === value.constructor)[0] ?? [];
	      if (entry) {
	        Object.defineProperty(value, '__constructor__', {
	          configurable: true,
	          writable: true,
	          enumerable: true,
	          value: entry
	        });
	      }

	      const json = JSON.stringify(value, (_, value) => {
	        if (typeof value === 'bigint') {
	          return `BigInt(${String(value)})`
	        }
	        if (value instanceof Error) {
	          return {
	            ...value,
	            message: value.message,
	            stack: value.stack,
	            __error__: value.constructor.name,
	          }
	        }
	        return value
	      });
	      const view = new TextEncoder().encode(json);
	      return view
	    }
	    case 9: {
	      const view = new BigInt64Array(1);
	      view[0] = value;
	      return new Uint8Array(view.buffer)
	    }
	    case -1:
	    default:
	      throw new Error('unsupported data')
	  }
	};

	/**
	 * @param {typeof import('memfs')} memfs
	 * @param {Uint8Array} payload
	 * @param {number} type
	 * @returns {any}
	 */
	const decodeValue = (memfs, payload, type) => {
	  if (type === 0) return undefined
	  if (type === 1) return null
	  if (type === 2) return Boolean(payload[0])
	  if (type === 3) return new Float64Array(payload.buffer, payload.byteOffset, 1)[0]
	  if (type === 4) return new TextDecoder().decode(payload.slice())
	  if (type === 6) {
	    const obj = JSON.parse(new TextDecoder().decode(payload.slice()), (_key, value) => {
	      if (typeof value === 'string') {
	        const matched = value.match(/^BigInt\((-?\d+)\)$/);
	        if (matched && matched[1]) {
	          return BigInt(matched[1])
	        }
	      }
	      return value
	    });
	    if (obj.__constructor__) {
	      const ctor = obj.__constructor__;
	      delete obj.__constructor__;
	      Object.setPrototypeOf(obj, memfs[ctor].prototype);
	    }
	    if (obj.__error__) {
	      const name = obj.__error__;
	      const ErrorConstructor = globalThis[name] || Error;
	      delete obj.__error__;
	      const err = new ErrorConstructor(obj.message);
	      Object.defineProperty(err, 'stack', {
	        configurable: true,
	        enumerable: false,
	        writable: true,
	        value: err.stack
	      });
	      Object.defineProperty(err, Symbol.toStringTag, {
	        configurable: true,
	        enumerable: false,
	        writable: true,
	        value: name
	      });
	      for (const [k, v] of Object.entries(obj)) {
	        if (k === 'message' || k === 'stack') continue
	        err[k] = v;
	      }
	      return err
	    }
	    return obj
	  }
	  if (type === 9) return new BigInt64Array(payload.buffer, payload.byteOffset, 1)[0]
	  throw new Error('unsupported data')
	};

	/**
	 * @param {import('memfs').IFs} fs
	 * @returns {(e: { data: { __fs__: { sab: Int32Array, type: keyof import('memfs').IFs, payload: any[] } } }) => void}
	 */
	// oxlint-disable-next-line no-unused-vars -- fixed in an upcoming release
	fsProxy.createOnMessage = (fs) => function onMessage(e) {
	  if (e.data.__fs__) {
	    /**
	     * 0..4                    status(int32_t):        21(waiting) 0(success) 1(error)
	     * 5..8                    type(napi_valuetype):   0(undefined) 1(null) 2(boolean) 3(number) 4(string) 6(jsonstring) 9(bigint) -1(unsupported)
	     * 9..16                   payload_size(uint32_t)  <= 1024
	     * 16..16 + payload_size   payload_content
	     */
	    const { sab, type, payload } = e.data.__fs__;
	    const fn = fs[type];
	    try {
	      const ret = fn.apply(fs, payload);
	      Atomics.store(sab, 0, 0);
	      const t = getType(ret);
	      Atomics.store(sab, 1, t);
	      const v = encodeValue(fs, ret, t);
	      Atomics.store(sab, 2, v.length);
	      new Uint8Array(sab.buffer).set(v, 16);

	    } catch (/** @type {any} */ err) {
	      Atomics.store(sab, 0, 1);
	      const t = getType(err);
	      Atomics.store(sab, 1, t);
	      const v = encodeValue(fs, err, t);
	      Atomics.store(sab, 2, v.length);
	      new Uint8Array(sab.buffer).set(v, 16);
	    } finally {
	      Atomics.notify(sab, 0);
	    }
	  }
	};

	/**
	 * @param {typeof import('memfs')} memfs
	 */
	fsProxy.createFsProxy = (memfs) => new Proxy({}, {
	  get (_target, p, _receiver) {
	    /**
	     * @param {any[]} args
	     */
	    return function (...args) {
	      const sab = new SharedArrayBuffer(16 + 10240);
	      const i32arr = new Int32Array(sab);
	      Atomics.store(i32arr, 0, 21);

	      postMessage({
	        __fs__: {
	          sab: i32arr,
	          type: p,
	          payload: args
	        }
	      });

	      Atomics.wait(i32arr, 0, 21);

	      const status = Atomics.load(i32arr, 0);
	      const type = Atomics.load(i32arr, 1);
	      const size = Atomics.load(i32arr, 2);
	      const content = new Uint8Array(sab, 16, size);
	      const value = decodeValue(memfs, content, type);
	      if (status === 1) {
	        throw value
	      }
	      return value
	    }
	  }
	});
	return fsProxy;
}

var fsProxyExports = requireFsProxy();

var createFsProxy = fsProxyExports.createFsProxy;
var createOnMessage = fsProxyExports.createOnMessage;
export { MessageHandler, WASI, createFsProxy, createOnMessage, getDefaultContext, instantiateNapiModule, instantiateNapiModuleSync };
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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