import type { Comment, Literal, ElementContent, RootContent, Properties } from 'hast';
import type { RehypeAttrsOptions } from './index.js';
export declare const getURLParameters: (url?: string) => Record<string, string | number | boolean>;
export declare const prevChild: (data: Literal[] | undefined, index: number) => Comment | undefined;
export declare const nextChild: (data: RootContent[] | ElementContent[] | undefined, index: number, tagName?: string, codeBlockParames?: boolean) => ElementContent | undefined;
/**
 * 获取代码注视的位置
 * @param data 数据
 * @param index 当前数据所在的位置
 * @returns 返回 当前参数数据 Object，`{}`
 */
export declare const getCommentObject: ({ value }: Comment) => Properties;
export type DataConfig = {
    'data-config': Properties;
};
export declare const propertiesHandle: (defaultAttrs?: Properties | null, attrs?: Properties, type?: RehypeAttrsOptions['properties']) => Properties | DataConfig;
