"use client";
import Layout from "@/components/Layout/LayoutAdmin";
import StatusCard from "@/components/StatusCard";
import StatusScale from "@/components/StatusScale";
import Image from "next/image";
import { registered, published, count, revenue, positive, colorview } from '@/assets/images';
import { useAuth } from "@/context/AuthContext";
import { useEffect, useState } from "react";
import axios from "axios";
import { formatDateWithOrdinal } from "@/utils/dateFormat";

export default function Dashboard() {
  const { user, loading } = useAuth();
  const [results, setResults] = useState([]);
  const [resultsactivities, setResultsActivities] = useState([]);
  console.log("User in Dashboard:", user);
  
  useEffect(() => {
    const fetchData = async () => {
      const apiUrl = process.env.NEXT_PUBLIC_API_URL;
      console.log("API URL:", apiUrl + "/getdata/admin");
      
      try {
        const response = await axios.get(`${apiUrl}/getdata/admin`, {
          headers: {
            Authorization: `Bearer ${user?.token}`
          }
        });
        console.log("Fetched data:", response.data);
        setResults(response.data || []);
      } catch (err) {
        setResults([]);
      }
    };
    const fetchActivities = async () => {
      const apiUrl = process.env.NEXT_PUBLIC_API_URL;
      console.log("API URL:", apiUrl + "/getdata/activity-log");
      
      try {
        const response = await axios.get(`${apiUrl}/getdata/activity-log`, {
          headers: {
            Authorization: `Bearer ${user?.token}`
          }
        });
        console.log("Fetched logs:", response.data);
        setResultsActivities(response.data || []);
      } catch (err) {
        setResultsActivities([]);
      }
    };
    if (user?.token) {
      fetchData();
      fetchActivities();
    }
  }, [user]);

  // Dummy activities for now (replace with API data if available)
  // useEffect(() => {
  //   setResultsActivities([
  //     { id: 1, slno: 1, name: 'Noah', title: 'Uploaded book- The Old Man and the Sea', uploaddate: 'April 28, 2025 - 10:30 AM', ip: '107.193.6.21' },
  //     { id: 2, slno: 2, name: 'Oliver', title: 'Flagged a false positive- Segment matched in youtube.com/abc123 ', uploaddate: 'April 27, 2025 - 11:00 AM ', ip: '204.155.47.16' },
  //     { id: 3, slno: 3, name: 'James', title: 'Subscribed to plan- Premium – Annual', uploaddate: 'April 27, 2025 - 11:30 AM', ip: '141.156.99.165' },
  //     { id: 4, slno: 4, name: 'Theodore', title: 'Applied coupon code- SPRING25', uploaddate: 'April 29, 2025 - 11:30 AM', ip: '71.193.110.178' },
  //     { id: 5, slno: 5, name: 'Evelyn', title: 'Deleted uploaded content- Mockingbird Draft v2', uploaddate: 'April 28, 2025 - 11:30 AM', ip: '80.215.46.98' }
  //   ]);
  // }, []);

  const renderUserType = (type) => {
    if (!type) return '';
    switch (type.toLowerCase()) {
      case 'pu':
        return 'Publisher';
      case 'au':
        return 'Author';
      default:
        return type;
    }
  };

  if (loading) return <div>Loading...</div>;
  if (!user) return <div className="text-center py-10 text-lg">Please log in as admin to view this page.</div>;

  const quickCards = [
    { title: 'Total Registered Author ', result: 400, icon: registered },
    { title: 'Total Published Content', result: 27, icon: published },
    { title: 'Active Subscription Count', result: 8, icon: count },
    { title: 'Monthly Revenue / Income Summery', result: '$1000.00', icon: revenue },
    { title: 'False positive detected', result: 20, icon: positive }
  ];

  return (
    <Layout>
      <div className="max-w-5xl mx-auto my-10">
        <ul className="flex flex-wrap -mx-2.5 mt-5 mb-10">
          {quickCards.map((card, c) => (
            <li
              key={c}
              className={`w-full xs:w-1/2 ${c === 3 ? 'md:w-1/2' : 'md:w-1/3'} p-2.5`}
            >
              <StatusCard data={card} />
            </li>
          ))}
        </ul>
        <div className="flex flex-col xs:flex-row xs:items-center py-4.5 gap-4 xs:justify-between">
          <h3 className="font-semibold text-[#373737] text-2xl">Recent Books Uploaded</h3>
          <a href="/content-management" className="bg-emerald-500 text-white text-sm font-medium px-5 leading-[56px] rounded-md hover:bg-emerald-600 transition"> More Details</a>
        </div>
        <div className="table_wpr pb-5">
          <div className="relative overflow-x-auto">
            <table className="glob_table">
              <thead>
                <tr>
                  <th>Sl. No</th>
                  <th>User Name</th>
                  <th>Content Title</th>
                  <th>No. of Scans</th>
                  <th>Upload Date</th>
                  <th>User Type</th>
                  <th>Scan Result</th>
                </tr>
              </thead>
              <tbody>
                {results.length === 0 ? (
                  <tr>
                    <td colSpan={7} className="text-center">Loading...</td>
                  </tr>
                ) : (
                  results.slice(0, 5).map((result, r) => (
                    <tr key={r}>
                      <td className="max-w-32">{result.slno || r + 1}</td>
                      <td className="max-w-32">{result.user?.name || ''}</td>
                      <td>{result.title}</td>
                      <td>{result.rescan}</td>
                      <td>
                        {result.uploadDate ? formatDateWithOrdinal(result.uploadDate) : ""}
                      </td>
                      <td>{renderUserType(result.user?.userType)}</td>
                      <td>
                        <a href={`/content-library-view?bookid=${result.itemid}`}>
                          <span className='flex items-center text-[#04B47D]'>
                            <Image src={colorview} className='me-2' alt="" />
                            View
                          </span>
                        </a>
                      </td>
                    </tr>
                  ))
                )}
              </tbody>
            </table>
          </div>
        </div>
        <h3 className="mb-5 font-semibold text-[#373737] text-2xl">Recent Activities</h3>
        <div className="table_wpr pb-5">
          <div className="relative overflow-x-auto">
            <table className="glob_table">
              <thead>
                <tr>
                  <th>Sl. No</th>
                  <th>User Name</th>
                  <th>Activity</th>
                  <th>Date/Time</th>
                  <th>IP Address</th>
                </tr>
              </thead>
              <tbody>
                {resultsactivities.map((activity, r) => (
                  <tr key={r}>
                    <td className="max-w-32">{r + 1}</td>
                    <td className="max-w-32">{activity.user?.name}</td>
                    <td>{activity.details}</td>
                    <td>
                      {activity.timestamp ? formatDateWithOrdinal(activity.timestamp) : ""}
                    </td>
                    <td>{activity.ip}</td>
                  </tr>
                ))}
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </Layout>
  );
}