
'use client'
import { useState } from 'react';
import Layout from "@/components/Layout/LayoutAdmin";
import StatusCard from "@/components/StatusCard";
import Image from "next/image";
import {search, EyeIcon, trashIcon, edit, totalreports,pendingreview,confirmpositive, imgnotfound } from '@/assets/images'
export default function Reviews() {

  const quickCards = [
    {
      title: 'Total Reports ',
      result: 76,
      icon: totalreports
    },
    {
      title: 'Pending review',
      result: 28,
      icon: pendingreview
    },
    {
      title: 'Confirm False positive',
      result: 18,
      icon: confirmpositive
    },
    
  ]

  const [activeTab, setActiveTab] = useState('All Books');

  const tabs = ['All Reprts', 'Pending', 'Confirmed', 'Rejected'];

  return (
    <Layout>
        <div className="max-w-full mx-auto my-10">
            
             <ul className="flex flex-wrap -mx-2.5 mt-5 mb-10">
                     {
                       quickCards.map((card, c) => (
                         <li
                           key={c}
                           className={`w-full xs:w-1/2 ${c === 3 ? 'md:w-1/2' : 'md:w-1/3'} p-2.5`}
                         >
                           <StatusCard data={card} />
                         </li>
                       ))
                     }
                  </ul>
          
            <div className="flex gap-4 mb-5">
                {tabs.map((tab) => (
                <button
                key={tab}
                onClick={() => setActiveTab(tab)}
                className={`px-5 py-2 rounded-md text-sm font-medium border transition-colors duration-200
                    ${activeTab === tab
                    ? 'bg-emerald-500 text-white border-emerald-500'
                    : 'bg-white text-gray-700 border-gray-300 hover:border-emerald-400'}`}
                >
                {tab}
                </button>
               ))}
            </div>
                 <div className="flex items-center w-full max-w-full space-x-2 mb-5">
                                 <div className="flex items-center flex-grow border border-gray-300 rounded-md px-3">
                                 <Image src={search} width={'auto'}  alt="search"/>
                                     <input
                                     type="text"
                                     placeholder="Search By Name/Email/Plan"
                                     className="w-full pl-2 text-sm placeholder-gray-400 focus:outline-none leading-[56px]"
                                     />
                                 </div>
                                 <button className="bg-emerald-500 text-white text-sm font-medium px-5 leading-[56px] rounded-md hover:bg-emerald-600 transition">
                                     Search
                                 </button>
                  </div>
                  <h3 className="mb-5 font-semibold text-[#373737] text-2xl">Books</h3>
                   
                   <div className='border border-[#E8E8E8]'>
                     <div className='bg-[#ECEFF6] h-[44px] w-full'></div>
                      <div className='text-center p-14'>
                         <Image src={imgnotfound} className='mx-auto' alt="book-not-found"/>
                         <p className='pt-5'>Not found any kind of reports</p>
                      </div>
                   </div>

                 <div className="flex justify-end mt-8"><ul className="flex items-center space-x-2"><li className="w-8 h-8 border border-[#c9c9c9] flex items-center justify-center bg-white text-black text-sm font-medium rounded cursor-pointer">1</li><li className="w-8 h-8 border border-[#c9c9c9] flex items-center justify-center bg-primary text-white text-sm font-medium rounded cursor-pointer">2</li><li className="w-8 h-8 border border-[#c9c9c9] flex items-center justify-center bg-white text-black text-sm font-medium rounded cursor-pointer">3</li><li className="w-8 h-8 border border-[#c9c9c9] flex items-center justify-center bg-white text-black text-sm font-medium rounded cursor-pointer">4</li><li className="px-5 h-8 border border-[#c9c9c9] flex items-center justify-center bg-white text-black text-sm font-medium rounded cursor-pointer">Next</li></ul></div>
        




                
        </div>
    </Layout>
  );
}