"use client"
import { useState } from "react";
import axios from "axios";
import { useAuth } from "@/context/AuthContext";


export default function BookUplad() {
    const [file, setFile] = useState(null);
    const [message, setMessage] = useState("");
    const [title, setTitle] = useState("");
    const [author, setAuthor] = useState("");
    const [publisher, setPublisher] = useState("");
    const [keywords, setKeywords] = useState("");
    const { user, loading } = useAuth();
    console.log("User:", user);
    const authID = user ? user.userId : 0; // Default to 0 if user is not authenticated
    if (loading) return <div>Loading...</div>; // Handle loading state
    console.log("Auth ID:", authID);

    const handleFileChange = (e) => {
        console.log('File selected:', e.target.files[0]);
        if (e.target.files.length === 0) {
            alert("No file selected.");
            return;
        }

        setFile(e.target.files[0]);
    };

    const handleSubmit = async (e) => {
        e.preventDefault();
        if (!file) {
            setMessage("Please select a file first.");
            return;
        }

        const formData = new FormData();
        formData.append("file", file);
        formData.append("title", title);
        formData.append("author", author);
        formData.append("publisher", publisher);
        formData.append("keywords", keywords);
        formData.append("authID", authID);

        try {
            const apiUrl = process.env.NEXT_PUBLIC_API_URL;
            const response = await axios.post(`${apiUrl}/upload`, formData, {
                headers: {
                    Authorization: `Bearer ${user?.token}`
                }
            });
            console.log(response.data);
            setMessage("Book uploaded successfully!");
            // Reset form fields
            setFile(null);
            setTitle("");
            setAuthor("");
            setPublisher("");
            setKeywords("");
        } catch (err) {
            setMessage("Error creating post");
        }
    };

    return (
        <form onSubmit={handleSubmit}>
            {message && (
                <div className="mb-4 text-green-600 font-semibold">{message}</div>
            )}
            <div className="bg-white rounded px-8 sm:px-14 py-10 border border-gray/[.17] shadow-[0_0_8px_-4px_rgba(0,0,0,0.1)]">
                <h3 className="text-3xl text-[#201A22] font-bold pb-6">Upload Book</h3>
                <div className="flex flex-col mb-4">
                    <h5 className="text-bse font-medium text-gray pb-1.5">Book Title</h5>
                    <div className="relative">
                        <input
                            type="text"
                            name="title"
                            value={title}
                            onChange={e => setTitle(e.target.value)}
                            placeholder="Enter your book title"
                            className="w-full border border-[#d1d1d1] rounded h-[52px] px-4"
                        />
                    </div>
                </div>
                <div className="flex flex-col mb-4">
                    <h5 className="text-bse font-medium text-gray pb-1.5">Author Name</h5>
                    <div className="relative">
                        <input
                            type="text"
                            name="author"
                            value={author}
                            onChange={e => setAuthor(e.target.value)}
                            placeholder="Enter author name"
                            className="w-full border border-[#d1d1d1] rounded h-[52px] px-4"
                        />
                    </div>
                </div>
                <div className="flex flex-col mb-4">
                    <h5 className="text-bse font-medium text-gray pb-1.5">Publisher Name</h5>
                    <div className="relative">
                        <input
                            type="text"
                            name="publisher"
                            value={publisher}
                            onChange={e => setPublisher(e.target.value)}
                            placeholder="Enter publisher name"
                            className="w-full border border-[#d1d1d1] rounded h-[52px] px-4"
                        />
                    </div>
                </div>
                <div className="flex flex-col mb-4">
                    <h5 className="text-bse font-medium text-gray pb-1.5">Search Keywords</h5>
                    <div className="relative">
                        <textarea
                            name="keywords"
                            value={keywords}
                            onChange={e => setKeywords(e.target.value)}
                            placeholder="Enter keywords"
                            className="w-full border border-[#d1d1d1] rounded h-[52px] px-4"></textarea>

                    </div>
                </div>
                <div className="flex flex-col mb-5">
                    <h5 className="text-bse font-medium text-gray pb-1.5">Upload Book File</h5>
                    <label className={`border-2 border-dashed border-[#c4c4c4] bg-white rounded px-6 py-14 flex flex-col items-center`}>
                        <input type="file" className="hidden" onChange={handleFileChange} />
                        <span className="flex flex-col items-center justify-center text-neutral-600">
                            {file ? (
                                <>
                                    {/* Success SVG */}
                                    <svg width="50" height="34" viewBox="0 0 50 34" fill="none" xmlns="http://www.w3.org/2000/svg" className="pb-4">
                                        <circle cx="25" cy="17" r="16" fill="#4ade80" />
                                        <path d="M17 18.5L23 24.5L33 14.5" stroke="white" strokeWidth="3" strokeLinecap="round" strokeLinejoin="round" />
                                    </svg>
                                    <span className="text-sm font-normal text-green-600 text-center">
                                        {file.name} selected
                                    </span>
                                </>
                            ) : (
                                <>
                                    {/* Default SVG */}
                                    <svg width="50" height="34" viewBox="0 0 50 34" fill="none" xmlns="http://www.w3.org/2000/svg" className="pb-4">
                                        <path d="M11.25 33.75C8.33333 33.75 5.85417 32.734 3.8125 30.7019C1.77083 28.6694 0.75 26.1854 0.75 23.25C0.75 20.375 1.78125 17.9062 3.84375 15.8438C5.90625 13.7812 8.25 12.75 10.875 12.75C11.2917 9.16667 12.8438 6.1875 15.5312 3.8125C18.2188 1.4375 21.375 0.25 25 0.25C28.9696 0.25 32.3371 1.6325 35.1025 4.3975C37.8675 7.16292 39.25 10.5304 39.25 14.5V17.75H41.25C43.5 17.75 45.3958 18.5208 46.9375 20.0625C48.4792 21.6042 49.25 23.5 49.25 25.75C49.25 28 48.5 29.8958 47 31.4375C45.5 32.9792 43.625 33.75 41.375 33.75H27.875C26.7917 33.75 25.8958 33.3958 25.1875 32.6875C24.4792 31.9792 24.125 31.0833 24.125 30V15L18.5 20.625L17.25 19.4375L25 11.6875L32.75 19.4375L31.5 20.625L25.875 15V30C25.875 30.5 26.0833 30.9583 26.5 31.375C26.9167 31.7917 27.375 32 27.875 32H41.25C43 32 44.4792 31.3958 45.6875 30.1875C46.8958 28.9792 47.5 27.5 47.5 25.75C47.5 24 46.8958 22.5208 45.6875 21.3125C44.4792 20.1042 43 19.5 41.25 19.5H37.5V14.5C37.5 11.0417 36.2812 8.09375 33.8438 5.65625C31.4062 3.21875 28.4583 2 25 2C21.5417 2 18.5938 3.21875 16.1562 5.65625C13.7188 8.09375 12.5 11.0417 12.5 14.5H11.125C8.83333 14.5 6.82292 15.3542 5.09375 17.0625C3.36458 18.7708 2.5 20.8333 2.5 23.25C2.5 25.6667 3.35417 27.7292 5.0625 29.4375C6.77083 31.1458 8.83333 32 11.25 32H17.5V33.75H11.25Z" fill="#575757" />
                                    </svg>
                                    <span className="text-sm font-normal text-[#575757] text-center">
                                        Click To Upload or Drag & Drop Your File Here
                                    </span>
                                </>
                            )}
                        </span>
                    </label>
                    <span className="text-xs font-normal text-[#7e7e7e] pt-3">Supported formats: PDF, DOC, ePUB. Max file size: 10MB.</span>
                </div>
                <div className="flex justify-end">
                    <button type="submit" className="cursor-pointer bg-primary text-white text-[15px] font-normal h-12 rounded min-w-40">Submit</button>
                </div>
            </div>
        </form>
    )
}