"use client"
import { useEffect, useRef, useState } from "react";
import { motion } from "framer-motion";
import Link from "next/link";
import Image from "next/image";
import { wade } from "@/assets/images";
import { useAuth } from "@/context/AuthContext";
import { useRouter } from "next/navigation";

export default function Header(){

    const [isOpen, setIsOpen] = useState(false);
    const [isNotificaion, setIsNotificaion] = useState(false);
    const dropdownRef = useRef(null);
    const NotificaionRef = useRef(null);
    const router = useRouter();
    const { user, logout } = useAuth();    

    const handleLogout = () => {
        logout();
        router.push("/login");
    };

    // Close dropdown when clicking outside
    useEffect(() => {
        function handleClickOutside(event) {
            if (dropdownRef.current && !dropdownRef.current.contains(event.target)) {
                setIsOpen(false);
            }

            if (NotificaionRef.current && !NotificaionRef.current.contains(event.target)) {
                setIsNotificaion(false);
            }
        }
        document.addEventListener("click", handleClickOutside);
        return () => document.removeEventListener("click", handleClickOutside);
    }, []);
   
    return(
        <header className="flex justify-end items-center py-5 pl-4 pr-4 sm:pr-8 bg-[#fbfbfb]">
            <div className="flex items-center space-x-1">
                <div className="relative pl-2" ref={dropdownRef}>
                    <button onClick={() => setIsOpen(!isOpen)} className="flex items-center text-gray-700 font-medium cursor-pointer">
                        <div className="pr-3 text-right">
                            <p className="text-sm font-medium">
                                {user ? user.name : "Guest"}
                            </p>
                        </div>
                        <Image width={40} height={40} src={wade} alt="user" className="w-10 h-10 rounded-full object-cover"/>
                    </button>

                    {/* Dropdown Menu */}
                    {isOpen && (
                        <motion.div
                            initial={{ opacity: 0, y: 10 }}
                            animate={{ opacity: 1, y: 0 }}
                            exit={{ opacity: 0, y: 10 }}
                            transition={{ duration: 0.2 }}
                            className="absolute z-10 left-0 top-full py-4  space-y-2 mt-2 w-36 bg-white shadow-xl shadow-neutral-200 border border-neutral-100 rounded-md px-2"
                        >
                            <Link href={'/settings'} className="flex items-center text-sm px-3 py-1.5 text-neutral-500 hover:text-primary">
                                <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" strokeWidth={1.5} stroke="currentColor" className="size-5">
                                        <path strokeLinecap="round" strokeLinejoin="round" d="M9.594 3.94c.09-.542.56-.94 1.11-.94h2.593c.55 0 1.02.398 1.11.94l.213 1.281c.063.374.313.686.645.87.074.04.147.083.22.127.325.196.72.257 1.075.124l1.217-.456a1.125 1.125 0 0 1 1.37.49l1.296 2.247a1.125 1.125 0 0 1-.26 1.431l-1.003.827c-.293.241-.438.613-.43.992a7.723 7.723 0 0 1 0 .255c-.008.378.137.75.43.991l1.004.827c.424.35.534.955.26 1.43l-1.298 2.247a1.125 1.125 0 0 1-1.369.491l-1.217-.456c-.355-.133-.75-.072-1.076.124a6.47 6.47 0 0 1-.22.128c-.331.183-.581.495-.644.869l-.213 1.281c-.09.543-.56.94-1.11.94h-2.594c-.55 0-1.019-.398-1.11-.94l-.213-1.281c-.062-.374-.312-.686-.644-.87a6.52 6.52 0 0 1-.22-.127c-.325-.196-.72-.257-1.076-.124l-1.217.456a1.125 1.125 0 0 1-1.369-.49l-1.297-2.247a1.125 1.125 0 0 1 .26-1.431l1.004-.827c.292-.24.437-.613.43-.991a6.932 6.932 0 0 1 0-.255c.007-.38-.138-.751-.43-.992l-1.004-.827a1.125 1.125 0 0 1-.26-1.43l1.297-2.247a1.125 1.125 0 0 1 1.37-.491l1.216.456c.356.133.751.072 1.076-.124.072-.044.146-.086.22-.128.332-.183.582-.495.644-.869l.214-1.28Z" />
                                        <path strokeLinecap="round" strokeLinejoin="round" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                                    </svg>
                                </span>
                                <span  className="pl-2">
                                    Settings
                                </span>
                            </Link>
                            <button
                                onClick={handleLogout}
                                className="flex items-center text-sm px-3 py-1.5 text-red-400 hover:bg-red-100/50 rounded w-full"
                            >
                                <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" strokeWidth={1.5} stroke="currentColor" className="size-5">
                                        <path strokeLinecap="round" strokeLinejoin="round" d="M8.25 9V5.25A2.25 2.25 0 0 1 10.5 3h6a2.25 2.25 0 0 1 2.25 2.25v13.5A2.25 2.25 0 0 1 16.5 21h-6a2.25 2.25 0 0 1-2.25-2.25V15m-3 0-3-3m0 0 3-3m-3 3H15" />
                                    </svg>
                                </span>
                                <span  className="pl-2">
                                    Logout
                                </span>
                            </button>
                        </motion.div>
                    )}
                </div>
            </div>
            
        </header>
    )
}