'use client'
import Image from "next/image";
import useEmblaCarousel from 'embla-carousel-react'
import Fade from 'embla-carousel-fade'
import { DotButton, useDotButton } from '@/components/EmblaControler/DotButton'
import Autoplay from 'embla-carousel-autoplay'
import {jade, wade} from '@/assets/images'
  

export default function ReviewCarousel(){
    const [emblaRef, emblaApi] = useEmblaCarousel({ loop: true, duration: 30 }, [Fade(), Autoplay()])
    const { selectedIndex, scrollSnaps, onDotButtonClick } = useDotButton(emblaApi);

    const reviews = [
        {
            id: 1,
            msg: "<p>Authorguard made it easy for me to secure my manuscripts and reach a wider audience. Highly recommended for every serious author!</p>",
            client: {
                name: "Wade Warren",
                position: "Author",
                img: wade,
            }
        },
        {
            id: 2,
            msg: "<p>Authorguard made it easy for me to secure my manuscripts and reach a wider audience. Highly recommended for every serious author!</p>",
            client: {
                name: "Jade Turing",
                position: "Author",
                img: jade,
            }
        },
        {
            id: 3,
            msg: "<p>Authorguard made it easy for me to secure my manuscripts and reach a wider audience. Highly recommended for every serious author!</p>",
            client: {
                name: "Wade Warren",
                position: "Author",
                img: wade,
            }
        },
        {
            id: 4,
            msg: "<p>Authorguard made it easy for me to secure my manuscripts and reach a wider audience. Highly recommended for every serious author!</p>",
            client: {
                name: "Jade Turing",
                position: "Author",
                img: jade,
            }
        },
    ]

    return(
        <div className="relative">
            <div className="embla review_carousel -mx-2" ref={emblaRef}>
                <div className="embla__container">
                    {reviews.map((review, r) => (
                        <div className="embla__slide px-2" key={r}>
                            <div className="bg-white p-5 xl:px-7 xl:py-5 2xl:px-9 2xl:py-6 rounded-sm">
                                <h3 className="text-sm xl:text-base font-normal text-[#676767] mb-5 line-clamp-3 capitalize" dangerouslySetInnerHTML={{ __html: review.msg }}></h3>
                                <div className="flex items-center">
                                    <Image className="rounded-full w-10 h-10 xl:w-10 xl:h-10" src={review.client.img} alt={review.client.name} width="auto" height="auto" />
                                    <div className="pl-3.5">
                                        <h4 className="text-sm lg:text-base text-black font-medium">{review.client.name}</h4>
                                        <p className="text-[13px] text-[#575757] font-medium">{review.client.position}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    ))}
                </div>
            </div>
            <div className="embla__controls">
                <div className="embla__dots">
                    {scrollSnaps.map((_, index) => (
                        <DotButton key={index} onClick={() => onDotButtonClick(index)} className={'embla__dot'.concat( index === selectedIndex ? ' embla__dot--selected' : '')}/>
                    ))}
                </div>
            </div>
        </div>
    )
}