"use client";
import { EyeCloseIcon, EyeIcon } from "@/assets/images";
import Image from "next/image";
import Link from "next/link";
import React, { useState, useEffect } from "react";
import { useRouter } from "next/navigation";
import axios from "axios";
import { useAuth } from "@/context/AuthContext";

export default function SignInForm() {
  const [showPassword, setShowPassword] = useState(false);
  const [isChecked, setIsChecked] = useState(false);
  const [form, setForm] = useState({ email: "", password: "" });
  const [message, setMessage] = useState("");
  const [ip, setIp] = useState("");
  const [submitting, setSubmitting] = useState(false);
  const router = useRouter();
  const { login } = useAuth();

  const apiUrl = process.env.NEXT_PUBLIC_API_URL;

  useEffect(() => {
  fetch('https://api.ipify.org?format=json')
    .then(res => res.json())
    .then(data => {
      console.log("Public IP:", data.ip);
      setIp(data.ip);
    });
}, []);


  const handleChange = (e) => {
    setForm({ ...form, [e.target.name]: e.target.value });
  };

  const handleSignIn = async (e) => {
    e.preventDefault();
    setMessage("");
    if (!form.email || !form.password) {
      setMessage("Email and password are required.");
      return;
    }
    setSubmitting(true);
    try {
      const response = await axios.post(`${apiUrl}/auth/signin`, {
        email: form.email,
        password: form.password,
        ip: ip
      });
      setMessage(response.data.message || "Login successful!");
      login(response.data); // Save user globally
      if(response.data.userType === "Ad") {
        router.push("/admindashboard");
        return;
      }else{
        router.push("/");
      }
      
    } catch (err) {
      setMessage(err.response?.data?.error || "Login failed.");
    }
    setSubmitting(false);
  };

  return (
    <div className="flex flex-col flex-1 w-full md:w-1/2 py-10 md:py-12 md:h-screen md:overflow-y-auto scroll_bar">
      <div className="flex flex-col justify-center flex-1 max-w-md xl:max-w-lg w-full mx-auto px-5 md:px-8">
        <div>
          <div className="mb-7 sm:mb-10">
            <h3 className="mb-2 md:mb-3 font-semibold text-gray text-3xl lg:text-4xl xl:text-[42px] lg:leading-12">
              Get Started Now
            </h3>
            <p className="text-sm lg:text-base xl:text-lg font-normal text-[#575757]">
              Enter your credentials to access your account
            </p>
          </div>
          <div>
            <form onSubmit={handleSignIn}>
              <div className="space-y-6">
                <div>
                  <label className="mb-1.5 block text-sm font-medium text-gray-700 ">
                    Email Address
                  </label>
                  <div className="relative">
                    <input
                      placeholder="info@gmail.com"
                      type="email"
                      name="email"
                      value={form.email}
                      onChange={handleChange}
                      className="h-[52px] w-full rounded-sm border appearance-none px-4 py-2.5 text-sm shadow-theme-xs placeholder:text-gray-400 focus:outline-hidden bg-transparent text-gray-800 border-gray-300 focus:border-brand-300 focus:ring-brand-500/20"
                      required
                    />
                  </div>
                </div>
                <div>
                  <label className="mb-1.5 block text-sm font-medium text-gray-700 ">
                    Password
                  </label>
                  <div className="relative">
                    <input
                      type={showPassword ? "text" : "password"}
                      name="password"
                      value={form.password}
                      onChange={handleChange}
                      placeholder="Enter your password"
                      className="h-[52px] w-full rounded-sm border appearance-none pl-4 pr-12 py-2.5 text-sm shadow-theme-xs placeholder:text-gray-400 focus:outline-hidden bg-transparent text-gray-800 border-gray-300 focus:border-brand-300 focus:ring-brand-500/20"
                      required
                    />
                    <span
                      onClick={() => setShowPassword(!showPassword)}
                      className="absolute z-30 opacity-50 -translate-y-1/2 cursor-pointer right-4 top-1/2"
                    >
                      {showPassword ? (
                        <Image width={24} height={24} src={EyeIcon} alt="Show" />
                      ) : (
                        <Image width={24} height={24} src={EyeCloseIcon} alt="Hide" />
                      )}
                    </span>
                  </div>
                </div>
                <div className="flex items-center justify-between">
                  <div className="flex items-center gap-3">
                    <input
                      type="checkbox"
                      checked={isChecked}
                      onChange={() => setIsChecked(!isChecked)}
                      className="w-5 h-5 cursor-pointer border border-gray-300 checked:border-transparent rounded-sm checked:bg-brand-500 disabled:opacity-60"
                    />
                    <span className="block font-normal text-gray-700 text-sm ">
                      Remember me
                    </span>
                  </div>
                  <Link
                    href="/reset-password"
                    className="text-sm text-[#3D4873] hover:text-[#3D4873]/80 "
                  >
                    Forgot password?
                  </Link>
                </div>
                <div className="flex flex-col items-center text-center pt-5">
                  <button
                    type="submit"
                    disabled={submitting}
                    className="h-15 items-center justify-center text-base gap-2 rounded-sm w-full transition px-4 py-2.5 bg-primary text-white hover:bg-primaryDark cursor-pointer"
                  >
                    {submitting ? "Signing in..." : "Sign in"}
                  </button>
                  <p className="text-[13px] leading-5 text-gray py-3">
                    Don&apos;t have an account?{" "}
                    <Link href="/signup" className="text-primary">
                      Create Account
                    </Link>
                  </p>
                  {message && (
                    <div className="mt-2 text-center text-sm text-red-600">
                      {message}
                    </div>
                  )}
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  );
}
