export default function StatusScale({ scale }) {
    const numericScale = Number(scale);
    const bgColor = numericScale > 0 && numericScale < 25
        ? 'bg-green-600'
        : numericScale >= 25 && numericScale < 50
        ? 'bg-amber-500'
        : 'bg-red-400';

    return (
        <div className="relative max-w-sm w-full h-2 bg-[#e9e9e9] rounded-md">
            <span className={`absolute left-0 top-0 h-full rounded ${bgColor}`} style={{ width: `${numericScale}%` }} ></span>
        </div>
    );
}