export function getOrdinal(n) {
  const s = ["th", "st", "nd", "rd"],
    v = n % 100;
  return n + (s[(v - 20) % 10] || s[v] || s[0]);
}

export function formatDateWithOrdinal(dateString) {
  if (!dateString) return "";

  // Match DD/MM/YYYY or DD/MM/YYYY HH:mm or DD/MM/YYYYTHH:mm
  const dmYMatch = dateString.match(
    /^(\d{1,2})\/(\d{1,2})\/(\d{4})(?:[ T\-]+(\d{1,2}):(\d{2}))?/
  );
  let date;
  let hasTime = false;
  if (dmYMatch) {
    const day = parseInt(dmYMatch[1], 10);
    const month = parseInt(dmYMatch[2], 10) - 1;
    const year = parseInt(dmYMatch[3], 10);
    const hour = dmYMatch[4] ? parseInt(dmYMatch[4], 10) : 0;
    const minute = dmYMatch[5] ? parseInt(dmYMatch[5], 10) : 0;
    date = new Date(year, month, day, hour, minute);
    hasTime = !!dmYMatch[4];
  } else {
    date = new Date(dateString);
    hasTime = dateString.includes("T") || dateString.includes(":");
  }

  if (isNaN(date.getTime())) return "";

  const month = date.toLocaleString("default", { month: "long" });
  const day = getOrdinal(date.getDate());
  const year = date.getFullYear();
  let formatted = `${month} ${day}, ${year}`;

  // Add time if present and not midnight
  if (hasTime && (date.getHours() !== 0 || date.getMinutes() !== 0)) {
    const time = date.toLocaleTimeString([], { hour: "2-digit", minute: "2-digit" });
    formatted += ` - ${time}`;
  }
  return formatted;
}

export function formatOnlyDate(dateString) {
  if (!dateString) return "";

  // Match DD/MM/YYYY or DD/MM/YYYY HH:mm or DD/MM/YYYYTHH:mm
  const dmYMatch = dateString.match(
    /^(\d{1,2})\/(\d{1,2})\/(\d{4})(?:[ T\-]+(\d{1,2}):(\d{2}))?/
  );
  let date;
  let hasTime = false;
  if (dmYMatch) {
    const day = parseInt(dmYMatch[1], 10);
    const month = parseInt(dmYMatch[2], 10) - 1;
    const year = parseInt(dmYMatch[3], 10);
    const hour = dmYMatch[4] ? parseInt(dmYMatch[4], 10) : 0;
    const minute = dmYMatch[5] ? parseInt(dmYMatch[5], 10) : 0;
    date = new Date(year, month, day, hour, minute);
    hasTime = !!dmYMatch[4];
  } else {
    date = new Date(dateString);
    hasTime = dateString.includes("T") || dateString.includes(":");
  }

  if (isNaN(date.getTime())) return "";

  const month = date.toLocaleString("default", { month: "long" });
  const day = getOrdinal(date.getDate());
  const year = date.getFullYear();
  let formatted = `${month} ${day}, ${year}`;

 
  return formatted;
}